/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

@BA.Hide
public class Touchpad
extends Widget {
    private TouchpadStyle l;
    private boolean m;
    private boolean n = true;
    private float o;
    private final Circle p = new Circle(0.0f, 0.0f, 0.0f);
    private final Circle q = new Circle(0.0f, 0.0f, 0.0f);
    private final Circle r = new Circle(0.0f, 0.0f, 0.0f);
    protected Vector2 knobPosition = new Vector2();
    private final Vector2 s = new Vector2();

    public Touchpad() {
    }

    public Touchpad(float deadzoneRadius, Skin skin) {
        this(deadzoneRadius, skin.get(TouchpadStyle.class));
    }

    public Touchpad(float deadzoneRadius, Skin skin, String styleName) {
        this(deadzoneRadius, skin.get(styleName, TouchpadStyle.class));
    }

    public Touchpad(float deadzoneRadius, TouchpadStyle style) {
        if (deadzoneRadius < 0.0f) {
            throw new IllegalArgumentException("deadzoneRadius must be > 0");
        }
        this.o = deadzoneRadius;
        this.knobPosition.set(this.getWidth() / 2.0f, this.getHeight() / 2.0f);
        this.setStyle(style);
        Touchpad touchpad = this;
        touchpad.setSize(touchpad.getPrefWidth(), this.getPrefHeight());
        this.addListener(new InputListener(this){
            private /* synthetic */ Touchpad a;
            {
                this.a = touchpad;
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                return this.a.TouchDown(x, y);
            }

            @Override
            public final void touchDragged(InputEvent event, float x, float y, int pointer) {
                this.a.TouchDragged(x, y);
            }

            @Override
            public final void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                this.a.TouchUp(x, y);
            }
        });
    }

    public boolean TouchDown(float x, float y) {
        if (this.m) {
            return false;
        }
        this.m = true;
        this.a(x, y, false);
        return true;
    }

    public void TouchDragged(float x, float y) {
        this.a(x, y, false);
    }

    public void TouchUp(float x, float y) {
        this.m = false;
        this.a(x, y, this.n);
    }

    private void a(float f, float f2, boolean bl) {
        float f3 = this.knobPosition.x;
        float f4 = this.knobPosition.y;
        float f5 = this.s.x;
        float f6 = this.s.y;
        float f7 = this.p.x;
        float f8 = this.p.y;
        this.knobPosition.set(f7, f8);
        this.s.set(0.0f, 0.0f);
        if (!bl && !this.r.contains(f, f2)) {
            float f9;
            this.s.set((f - f7) / this.p.radius, (f2 - f8) / this.p.radius);
            float f10 = this.s.len();
            if (f9 > 1.0f) {
                this.s.scl(1.0f / f10);
            }
            if (this.p.contains(f, f2)) {
                this.knobPosition.set(f, f2);
            } else {
                this.knobPosition.set(this.s).nor().scl(this.p.radius).add2(this.p.x, this.p.y);
            }
        }
        if (f5 != this.s.x || f6 != this.s.y) {
            ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
            if (this.fire(changeEvent)) {
                this.s.set(f5, f6);
                this.knobPosition.set(f3, f4);
            }
            Pools.free(changeEvent);
        }
    }

    public void setStyle(TouchpadStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null");
        }
        this.l = style;
        this.invalidateHierarchy();
    }

    public TouchpadStyle getStyle() {
        return this.l;
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        if (this.q.contains(x, y)) {
            return this;
        }
        return null;
    }

    @Override
    @BA.Hide
    public void layout() {
        float f = this.getWidth() / 2.0f;
        float f2 = this.getHeight() / 2.0f;
        float f3 = Math.min(f, f2);
        this.q.Set(f, f2, f3);
        if (this.l.knob != null) {
            f3 -= Math.max(this.l.knob.getMinWidth(), this.l.knob.getMinHeight()) / 2.0f;
        }
        this.p.Set(f, f2, f3);
        this.r.Set(f, f2, this.o);
        this.knobPosition.set(f, f2);
        this.s.set(0.0f, 0.0f);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Drawable drawable;
        this.validate();
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        float f = this.getX();
        float f2 = this.getY();
        float f3 = this.getWidth();
        float f4 = this.getHeight();
        Drawable drawable2 = this.l.background;
        if (drawable2 != null) {
            drawable2.draw(batch, f, f2, f3, f4);
        }
        if ((drawable = this.l.knob) != null) {
            drawable.draw(batch, f += this.knobPosition.x - drawable.getMinWidth() / 2.0f, f2 += this.knobPosition.y - drawable.getMinHeight() / 2.0f, drawable.getMinWidth(), drawable.getMinHeight());
        }
    }

    @Override
    public float getPrefWidth() {
        if (this.l.background != null) {
            return this.l.background.getMinWidth();
        }
        return 0.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.l.background != null) {
            return this.l.background.getMinHeight();
        }
        return 0.0f;
    }

    public boolean isTouched() {
        return this.m;
    }

    public boolean getResetOnTouchUp() {
        return this.n;
    }

    public void setResetOnTouchUp(boolean reset) {
        this.n = reset;
    }

    public void setDeadzone(float deadzoneRadius) {
        if (deadzoneRadius < 0.0f) {
            throw new IllegalArgumentException("deadzoneRadius must be > 0");
        }
        this.o = deadzoneRadius;
        this.invalidate();
    }

    public float getKnobX() {
        return this.knobPosition.x;
    }

    public float getKnobY() {
        return this.knobPosition.y;
    }

    public float getKnobPercentX() {
        return this.s.x;
    }

    public float getKnobPercentY() {
        return this.s.y;
    }

    @BA.Hide
    public static class TouchpadStyle {
        public Drawable background;
        public Drawable knob;

        public TouchpadStyle() {
        }

        public TouchpadStyle(Drawable background, Drawable knob) {
            this.background = background;
            this.knob = knob;
        }

        public TouchpadStyle(TouchpadStyle style) {
            this.background = style.background;
            this.knob = style.knob;
        }
    }
}

