/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.graphics.lgBitmapFont;
import anywheresoftware.b4a.libgdx.scene2d.lgLabel;
import anywheresoftware.b4a.libgdx.scene2d.lgTable;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

@BA.Hide
public class Window
extends lgTable {
    private static final Vector2 u = new Vector2();
    private static final Vector2 v = new Vector2();
    private WindowStyle w;
    boolean m = true;
    boolean n;
    boolean p;
    int q = 8;
    boolean r;
    boolean s = true;
    private lgLabel x;
    private lgTable y;
    boolean t;
    protected InputListener CaptureListnr;
    protected InputListener RegularListnr;

    public Window() {
    }

    public Window(String title, Skin skin) {
        this(title, skin.get(WindowStyle.class));
        this.setSkin(skin);
    }

    public Window(String title, Skin skin, String styleName) {
        this(title, skin.get(styleName, WindowStyle.class));
        this.setSkin(skin);
    }

    public Window(String title, WindowStyle style) {
        this.Init(title, style);
    }

    protected void Init(String title, WindowStyle style) {
        if (title == null) {
            throw new IllegalArgumentException("title cannot be null.");
        }
        this.setTouchable(Touchable.enabled);
        this.setClip(true);
        this.x = new lgLabel();
        this.x.Initialize2(this._ba, title, new lgBitmapFont(style.titleFont), style.titleFontColor, "");
        this.x.setEllipsis(true);
        this.y = new lgTable(this){
            private /* synthetic */ Window m;
            {
                this.m = window;
            }

            @Override
            public final void draw(Batch batch, float parentAlpha) {
                if (this.m.t) {
                    super.draw(batch, parentAlpha);
                }
            }
        };
        this.y.Initialize(this._ba, "");
        this.y.add(this.x).expandX().fillX().minWidth(0.0f);
        Window window = this;
        window.addActor(window.y);
        this.setStyle(style);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.CaptureListnr = new InputListener(this){
            private /* synthetic */ Window a;
            {
                this.a = window;
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                this.a.toFront();
                return false;
            }
        };
        this.addCaptureListener(this.CaptureListnr);
        this.RegularListnr = new InputListener(this){
            private int a;
            private float b;
            private float c;
            private float d;
            private float e;
            private /* synthetic */ Window f;
            {
                this.f = window;
            }

            @Override
            public final boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (button == 0) {
                    int n = this.f.q;
                    float f = this.f.getWidth();
                    float f2 = this.f.getHeight();
                    this.a = 0;
                    if (this.f.p && x >= 0.0f && x < f && y >= 0.0f && y < f2) {
                        if (x < (float)n) {
                            this.a |= 8;
                        }
                        if (x > f - (float)n) {
                            this.a |= 0x10;
                        }
                        if (y < (float)n) {
                            this.a |= 4;
                        }
                        if (y > f2 - (float)n) {
                            this.a |= 2;
                        }
                        if (this.a != 0) {
                            n += 25;
                        }
                        if (x < (float)n) {
                            this.a |= 8;
                        }
                        if (x > f - (float)n) {
                            this.a |= 0x10;
                        }
                        if (y < (float)n) {
                            this.a |= 4;
                        }
                        if (y > f2 - (float)n) {
                            this.a |= 2;
                        }
                    }
                    if (this.f.m && this.a == 0 && y <= f2 && y >= f2 - this.f.getPadTop() && x >= 0.0f && x <= f) {
                        this.a = 32;
                    }
                    this.f.r = this.a != 0;
                    this.b = x;
                    this.c = y;
                    this.d = x;
                    this.e = y;
                }
                super.touchDown(event, x, y, pointer, button);
                return this.a != 0 || this.f.n;
            }

            @Override
            public final void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                this.f.r = false;
                super.touchUp(event, x, y, pointer, button);
            }

            @Override
            public final void touchDragged(InputEvent event, float x, float y, int pointer) {
                float f;
                boolean bl;
                if (!this.f.r) {
                    return;
                }
                float f2 = this.f.getWidth();
                float f3 = this.f.getHeight();
                float f4 = this.f.getX();
                float f5 = this.f.getY();
                float f6 = this.f.getMinWidth();
                float f7 = this.f.getMinHeight();
                Stage stage = this.f.getStage();
                boolean bl2 = bl = this.f.s && this.f.getParent() == stage.getRoot();
                if ((this.a & 0x20) != 0) {
                    f = x - this.b;
                    float f8 = y - this.c;
                    f4 += f;
                    f5 += f8;
                }
                if ((this.a & 8) != 0) {
                    f = x - this.b;
                    if (f2 - f < f6) {
                        f = -(f6 - f2);
                    }
                    if (bl && f4 + f < 0.0f) {
                        f = -f4;
                    }
                    f2 -= f;
                    f4 += f;
                }
                if ((this.a & 4) != 0) {
                    f = y - this.c;
                    if (f3 - f < f7) {
                        f = -(f7 - f3);
                    }
                    if (bl && f5 + f < 0.0f) {
                        f = -f5;
                    }
                    f3 -= f;
                    f5 += f;
                }
                if ((this.a & 0x10) != 0) {
                    f = x - this.d;
                    if (f2 + f < f6) {
                        f = f6 - f2;
                    }
                    if (bl && f4 + f2 + f > stage.getWidth()) {
                        f = stage.getWidth() - f4 - f2;
                    }
                    f2 += f;
                }
                if ((this.a & 2) != 0) {
                    f = y - this.e;
                    if (f3 + f < f7) {
                        f = f7 - f3;
                    }
                    if (bl && f5 + f3 + f > stage.getHeight()) {
                        f = stage.getHeight() - f5 - f3;
                    }
                    f3 += f;
                }
                this.d = x;
                this.e = y;
                this.f.SetBounds(Math.round(f4), Math.round(f5), Math.round(f2), Math.round(f3));
                super.touchDragged(event, x, y, pointer);
            }

            @Override
            public final boolean keyDown(InputEvent event, int keycode) {
                return this.f.n;
            }

            @Override
            public final boolean keyUp(InputEvent event, int keycode) {
                return this.f.n;
            }

            @Override
            public final boolean keyTyped(InputEvent event, char character) {
                return this.f.n;
            }
        };
        this.addListener(this.RegularListnr);
    }

    public void setStyle(WindowStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.w = style;
        this.setTblBackground(style.background);
        this.x.setStyle(new Label.LabelStyle(style.titleFont, style.titleFontColor));
        this.invalidateHierarchy();
    }

    public WindowStyle getStyle() {
        return this.w;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Stage stage = this.getStage();
        if (stage.getKeyboardFocus() == null) {
            stage.setKeyboardFocus(this);
        }
        Window window = this;
        if (window.s) {
            Stage stage2 = window.getStage();
            Camera camera = stage2.getCamera();
            if (camera instanceof OrthographicCamera) {
                OrthographicCamera orthographicCamera = (OrthographicCamera)camera;
                float f = stage2.getWidth();
                float f2 = stage2.getHeight();
                if (window.getX(16) - camera.position.x > f / 2.0f / orthographicCamera.zoom) {
                    window.setPosition(camera.position.x + f / 2.0f / orthographicCamera.zoom, window.getY(16), 16);
                }
                if (window.getX(8) - camera.position.x < -f / 2.0f / orthographicCamera.zoom) {
                    window.setPosition(camera.position.x - f / 2.0f / orthographicCamera.zoom, window.getY(8), 8);
                }
                if (window.getY(2) - camera.position.y > f2 / 2.0f / orthographicCamera.zoom) {
                    Window window2 = window;
                    window2.setPosition(window2.getX(2), camera.position.y + f2 / 2.0f / orthographicCamera.zoom, 2);
                }
                if (window.getY(4) - camera.position.y < -f2 / 2.0f / orthographicCamera.zoom) {
                    Window window3 = window;
                    window3.setPosition(window3.getX(4), camera.position.y - f2 / 2.0f / orthographicCamera.zoom, 4);
                }
            } else if (window.getParent() == stage2.getRoot()) {
                float f = stage2.getWidth();
                float f3 = stage2.getHeight();
                if (window.getX() < 0.0f) {
                    window.setX(0.0f);
                }
                if (window.getRight() > f) {
                    window.setX(f - window.getWidth());
                }
                if (window.getY() < 0.0f) {
                    window.setY(0.0f);
                }
                if (window.getTop() > f3) {
                    window.setY(f3 - window.getHeight());
                }
            }
        }
        if (this.w.stageBackground != null) {
            this.stageToLocalCoordinates(u.set(0.0f, 0.0f));
            this.stageToLocalCoordinates(v.set(stage.getWidth(), stage.getHeight()));
            this.drawStageBackground(batch, parentAlpha, this.getX() + Window.u.x, this.getY() + Window.u.y, this.getX() + Window.v.x, this.getY() + Window.v.y);
        }
        super.draw(batch, parentAlpha);
    }

    protected void drawStageBackground(Batch batch, float parentAlpha, float x, float y, float width, float height) {
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.w.stageBackground.draw(batch, x, y, width, height);
    }

    @Override
    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        super.drawBackground(batch, parentAlpha, x, y);
        this.y.getColor().a = this.getColor().a;
        float f = this.getPadTop();
        float f2 = this.getPadLeft();
        this.y.setSize(this.getWidth() - f2 - this.getPadRight(), f);
        this.y.setPosition(f2, this.getHeight() - f);
        this.t = true;
        this.y.draw(batch, parentAlpha);
        this.t = false;
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        Actor actor = super.hit(x, y, touchable);
        if (actor == null && this.n && (!touchable || this.getTouchable() == Touchable.enabled)) {
            return this;
        }
        float f = this.getHeight();
        if (actor == null || actor == this) {
            return actor;
        }
        if (y <= f && y >= f - this.getPadTop() && x >= 0.0f && x <= this.getWidth()) {
            Actor actor2 = actor;
            while (actor2.getParent() != this) {
                actor2 = actor2.getParent();
            }
            if (this.getCell(actor2) != null) {
                return this;
            }
        }
        return actor;
    }

    @BA.Hide
    public boolean isMovable() {
        return this.m;
    }

    public void setMovable(boolean isMovable) {
        this.m = isMovable;
    }

    @BA.Hide
    public boolean isModal() {
        return this.n;
    }

    public void setModal(boolean isModal) {
        this.n = isModal;
    }

    public void setKeepWithinStage(boolean keepWithinStage) {
        this.s = keepWithinStage;
    }

    @BA.Hide
    public boolean isResizable() {
        return this.p;
    }

    public void setResizable(boolean isResizable) {
        this.p = isResizable;
    }

    public void setResizeBorder(int resizeBorder) {
        this.q = resizeBorder;
    }

    public boolean isDragging() {
        return this.r;
    }

    @Override
    public float getPrefWidth() {
        return Math.max(super.getPrefWidth(), this.x.getPrefWidth() + this.getPadLeft() + this.getPadRight());
    }

    public lgTable getTitleTable() {
        return this.y;
    }

    public lgLabel getTitleLabel() {
        return this.x;
    }

    @BA.Hide
    public static class WindowStyle {
        public Drawable background;
        @BA.Hide
        public BitmapFont titleFont;
        public Color titleFontColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        public Drawable stageBackground;

        public WindowStyle() {
        }

        public WindowStyle(BitmapFont titleFont, Color titleFontColor, Drawable background) {
            this.background = background;
            this.titleFont = titleFont;
            this.titleFontColor.set(titleFontColor);
        }

        public WindowStyle(WindowStyle style) {
            this.background = style.background;
            this.titleFont = style.titleFont;
            this.titleFontColor = new Color(style.titleFontColor);
        }
    }
}

