/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.libgdx.lgGdx;
import com.badlogic.gdx.input.GestureDetector;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;

@BA.ShortName(value="lgScn2DGestureListener")
public class ActorGestureListener
implements EventListener {
    static final Vector2 a = new Vector2();
    static final Vector2 b = new Vector2();
    private GestureDetector e;
    InputEvent c;
    Actor d;
    private Actor f;
    private BA g;
    private String h;
    private String i;
    private String j;
    private String k;
    private String l;
    private String m;
    private String n;
    private String o;
    private static boolean p;

    public ActorGestureListener Initialize(BA ba, String EvtPrefix) {
        return this.Initialize2(ba, 20.0f, 0.4f, 1.1f, 0.05f, EvtPrefix);
    }

    public ActorGestureListener Initialize2(BA ba, float HalfTapSquareSize, float TapCountInterval, float LongPressDuration, float MaxFlingDelay, String EvtPrefix) {
        if (ba != null && ba.service != null && ba.getClassNameWithoutPackage().equals("wallpaperservice")) {
            BA.Log((String)"The gesture listeners are not compatible with Live Wallpapers.");
            return null;
        }
        this.g = ba;
        this.h = "";
        this.i = "";
        this.j = "";
        this.l = "";
        this.k = "";
        this.m = "";
        this.n = "";
        this.o = "";
        if (EvtPrefix.length() > 0) {
            EvtPrefix = EvtPrefix.toLowerCase(BA.cul);
            this.h = String.valueOf(EvtPrefix) + "_touchdown";
            this.i = String.valueOf(EvtPrefix) + "_touchup";
            this.j = String.valueOf(EvtPrefix) + "_tap";
            this.l = String.valueOf(EvtPrefix) + "_fling";
            this.k = String.valueOf(EvtPrefix) + "_longpress";
            this.m = String.valueOf(EvtPrefix) + "_pan";
            this.n = String.valueOf(EvtPrefix) + "_pinch";
            this.o = String.valueOf(EvtPrefix) + "_zoom";
        }
        p = lgGdx.App().getLogLevel() >= 3;
        this.e = new GestureDetector(HalfTapSquareSize, TapCountInterval, LongPressDuration, MaxFlingDelay, new GestureDetector.GestureAdapter(this){
            private final Vector2 a = new Vector2();
            private final Vector2 b = new Vector2();
            private final Vector2 c = new Vector2();
            private final Vector2 d = new Vector2();
            private /* synthetic */ ActorGestureListener e;
            {
                this.e = actorGestureListener;
            }

            @Override
            public final boolean tap(float stageX, float stageY, int count, int button) {
                this.e.d.stageToLocalCoordinates(a.set(stageX, stageY));
                this.e.tap(this.e.c, ActorGestureListener.a.x, ActorGestureListener.a.y, count, button);
                return true;
            }

            @Override
            public final boolean longPress(float stageX, float stageY) {
                this.e.d.stageToLocalCoordinates(a.set(stageX, stageY));
                return this.e.longPress(this.e.d, ActorGestureListener.a.x, ActorGestureListener.a.y);
            }

            @Override
            public final boolean fling(float velocityX, float velocityY, int button) {
                this.a(a.set(velocityX, velocityY));
                this.e.fling(this.e.c, ActorGestureListener.a.x, ActorGestureListener.a.y, button);
                return true;
            }

            @Override
            public final boolean pan(float stageX, float stageY, float deltaX, float deltaY) {
                this.a(a.set(deltaX, deltaY));
                deltaX = ActorGestureListener.a.x;
                deltaY = ActorGestureListener.a.y;
                this.e.d.stageToLocalCoordinates(a.set(stageX, stageY));
                this.e.pan(this.e.c, ActorGestureListener.a.x, ActorGestureListener.a.y, deltaX, deltaY);
                return true;
            }

            @Override
            public final boolean zoom(float initialDistance, float distance) {
                this.e.zoom(this.e.c, initialDistance, distance);
                return true;
            }

            @Override
            public final boolean pinch(Vector2 stageInitialPointer1, Vector2 stageInitialPointer2, Vector2 stagePointer1, Vector2 stagePointer2) {
                this.e.d.stageToLocalCoordinates(this.a.set(stageInitialPointer1));
                this.e.d.stageToLocalCoordinates(this.b.set(stageInitialPointer2));
                this.e.d.stageToLocalCoordinates(this.c.set(stagePointer1));
                this.e.d.stageToLocalCoordinates(this.d.set(stagePointer2));
                this.e.pinch(this.e.c, this.a, this.b, this.c, this.d);
                return true;
            }

            private void a(Vector2 vector2) {
                this.e.d.stageToLocalCoordinates(vector2);
                vector2.sub(this.e.d.stageToLocalCoordinates(b.set(0.0f, 0.0f)));
            }
        });
        return this;
    }

    @Override
    public boolean handle(Event e) {
        if (!(e instanceof InputEvent)) {
            return false;
        }
        InputEvent inputEvent = (InputEvent)e;
        switch (inputEvent.getType()) {
            case touchDown: {
                this.d = inputEvent.getListenerActor();
                this.f = inputEvent.getTarget();
                this.e.touchDown(inputEvent.getStageX(), inputEvent.getStageY(), inputEvent.getPointer(), inputEvent.getButton());
                this.d.stageToLocalCoordinates(a.set(inputEvent.getStageX(), inputEvent.getStageY()));
                this.touchDown(inputEvent, ActorGestureListener.a.x, ActorGestureListener.a.y, inputEvent.getPointer(), inputEvent.getButton());
                return true;
            }
            case touchUp: {
                if (inputEvent.isTouchFocusCancel()) {
                    return false;
                }
                this.c = inputEvent;
                this.d = inputEvent.getListenerActor();
                this.e.touchUp(inputEvent.getStageX(), inputEvent.getStageY(), inputEvent.getPointer(), inputEvent.getButton());
                this.d.stageToLocalCoordinates(a.set(inputEvent.getStageX(), inputEvent.getStageY()));
                this.touchUp(inputEvent, ActorGestureListener.a.x, ActorGestureListener.a.y, inputEvent.getPointer(), inputEvent.getButton());
                return true;
            }
            case touchDragged: {
                this.c = inputEvent;
                this.d = inputEvent.getListenerActor();
                this.e.touchDragged(inputEvent.getStageX(), inputEvent.getStageY(), inputEvent.getPointer());
                return true;
            }
        }
        return false;
    }

    @BA.Hide
    public void touchDown(InputEvent event, float x, float y, int pointer, int button) {
        if (p) {
            BA.Log((String)">>> TOUCH_DOWN");
            BA.Log((String)("X=" + x + " Y=" + y + " Ptr=" + pointer));
        }
        if (this.g != null) {
            this.g.raiseEvent2((Object)this, false, this.h, false, new Object[]{event, Float.valueOf(x), Float.valueOf(y), pointer});
        }
    }

    @BA.Hide
    public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
        if (p) {
            BA.Log((String)">>> TOUCH_UP");
            BA.Log((String)("X=" + x + " Y=" + y + " Ptr=" + pointer));
        }
        if (this.g != null) {
            this.g.raiseEvent2((Object)this, false, this.i, false, new Object[]{event, Float.valueOf(x), Float.valueOf(y), pointer});
        }
    }

    @BA.Hide
    public void tap(InputEvent event, float x, float y, int count, int button) {
        if (this.g != null && this.g.subExists(this.j)) {
            if (p) {
                BA.Log((String)">>> TAP");
                BA.Log((String)("X=" + x + " Y=" + y + " Count=" + count));
            }
            this.g.raiseEvent2((Object)this, false, this.j, true, new Object[]{event, Float.valueOf(x), Float.valueOf(y), count});
        }
    }

    @BA.Hide
    public boolean longPress(Actor actor, float x, float y) {
        if (this.g != null && this.g.subExists(this.k)) {
            if (p) {
                BA.Log((String)">>> LONG_PRESS");
                BA.Log((String)("X=" + x + " Y=" + y));
            }
            return (Boolean)this.g.raiseEvent2((Object)this, false, this.k, true, new Object[]{actor, Float.valueOf(x), Float.valueOf(y)});
        }
        return false;
    }

    @BA.Hide
    public void fling(InputEvent event, float velocityX, float velocityY, int button) {
        if (this.g != null && this.g.subExists(this.l)) {
            if (p) {
                BA.Log((String)">>> FLING");
                BA.Log((String)("VelX=" + velocityX + " VelY=" + velocityY));
            }
            this.g.raiseEvent2((Object)this, false, this.l, true, new Object[]{event, Float.valueOf(velocityX), Float.valueOf(velocityY)});
        }
    }

    @BA.Hide
    public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
        if (this.g != null && this.g.subExists(this.m)) {
            if (p) {
                BA.Log((String)">>> PAN");
                BA.Log((String)("DeltaX=" + deltaX + " DeltaY=" + deltaY));
            }
            this.g.raiseEvent2((Object)this, false, this.m, true, new Object[]{event, Float.valueOf(x), Float.valueOf(y), Float.valueOf(deltaX), Float.valueOf(deltaY)});
        }
    }

    @BA.Hide
    public void zoom(InputEvent event, float initialDistance, float distance) {
        if (this.g != null && this.g.subExists(this.o)) {
            if (p) {
                BA.Log((String)">>> ZOOM");
                BA.Log((String)("InitialDist=" + initialDistance + " Distance=" + distance));
            }
            this.g.raiseEvent2((Object)this, false, this.o, true, new Object[]{event, Float.valueOf(initialDistance), Float.valueOf(distance)});
        }
    }

    @BA.Hide
    public void pinch(InputEvent event, Vector2 initialPointer1, Vector2 initialPointer2, Vector2 pointer1, Vector2 pointer2) {
        if (this.g != null && this.g.subExists(this.n)) {
            if (p) {
                BA.Log((String)">>> PINCH");
            }
            this.g.raiseEvent2((Object)this, false, this.n, true, new Object[]{event, initialPointer1, initialPointer2, pointer1, pointer2});
        }
    }

    @BA.Hide
    public GestureDetector getGestureDetector() {
        return this.e;
    }

    public Actor getTouchDownTarget() {
        return this.f;
    }
}

