/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import anywheresoftware.b4a.BA;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;

@BA.Hide
public class ScissorStack {
    private static Array<Rectangle> a = new Array();
    private static Vector3 b = new Vector3();
    private static Rectangle c = new Rectangle();

    public static boolean pushScissors(Rectangle scissor) {
        Rectangle rectangle = scissor;
        rectangle.x = Math.round(rectangle.x);
        rectangle.y = Math.round(rectangle.y);
        rectangle.width = Math.round(rectangle.width);
        rectangle.height = Math.round(rectangle.height);
        if (rectangle.width < 0.0f) {
            rectangle.width = -rectangle.width;
            rectangle.x -= rectangle.width;
        }
        if (rectangle.height < 0.0f) {
            rectangle.height = -rectangle.height;
            rectangle.y -= rectangle.height;
        }
        if (ScissorStack.a.size == 0) {
            if (scissor.width < 1.0f || scissor.height < 1.0f) {
                return false;
            }
            Gdx.gl.glEnable(3089);
        } else {
            float f;
            float f2;
            Array<Rectangle> array = a;
            Rectangle rectangle2 = array.get(array.size - 1);
            float f3 = Math.max(rectangle2.x, scissor.x);
            float f4 = Math.min(rectangle2.x + rectangle2.width, scissor.x + scissor.width);
            if (f2 - f3 < 1.0f) {
                return false;
            }
            float f5 = Math.max(rectangle2.y, scissor.y);
            float f6 = Math.min(rectangle2.y + rectangle2.height, scissor.y + scissor.height);
            if (f - f5 < 1.0f) {
                return false;
            }
            scissor.x = f3;
            scissor.y = f5;
            scissor.width = f4 - f3;
            scissor.height = Math.max(1.0f, f6 - f5);
        }
        a.add(scissor);
        Gdx.gl.glScissor((int)scissor.x, (int)scissor.y, (int)scissor.width, (int)scissor.height);
        return true;
    }

    public static Rectangle popScissors() {
        Rectangle rectangle = a.pop();
        if (ScissorStack.a.size == 0) {
            Gdx.gl.glDisable(3089);
        } else {
            Rectangle rectangle2 = a.peek();
            Gdx.gl.glScissor((int)rectangle2.x, (int)rectangle2.y, (int)rectangle2.width, (int)rectangle2.height);
        }
        return rectangle;
    }

    public static Rectangle peekScissors() {
        return a.peek();
    }

    public static void calculateScissors(Camera camera, Matrix4 batchTransform, Rectangle area, Rectangle scissor) {
        ScissorStack.calculateScissors(camera, 0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), batchTransform, area, scissor);
    }

    public static void calculateScissors(Camera camera, float viewportX, float viewportY, float viewportWidth, float viewportHeight, Matrix4 batchTransform, Rectangle area, Rectangle scissor) {
        b.set(area.x, area.y, 0.0f);
        b.mul(batchTransform);
        camera.project(b, viewportX, viewportY, viewportWidth, viewportHeight);
        scissor.x = ScissorStack.b.x;
        scissor.y = ScissorStack.b.y;
        b.set(area.x + area.width, area.y + area.height, 0.0f);
        b.mul(batchTransform);
        camera.project(b, viewportX, viewportY, viewportWidth, viewportHeight);
        scissor.width = ScissorStack.b.x - scissor.x;
        scissor.height = ScissorStack.b.y - scissor.y;
    }

    public static Rectangle getViewport() {
        if (ScissorStack.a.size == 0) {
            c.Set(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            return c;
        }
        Rectangle rectangle = a.peek();
        c.Set2(rectangle);
        return c;
    }
}

