/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Predicate;
import com.badlogic.gdx.utils.Select;
import com.badlogic.gdx.utils.Sort;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Array<T>
implements Iterable<T> {
    public T[] items;
    public int size;
    public boolean ordered;
    private ArrayIterable a;
    private Predicate.PredicateIterable<T> b;

    public Array() {
        this(true, 16);
    }

    public Array(int capacity) {
        this(true, capacity);
    }

    public Array(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new Object[capacity];
    }

    public Array(boolean ordered, int capacity, Class arrayType) {
        this.ordered = ordered;
        this.items = (Object[])ArrayReflection.newInstance(arrayType, capacity);
    }

    public Array(Class arrayType) {
        this(true, 16, arrayType);
    }

    public Array(Array<? extends T> array) {
        this(array.ordered, array.size, array.items.getClass().getComponentType());
        this.size = array.size;
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public Array(T[] array) {
        this(true, array, 0, array.length);
    }

    public Array(boolean ordered, T[] array, int start, int count) {
        this(ordered, count, array.getClass().getComponentType());
        this.size = count;
        System.arraycopy(array, start, this.items, 0, this.size);
    }

    public void add(T value) {
        T[] TArray = this.items;
        if (this.size == TArray.length) {
            TArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        TArray[this.size++] = value;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int start, int count) {
        if (start + count > array.size) {
            throw new IllegalArgumentException("start + count must be <= size: " + start + " + " + count + " <= " + array.size);
        }
        this.addAll(array.items, start, count);
    }

    public void addAll(T ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(T[] array, int start, int count) {
        int n = this.size + count;
        T[] TArray = this.items;
        if (n > TArray.length) {
            TArray = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        System.arraycopy(array, start, TArray, this.size, count);
        this.size += count;
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, T value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void insert(int index, T value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        T[] TArray = this.items;
        if (this.size == TArray.length) {
            TArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(TArray, index, TArray, index + 1, this.size - index);
        } else {
            TArray[this.size] = TArray[index];
        }
        ++this.size;
        TArray[index] = value;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        T[] TArray = this.items;
        T t = this.items[first];
        TArray[first] = TArray[second];
        TArray[second] = t;
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(T value, boolean identity) {
        block2: {
            var3_3 = this.items;
            var4_4 = this.size - 1;
            if (!identity && value != null) ** GOTO lbl10
            while (var4_4 >= 0) {
                if (var3_3[var4_4--] != value) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(var3_3[var4_4--])) continue;
                return true;
lbl10:
                // 2 sources

                ** while (var4_4 >= 0)
            }
        }
        return false;
    }

    public int indexOf(T value, boolean identity) {
        T[] TArray = this.items;
        if (identity || value == null) {
            int n = 0;
            int n2 = this.size;
            while (n < n2) {
                if (TArray[n] == value) {
                    return n;
                }
                ++n;
            }
        } else {
            int n = 0;
            int n3 = this.size;
            while (n < n3) {
                if (value.equals(TArray[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int lastIndexOf(T value, boolean identity) {
        T[] TArray = this.items;
        if (identity || value == null) {
            int n = this.size - 1;
            while (n >= 0) {
                if (TArray[n] == value) {
                    return n;
                }
                --n;
            }
        } else {
            int n = this.size - 1;
            while (n >= 0) {
                if (value.equals(TArray[n])) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public boolean removeValue(T value, boolean identity) {
        T[] TArray = this.items;
        if (identity || value == null) {
            int n = 0;
            int n2 = this.size;
            while (n < n2) {
                if (TArray[n] == value) {
                    this.removeIndex(n);
                    return true;
                }
                ++n;
            }
        } else {
            int n = 0;
            int n3 = this.size;
            while (n < n3) {
                if (value.equals(TArray[n])) {
                    this.removeIndex(n);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public T removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        T[] TArray = this.items;
        T t = this.items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(TArray, index + 1, TArray, index, this.size - index);
        } else {
            TArray[index] = TArray[this.size];
        }
        TArray[this.size] = null;
        return t;
    }

    public void removeRange(int start, int end) {
        if (end >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        T[] TArray = this.items;
        int n = end - start + 1;
        if (this.ordered) {
            System.arraycopy(TArray, start + n, TArray, start, this.size - (start + n));
        } else {
            int n2 = this.size - 1;
            int n3 = 0;
            while (n3 < n) {
                TArray[start + n3] = TArray[n2 - n3];
                ++n3;
            }
        }
        this.size -= n;
    }

    public boolean removeAll(Array<? extends T> array, boolean identity) {
        int n;
        int n2 = n = this.size;
        T[] TArray = this.items;
        if (identity) {
            int n3 = 0;
            int n4 = array.size;
            while (n3 < n4) {
                T t = array.get(n3);
                int n5 = 0;
                while (n5 < n) {
                    if (t == TArray[n5]) {
                        this.removeIndex(n5);
                        --n;
                        break;
                    }
                    ++n5;
                }
                ++n3;
            }
        } else {
            int n6 = 0;
            int n7 = array.size;
            while (n6 < n7) {
                T t = array.get(n6);
                int n8 = 0;
                while (n8 < n) {
                    if (t.equals(TArray[n8])) {
                        this.removeIndex(n8);
                        --n;
                        break;
                    }
                    ++n8;
                }
                ++n6;
            }
        }
        return n != n2;
    }

    public T pop() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        --this.size;
        T t = this.items[this.size];
        this.items[this.size] = null;
        return t;
    }

    public T peek() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[this.size - 1];
    }

    public T first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        T[] TArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            TArray[n] = null;
            ++n;
        }
        this.size = 0;
    }

    public T[] shrink() {
        if (this.items.length != this.size) {
            Array array = this;
            array.resize(array.size);
        }
        return this.items;
    }

    public T[] ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        return this.items;
    }

    public T[] setSize(int newSize) {
        this.truncate(newSize);
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected T[] resize(int newSize) {
        T[] TArray = this.items;
        Object[] objectArray = (Object[])ArrayReflection.newInstance(this.items.getClass().getComponentType(), newSize);
        System.arraycopy(TArray, 0, objectArray, 0, Math.min(this.size, objectArray.length));
        this.items = objectArray;
        return objectArray;
    }

    public void sort() {
        Sort.instance().sort(this.items, 0, this.size);
    }

    public void sort(Comparator<? super T> comparator) {
        Sort.instance().sort(this.items, comparator, 0, this.size);
    }

    public T selectRanked(Comparator<T> comparator, int kthLowest) {
        if (kthLowest <= 0) {
            throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().select(this.items, comparator, kthLowest, this.size);
    }

    public int selectRankedIndex(Comparator<T> comparator, int kthLowest) {
        if (kthLowest <= 0) {
            throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().selectIndex(this.items, comparator, kthLowest, this.size);
    }

    public void reverse() {
        T[] TArray = this.items;
        int n = 0;
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        while (n < n3) {
            int n4 = n2 - n;
            T t = TArray[n];
            TArray[n] = TArray[n4];
            TArray[n4] = t;
            ++n;
        }
    }

    public void shuffle() {
        T[] TArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            int n2 = MathUtils.random(n);
            T t = TArray[n];
            TArray[n] = TArray[n2];
            TArray[n2] = t;
            --n;
        }
    }

    @Override
    public Iterator<T> iterator() {
        if (this.a == null) {
            this.a = new ArrayIterable(this);
        }
        return this.a.iterator();
    }

    public Iterable<T> select(Predicate<T> predicate) {
        if (this.b == null) {
            this.b = new Predicate.PredicateIterable<T>(this, predicate);
        } else {
            this.b.set(this, predicate);
        }
        return this.b;
    }

    public void truncate(int newSize) {
        if (this.size <= newSize) {
            return;
        }
        int n = newSize;
        while (n < this.size) {
            this.items[n] = null;
            ++n;
        }
        this.size = newSize;
    }

    public T random() {
        if (this.size == 0) {
            return null;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public T[] toArray() {
        Array array = this;
        return array.toArray(array.items.getClass().getComponentType());
    }

    public <V> V[] toArray(Class type) {
        Object[] objectArray = (Object[])ArrayReflection.newInstance(type, this.size);
        System.arraycopy(this.items, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        T[] TArray = this.items;
        int n = 1;
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            n *= 31;
            T t = TArray[n2];
            if (t != null) {
                n += t.hashCode();
            }
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Array)) {
            return false;
        }
        Array array = (Array)object;
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        T[] TArray = this.items;
        T[] TArray2 = array.items;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            T t2 = TArray2[n2];
            if (t == null ? t2 != null : !t.equals(t2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] TArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(TArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(", ");
            stringBuilder.append(TArray[n]);
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        T[] TArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(TArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(separator);
            stringBuilder.append(TArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static <T> Array<T> of(Class<T> arrayType) {
        return new Array<T>(arrayType);
    }

    public static <T> Array<T> of(boolean ordered, int capacity, Class<T> arrayType) {
        return new Array<T>(ordered, capacity, arrayType);
    }

    public static <T> Array<T> with(T ... array) {
        return new Array<T>(array);
    }

    public static class ArrayIterable<T>
    implements Iterable<T> {
        private final Array<T> a;
        private final boolean b;
        private ArrayIterator c;
        private ArrayIterator d;

        public ArrayIterable(Array<T> array) {
            this(array, true);
        }

        public ArrayIterable(Array<T> array, boolean allowRemove) {
            this.a = array;
            this.b = allowRemove;
        }

        @Override
        public Iterator<T> iterator() {
            if (this.c == null) {
                this.c = new ArrayIterator<T>(this.a, this.b);
                this.d = new ArrayIterator<T>(this.a, this.b);
            }
            if (!this.c.b) {
                this.c.a = 0;
                this.c.b = true;
                this.d.b = false;
                return this.c;
            }
            this.d.a = 0;
            this.d.b = true;
            this.c.b = false;
            return this.d;
        }
    }

    public static class ArrayIterator<T>
    implements Iterable<T>,
    Iterator<T> {
        private final Array<T> c;
        private final boolean d;
        int a;
        boolean b = true;

        public ArrayIterator(Array<T> array) {
            this(array, true);
        }

        public ArrayIterator(Array<T> array, boolean allowRemove) {
            this.c = array;
            this.d = allowRemove;
        }

        @Override
        public boolean hasNext() {
            if (!this.b) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.a < this.c.size;
        }

        @Override
        public T next() {
            if (this.a >= this.c.size) {
                throw new NoSuchElementException(String.valueOf(this.a));
            }
            if (!this.b) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.c.items[this.a++];
        }

        @Override
        public void remove() {
            if (!this.d) {
                throw new GdxRuntimeException("Remove not allowed.");
            }
            --this.a;
            this.c.removeIndex(this.a);
        }

        public void reset() {
            this.a = 0;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

