/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

public class Base64Coder {
    public static final CharMap regularMap = new CharMap('+', '/');
    public static final CharMap urlsafeMap = new CharMap('-', '_');

    public static String encodeString(String s) {
        return Base64Coder.encodeString(s, false);
    }

    public static String encodeString(String s, boolean useUrlsafeEncoding) {
        return new String(Base64Coder.encode(s.getBytes(), useUrlsafeEncoding ? Base64Coder.urlsafeMap.encodingMap : Base64Coder.regularMap.encodingMap));
    }

    public static String encodeLines(byte[] in) {
        return Base64Coder.encodeLines(in, 0, in.length, 76, "\n", Base64Coder.regularMap.encodingMap);
    }

    public static String encodeLines(byte[] in, int iOff, int iLen, int lineLen, String lineSeparator, CharMap charMap) {
        return Base64Coder.encodeLines(in, iOff, iLen, lineLen, lineSeparator, charMap.encodingMap);
    }

    public static String encodeLines(byte[] in, int iOff, int iLen, int lineLen, String lineSeparator, char[] charMap) {
        int n = lineLen * 3 / 4;
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        int n2 = (iLen + n - 1) / n;
        int n3 = (iLen + 2) / 3 * 4 + n2 * lineSeparator.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        int n4 = 0;
        while (n4 < iLen) {
            int n5 = Math.min(iLen - n4, n);
            stringBuilder.append(Base64Coder.encode(in, iOff + n4, n5, charMap));
            stringBuilder.append(lineSeparator);
            n4 += n5;
        }
        return stringBuilder.toString();
    }

    public static char[] encode(byte[] in) {
        return Base64Coder.encode(in, Base64Coder.regularMap.encodingMap);
    }

    public static char[] encode(byte[] in, CharMap charMap) {
        return Base64Coder.encode(in, 0, in.length, charMap);
    }

    public static char[] encode(byte[] in, char[] charMap) {
        return Base64Coder.encode(in, 0, in.length, charMap);
    }

    public static char[] encode(byte[] in, int iLen) {
        return Base64Coder.encode(in, 0, iLen, Base64Coder.regularMap.encodingMap);
    }

    public static char[] encode(byte[] in, int iOff, int iLen, CharMap charMap) {
        return Base64Coder.encode(in, iOff, iLen, charMap.encodingMap);
    }

    public static char[] encode(byte[] in, int iOff, int iLen, char[] charMap) {
        int n = (iLen * 4 + 2) / 3;
        char[] cArray = new char[(iLen + 2) / 3 * 4];
        int n2 = iOff;
        int n3 = iOff + iLen;
        int n4 = 0;
        while (n2 < n3) {
            int n5 = in[n2++] & 0xFF;
            int n6 = n2 < n3 ? in[n2++] & 0xFF : 0;
            int n7 = n2 < n3 ? in[n2++] & 0xFF : 0;
            int n8 = n5 >>> 2;
            int n9 = (n5 & 3) << 4 | n6 >>> 4;
            int n10 = (n6 & 0xF) << 2 | n7 >>> 6;
            int n11 = n7 & 0x3F;
            cArray[n4++] = charMap[n8];
            cArray[n4++] = charMap[n9];
            int n12 = n4;
            cArray[n12] = n12 < n ? charMap[n10] : 61;
            int n13 = ++n4;
            cArray[n13] = n13 < n ? charMap[n11] : 61;
            ++n4;
        }
        return cArray;
    }

    public static String decodeString(String s) {
        return Base64Coder.decodeString(s, false);
    }

    public static String decodeString(String s, boolean useUrlSafeEncoding) {
        return new String(Base64Coder.decode(s.toCharArray(), useUrlSafeEncoding ? Base64Coder.urlsafeMap.decodingMap : Base64Coder.regularMap.decodingMap));
    }

    public static byte[] decodeLines(String s) {
        return Base64Coder.decodeLines(s, Base64Coder.regularMap.decodingMap);
    }

    public static byte[] decodeLines(String s, CharMap inverseCharMap) {
        return Base64Coder.decodeLines(s, inverseCharMap.decodingMap);
    }

    public static byte[] decodeLines(String s, byte[] inverseCharMap) {
        char[] cArray = new char[s.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < s.length()) {
            char c2 = s.charAt(n2);
            if (c2 != ' ' && c2 != '\r' && c2 != '\n' && c2 != '\t') {
                cArray[n++] = c2;
            }
            ++n2;
        }
        return Base64Coder.decode(cArray, 0, n, inverseCharMap);
    }

    public static byte[] decode(String s) {
        return Base64Coder.decode(s.toCharArray());
    }

    public static byte[] decode(String s, CharMap inverseCharMap) {
        return Base64Coder.decode(s.toCharArray(), inverseCharMap);
    }

    public static byte[] decode(char[] in, byte[] inverseCharMap) {
        return Base64Coder.decode(in, 0, in.length, inverseCharMap);
    }

    public static byte[] decode(char[] in, CharMap inverseCharMap) {
        return Base64Coder.decode(in, 0, in.length, inverseCharMap);
    }

    public static byte[] decode(char[] in) {
        return Base64Coder.decode(in, 0, in.length, Base64Coder.regularMap.decodingMap);
    }

    public static byte[] decode(char[] in, int iOff, int iLen, CharMap inverseCharMap) {
        return Base64Coder.decode(in, iOff, iLen, inverseCharMap.decodingMap);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] decode(char[] in, int iOff, int iLen, byte[] inverseCharMap) {
        if (iLen % 4 == 0) ** GOTO lbl4
        throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
lbl-1000:
        // 1 sources

        {
            --iLen;
lbl4:
            // 2 sources

            ** while (iLen > 0 && in[iOff + iLen - 1] == '=')
        }
lbl5:
        // 1 sources

        var4_4 = iLen * 3 / 4;
        var5_5 = new byte[var4_4];
        var6_6 = iOff;
        var7_7 = iOff + iLen;
        var8_8 = 0;
        while (var6_6 < var7_7) {
            var9_9 = in[var6_6++];
            var10_10 = in[var6_6++];
            var11_11 = var6_6 < var7_7 ? in[var6_6++] : 65;
            v0 = var12_12 = var6_6 < var7_7 ? in[var6_6++] : 65;
            if (var9_9 > '\u007f' || var10_10 > '\u007f' || var11_11 > 127 || var12_12 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            var13_13 = inverseCharMap[var9_9];
            var14_14 = inverseCharMap[var10_10];
            var15_15 = inverseCharMap[var11_11];
            var16_16 = inverseCharMap[var12_12];
            if (var13_13 < 0 || var14_14 < 0 || var15_15 < 0 || var16_16 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            var17_17 = var13_13 << 2 | var14_14 >>> 4;
            var18_18 = (var14_14 & 15) << 4 | var15_15 >>> 2;
            var19_19 = (var15_15 & 3) << 6 | var16_16;
            var5_5[var8_8++] = (byte)var17_17;
            if (var8_8 < var4_4) {
                var5_5[var8_8++] = (byte)var18_18;
            }
            if (var8_8 >= var4_4) continue;
            var5_5[var8_8++] = (byte)var19_19;
        }
        return var5_5;
    }

    private Base64Coder() {
    }

    public static class CharMap {
        protected final char[] encodingMap = new char[64];
        protected final byte[] decodingMap = new byte[128];

        public CharMap(char char63, char char64) {
            int n = 0;
            int n2 = 65;
            while (n2 <= 90) {
                this.encodingMap[n++] = n2;
                n2 = (char)(n2 + 1);
            }
            n2 = 97;
            while (n2 <= 122) {
                this.encodingMap[n++] = n2;
                n2 = (char)(n2 + 1);
            }
            n2 = 48;
            while (n2 <= 57) {
                this.encodingMap[n++] = n2;
                n2 = (char)(n2 + 1);
            }
            this.encodingMap[n++] = char63;
            this.encodingMap[n] = char64;
            n = 0;
            while (n < this.decodingMap.length) {
                this.decodingMap[n] = -1;
                ++n;
            }
            n = 0;
            while (n < 64) {
                this.decodingMap[this.encodingMap[n]] = (byte)n;
                ++n;
            }
        }

        public byte[] getDecodingMap() {
            return this.decodingMap;
        }

        public char[] getEncodingMap() {
            return this.encodingMap;
        }
    }
}

