/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    private static Array<ByteBuffer> a = new Array();
    private static int b = 0;

    public static void copy(float[] src, Buffer dst, int numFloats, int offset) {
        if (dst instanceof ByteBuffer) {
            dst.limit(numFloats << 2);
        } else if (dst instanceof FloatBuffer) {
            dst.limit(numFloats);
        }
        BufferUtils.copyJni(src, dst, numFloats, offset);
        dst.position(0);
    }

    public static void copy(byte[] src, int srcOffset, Buffer dst, int numElements) {
        Buffer buffer = dst;
        buffer.limit(buffer.position() + BufferUtils.a(dst, numElements));
        Buffer buffer2 = dst;
        BufferUtils.copyJni(src, srcOffset, buffer2, BufferUtils.a(buffer2), numElements);
    }

    public static void copy(short[] src, int srcOffset, Buffer dst, int numElements) {
        Buffer buffer = dst;
        buffer.limit(buffer.position() + BufferUtils.a(dst, numElements << 1));
        Buffer buffer2 = dst;
        BufferUtils.copyJni(src, srcOffset, buffer2, BufferUtils.a(buffer2), numElements << 1);
    }

    public static void copy(char[] src, int srcOffset, int numElements, Buffer dst) {
        Buffer buffer = dst;
        BufferUtils.copyJni(src, srcOffset, buffer, BufferUtils.a(buffer), numElements << 1);
    }

    public static void copy(int[] src, int srcOffset, int numElements, Buffer dst) {
        Buffer buffer = dst;
        BufferUtils.copyJni(src, srcOffset, buffer, BufferUtils.a(buffer), numElements << 2);
    }

    public static void copy(long[] src, int srcOffset, int numElements, Buffer dst) {
        Buffer buffer = dst;
        BufferUtils.copyJni(src, srcOffset, buffer, BufferUtils.a(buffer), numElements << 3);
    }

    public static void copy(float[] src, int srcOffset, int numElements, Buffer dst) {
        Buffer buffer = dst;
        BufferUtils.copyJni(src, srcOffset, buffer, BufferUtils.a(buffer), numElements << 2);
    }

    public static void copy(double[] src, int srcOffset, int numElements, Buffer dst) {
        Buffer buffer = dst;
        BufferUtils.copyJni(src, srcOffset, buffer, BufferUtils.a(buffer), numElements << 3);
    }

    public static void copy(char[] src, int srcOffset, Buffer dst, int numElements) {
        Buffer buffer = dst;
        buffer.limit(buffer.position() + BufferUtils.a(dst, numElements << 1));
        Buffer buffer2 = dst;
        BufferUtils.copyJni(src, srcOffset, buffer2, BufferUtils.a(buffer2), numElements << 1);
    }

    public static void copy(int[] src, int srcOffset, Buffer dst, int numElements) {
        Buffer buffer = dst;
        buffer.limit(buffer.position() + BufferUtils.a(dst, numElements << 2));
        Buffer buffer2 = dst;
        BufferUtils.copyJni(src, srcOffset, buffer2, BufferUtils.a(buffer2), numElements << 2);
    }

    public static void copy(long[] src, int srcOffset, Buffer dst, int numElements) {
        Buffer buffer = dst;
        buffer.limit(buffer.position() + BufferUtils.a(dst, numElements << 3));
        Buffer buffer2 = dst;
        BufferUtils.copyJni(src, srcOffset, buffer2, BufferUtils.a(buffer2), numElements << 3);
    }

    public static void copy(float[] src, int srcOffset, Buffer dst, int numElements) {
        Buffer buffer = dst;
        buffer.limit(buffer.position() + BufferUtils.a(dst, numElements << 2));
        Buffer buffer2 = dst;
        BufferUtils.copyJni(src, srcOffset, buffer2, BufferUtils.a(buffer2), numElements << 2);
    }

    public static void copy(double[] src, int srcOffset, Buffer dst, int numElements) {
        Buffer buffer = dst;
        buffer.limit(buffer.position() + BufferUtils.a(dst, numElements << 3));
        Buffer buffer2 = dst;
        BufferUtils.copyJni(src, srcOffset, buffer2, BufferUtils.a(buffer2), numElements << 3);
    }

    public static void copy(Buffer src, Buffer dst, int numElements) {
        int n;
        Buffer buffer = src;
        if (buffer instanceof ByteBuffer) {
            n = numElements;
        } else if (buffer instanceof ShortBuffer) {
            n = numElements << 1;
        } else if (buffer instanceof CharBuffer) {
            n = numElements << 1;
        } else if (buffer instanceof IntBuffer) {
            n = numElements << 2;
        } else if (buffer instanceof LongBuffer) {
            n = numElements << 3;
        } else if (buffer instanceof FloatBuffer) {
            n = numElements << 2;
        } else if (buffer instanceof DoubleBuffer) {
            n = numElements << 3;
        } else {
            throw new GdxRuntimeException("Can't copy to a " + buffer.getClass().getName() + " instance");
        }
        int n2 = n;
        Buffer buffer2 = dst;
        buffer2.limit(buffer2.position() + BufferUtils.a(dst, n2));
        Buffer buffer3 = src;
        Buffer buffer4 = dst;
        BufferUtils.copyJni(buffer3, BufferUtils.a(buffer3), buffer4, BufferUtils.a(buffer4), n2);
    }

    public static void transform(Buffer data, int dimensions, int strideInBytes, int count, Matrix4 matrix) {
        BufferUtils.transform(data, dimensions, strideInBytes, count, matrix, 0);
    }

    public static void transform(float[] data, int dimensions, int strideInBytes, int count, Matrix4 matrix) {
        BufferUtils.transform(data, dimensions, strideInBytes, count, matrix, 0);
    }

    public static void transform(Buffer data, int dimensions, int strideInBytes, int count, Matrix4 matrix, int offset) {
        switch (dimensions) {
            case 4: {
                BufferUtils.transformV4M4Jni(data, strideInBytes, count, matrix.val, BufferUtils.a(data) + offset);
                return;
            }
            case 3: {
                BufferUtils.transformV3M4Jni(data, strideInBytes, count, matrix.val, BufferUtils.a(data) + offset);
                return;
            }
            case 2: {
                BufferUtils.transformV2M4Jni(data, strideInBytes, count, matrix.val, BufferUtils.a(data) + offset);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void transform(float[] data, int dimensions, int strideInBytes, int count, Matrix4 matrix, int offset) {
        switch (dimensions) {
            case 4: {
                BufferUtils.transformV4M4Jni(data, strideInBytes, count, matrix.val, offset);
                return;
            }
            case 3: {
                BufferUtils.transformV3M4Jni(data, strideInBytes, count, matrix.val, offset);
                return;
            }
            case 2: {
                BufferUtils.transformV2M4Jni(data, strideInBytes, count, matrix.val, offset);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void transform(Buffer data, int dimensions, int strideInBytes, int count, Matrix3 matrix) {
        BufferUtils.transform(data, dimensions, strideInBytes, count, matrix, 0);
    }

    public static void transform(float[] data, int dimensions, int strideInBytes, int count, Matrix3 matrix) {
        BufferUtils.transform(data, dimensions, strideInBytes, count, matrix, 0);
    }

    public static void transform(Buffer data, int dimensions, int strideInBytes, int count, Matrix3 matrix, int offset) {
        switch (dimensions) {
            case 3: {
                BufferUtils.transformV3M3Jni(data, strideInBytes, count, matrix.val, BufferUtils.a(data) + offset);
                return;
            }
            case 2: {
                BufferUtils.transformV2M3Jni(data, strideInBytes, count, matrix.val, BufferUtils.a(data) + offset);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void transform(float[] data, int dimensions, int strideInBytes, int count, Matrix3 matrix, int offset) {
        switch (dimensions) {
            case 3: {
                BufferUtils.transformV3M3Jni(data, strideInBytes, count, matrix.val, offset);
                return;
            }
            case 2: {
                BufferUtils.transformV2M3Jni(data, strideInBytes, count, matrix.val, offset);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public static long findFloats(Buffer vertex, int strideInBytes, Buffer vertices, int numVertices) {
        Buffer buffer = vertex;
        Buffer buffer2 = vertices;
        return BufferUtils.find(buffer, BufferUtils.a(buffer), strideInBytes, buffer2, BufferUtils.a(buffer2), numVertices);
    }

    public static long findFloats(float[] vertex, int strideInBytes, Buffer vertices, int numVertices) {
        Buffer buffer = vertices;
        return BufferUtils.find(vertex, 0, strideInBytes, buffer, BufferUtils.a(buffer), numVertices);
    }

    public static long findFloats(Buffer vertex, int strideInBytes, float[] vertices, int numVertices) {
        Buffer buffer = vertex;
        return BufferUtils.find(buffer, BufferUtils.a(buffer), strideInBytes, vertices, 0, numVertices);
    }

    public static long findFloats(float[] vertex, int strideInBytes, float[] vertices, int numVertices) {
        return BufferUtils.find(vertex, 0, strideInBytes, vertices, 0, numVertices);
    }

    public static long findFloats(Buffer vertex, int strideInBytes, Buffer vertices, int numVertices, float epsilon) {
        Buffer buffer = vertex;
        Buffer buffer2 = vertices;
        return BufferUtils.find(buffer, BufferUtils.a(buffer), strideInBytes, buffer2, BufferUtils.a(buffer2), numVertices, epsilon);
    }

    public static long findFloats(float[] vertex, int strideInBytes, Buffer vertices, int numVertices, float epsilon) {
        Buffer buffer = vertices;
        return BufferUtils.find(vertex, 0, strideInBytes, buffer, BufferUtils.a(buffer), numVertices, epsilon);
    }

    public static long findFloats(Buffer vertex, int strideInBytes, float[] vertices, int numVertices, float epsilon) {
        Buffer buffer = vertex;
        return BufferUtils.find(buffer, BufferUtils.a(buffer), strideInBytes, vertices, 0, numVertices, epsilon);
    }

    public static long findFloats(float[] vertex, int strideInBytes, float[] vertices, int numVertices, float epsilon) {
        return BufferUtils.find(vertex, 0, strideInBytes, vertices, 0, numVertices, epsilon);
    }

    private static int a(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return buffer.position();
        }
        if (buffer instanceof ShortBuffer) {
            return buffer.position() << 1;
        }
        if (buffer instanceof CharBuffer) {
            return buffer.position() << 1;
        }
        if (buffer instanceof IntBuffer) {
            return buffer.position() << 2;
        }
        if (buffer instanceof LongBuffer) {
            return buffer.position() << 3;
        }
        if (buffer instanceof FloatBuffer) {
            return buffer.position() << 2;
        }
        if (buffer instanceof DoubleBuffer) {
            return buffer.position() << 3;
        }
        throw new GdxRuntimeException("Can't copy to a " + buffer.getClass().getName() + " instance");
    }

    private static int a(Buffer buffer, int n) {
        if (buffer instanceof ByteBuffer) {
            return n;
        }
        if (buffer instanceof ShortBuffer) {
            return n >>> 1;
        }
        if (buffer instanceof CharBuffer) {
            return n >>> 1;
        }
        if (buffer instanceof IntBuffer) {
            return n >>> 2;
        }
        if (buffer instanceof LongBuffer) {
            return n >>> 3;
        }
        if (buffer instanceof FloatBuffer) {
            return n >>> 2;
        }
        if (buffer instanceof DoubleBuffer) {
            return n >>> 3;
        }
        throw new GdxRuntimeException("Can't copy to a " + buffer.getClass().getName() + " instance");
    }

    public static FloatBuffer newFloatBuffer(int numFloats) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numFloats * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asFloatBuffer();
    }

    public static DoubleBuffer newDoubleBuffer(int numDoubles) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numDoubles * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asDoubleBuffer();
    }

    public static ByteBuffer newByteBuffer(int numBytes) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numBytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static ShortBuffer newShortBuffer(int numShorts) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numShorts * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asShortBuffer();
    }

    public static CharBuffer newCharBuffer(int numChars) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numChars * 2);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asCharBuffer();
    }

    public static IntBuffer newIntBuffer(int numInts) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numInts * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asIntBuffer();
    }

    public static LongBuffer newLongBuffer(int numLongs) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numLongs * 8);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asLongBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeUnsafeByteBuffer(ByteBuffer buffer) {
        int n = buffer.capacity();
        Array<ByteBuffer> array = a;
        synchronized (array) {
            if (!a.removeValue(buffer, true)) {
                throw new IllegalArgumentException("buffer not allocated with newUnsafeByteBuffer or already disposed");
            }
        }
        b -= n;
        BufferUtils.freeMemory(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer newUnsafeByteBuffer(int numBytes) {
        ByteBuffer byteBuffer = BufferUtils.newDisposableByteBuffer(numBytes);
        byteBuffer.order(ByteOrder.nativeOrder());
        b += numBytes;
        Array<ByteBuffer> array = a;
        synchronized (array) {
            a.add(byteBuffer);
        }
        return byteBuffer;
    }

    public static long getUnsafeBufferAddress(Buffer buffer) {
        return BufferUtils.getBufferAddress(buffer) + (long)buffer.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer newUnsafeByteBuffer(ByteBuffer buffer) {
        b += buffer.capacity();
        Array<ByteBuffer> array = a;
        synchronized (array) {
            a.add(buffer);
        }
        return buffer;
    }

    public static int getAllocatedBytesUnsafe() {
        return b;
    }

    private static native void freeMemory(ByteBuffer var0);

    private static native ByteBuffer newDisposableByteBuffer(int var0);

    private static native long getBufferAddress(Buffer var0);

    public static native void clear(ByteBuffer var0, int var1);

    private static native void copyJni(float[] var0, Buffer var1, int var2, int var3);

    private static native void copyJni(byte[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(char[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(short[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(int[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(long[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(float[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(double[] var0, int var1, Buffer var2, int var3, int var4);

    private static native void copyJni(Buffer var0, int var1, Buffer var2, int var3, int var4);

    private static native void transformV4M4Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV4M4Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV3M4Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV3M4Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV2M4Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV2M4Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV3M3Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV3M3Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV2M3Jni(Buffer var0, int var1, int var2, float[] var3, int var4);

    private static native void transformV2M3Jni(float[] var0, int var1, int var2, float[] var3, int var4);

    private static native long find(Buffer var0, int var1, int var2, Buffer var3, int var4, int var5);

    private static native long find(float[] var0, int var1, int var2, Buffer var3, int var4, int var5);

    private static native long find(Buffer var0, int var1, int var2, float[] var3, int var4, int var5);

    private static native long find(float[] var0, int var1, int var2, float[] var3, int var4, int var5);

    private static native long find(Buffer var0, int var1, int var2, Buffer var3, int var4, int var5, float var6);

    private static native long find(float[] var0, int var1, int var2, Buffer var3, int var4, int var5, float var6);

    private static native long find(Buffer var0, int var1, int var2, float[] var3, int var4, int var5, float var6);

    private static native long find(float[] var0, int var1, int var2, float[] var3, int var4, int var5, float var6);
}

