/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import java.util.Arrays;

public class ByteArray {
    public byte[] items;
    public int size;
    public boolean ordered;

    public ByteArray() {
        this(true, 16);
    }

    public ByteArray(int capacity) {
        this(true, capacity);
    }

    public ByteArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new byte[capacity];
    }

    public ByteArray(ByteArray array) {
        this.ordered = array.ordered;
        this.size = array.size;
        this.items = new byte[this.size];
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public ByteArray(byte[] array) {
        this(true, array, 0, array.length);
    }

    public ByteArray(boolean ordered, byte[] array, int startIndex, int count) {
        this(ordered, count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    public void add(byte value) {
        byte[] byArray = this.items;
        if (this.size == byArray.length) {
            byArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        byArray[this.size++] = value;
    }

    public void addAll(ByteArray array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(ByteArray array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(byte ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(byte[] array, int offset, int length) {
        int n = this.size + length;
        byte[] byArray = this.items;
        if (n > byArray.length) {
            byArray = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        System.arraycopy(array, offset, byArray, this.size, length);
        this.size += length;
    }

    public byte get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, byte value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void incr(int index, byte value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = (byte)(this.items[n] + value);
    }

    public void mul(int index, byte value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = (byte)(this.items[n] * value);
    }

    public void insert(int index, byte value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        byte[] byArray = this.items;
        if (this.size == byArray.length) {
            byArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(byArray, index, byArray, index + 1, this.size - index);
        } else {
            byArray[this.size] = byArray[index];
        }
        ++this.size;
        byArray[index] = value;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        byte[] byArray = this.items;
        byte by = this.items[first];
        byArray[first] = byArray[second];
        byArray[second] = by;
    }

    public boolean contains(byte value) {
        int n = this.size - 1;
        byte[] byArray = this.items;
        while (n >= 0) {
            if (byArray[n--] != value) continue;
            return true;
        }
        return false;
    }

    public int indexOf(byte value) {
        byte[] byArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (byArray[n] == value) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(byte value) {
        byte[] byArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            if (byArray[n] == value) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public boolean removeValue(byte value) {
        byte[] byArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (byArray[n] == value) {
                this.removeIndex(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public int removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        byte[] byArray = this.items;
        byte by = this.items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(byArray, index + 1, byArray, index, this.size - index);
        } else {
            byArray[index] = byArray[this.size];
        }
        return by;
    }

    public void removeRange(int start, int end) {
        if (end >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        byte[] byArray = this.items;
        int n = end - start + 1;
        if (this.ordered) {
            System.arraycopy(byArray, start + n, byArray, start, this.size - (start + n));
        } else {
            int n2 = this.size - 1;
            int n3 = 0;
            while (n3 < n) {
                byArray[start + n3] = byArray[n2 - n3];
                ++n3;
            }
        }
        this.size -= n;
    }

    public boolean removeAll(ByteArray array) {
        int n;
        int n2 = n = this.size;
        byte[] byArray = this.items;
        int n3 = 0;
        int n4 = array.size;
        while (n3 < n4) {
            byte by = array.get(n3);
            int n5 = 0;
            while (n5 < n) {
                if (by == byArray[n5]) {
                    this.removeIndex(n5);
                    --n;
                    break;
                }
                ++n5;
            }
            ++n3;
        }
        return n != n2;
    }

    public byte pop() {
        return this.items[--this.size];
    }

    public byte peek() {
        return this.items[this.size - 1];
    }

    public byte first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public byte[] shrink() {
        if (this.items.length != this.size) {
            ByteArray byteArray = this;
            byteArray.resize(byteArray.size);
        }
        return this.items;
    }

    public byte[] ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        return this.items;
    }

    public byte[] setSize(int newSize) {
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected byte[] resize(int newSize) {
        byte[] byArray = new byte[newSize];
        System.arraycopy(this.items, 0, byArray, 0, Math.min(this.size, newSize));
        this.items = byArray;
        return byArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        byte[] byArray = this.items;
        int n = 0;
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        while (n < n3) {
            int n4 = n2 - n;
            byte by = byArray[n];
            byArray[n] = byArray[n4];
            byArray[n4] = by;
            ++n;
        }
    }

    public void shuffle() {
        byte[] byArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            int n2 = MathUtils.random(n);
            byte by = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by;
            --n;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public byte random() {
        if (this.size == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.items, 0, byArray, 0, this.size);
        return byArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        byte[] byArray = this.items;
        int n = 1;
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            n = n * 31 + byArray[n2];
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteArray)) {
            return false;
        }
        ByteArray byteArray = (ByteArray)object;
        int n = this.size;
        if (n != byteArray.size) {
            return false;
        }
        byte[] byArray = this.items;
        byte[] byArray2 = byteArray.items;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        byte[] byArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(byArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(", ");
            stringBuilder.append(byArray[n]);
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        byte[] byArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(byArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(separator);
            stringBuilder.append(byArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static ByteArray with(byte ... array) {
        return new ByteArray(array);
    }
}

