/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import java.util.Arrays;

public class FloatArray {
    public float[] items;
    public int size;
    public boolean ordered;

    public FloatArray() {
        this(true, 16);
    }

    public FloatArray(int capacity) {
        this(true, capacity);
    }

    public FloatArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new float[capacity];
    }

    public FloatArray(FloatArray array) {
        this.ordered = array.ordered;
        this.size = array.size;
        this.items = new float[this.size];
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public FloatArray(float[] array) {
        this(true, array, 0, array.length);
    }

    public FloatArray(boolean ordered, float[] array, int startIndex, int count) {
        this(ordered, count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    public void add(float value) {
        float[] fArray = this.items;
        if (this.size == fArray.length) {
            fArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        fArray[this.size++] = value;
    }

    public void addAll(FloatArray array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(FloatArray array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(float ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(float[] array, int offset, int length) {
        int n = this.size + length;
        float[] fArray = this.items;
        if (n > fArray.length) {
            fArray = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        System.arraycopy(array, offset, fArray, this.size, length);
        this.size += length;
    }

    public float get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void incr(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] + value;
    }

    public void mul(int index, float value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] * value;
    }

    public void insert(int index, float value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        float[] fArray = this.items;
        if (this.size == fArray.length) {
            fArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(fArray, index, fArray, index + 1, this.size - index);
        } else {
            fArray[this.size] = fArray[index];
        }
        ++this.size;
        fArray[index] = value;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        float[] fArray = this.items;
        float f = this.items[first];
        fArray[first] = fArray[second];
        fArray[second] = f;
    }

    public boolean contains(float value) {
        int n = this.size - 1;
        float[] fArray = this.items;
        while (n >= 0) {
            if (fArray[n--] != value) continue;
            return true;
        }
        return false;
    }

    public int indexOf(float value) {
        float[] fArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (fArray[n] == value) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(char value) {
        float[] fArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            if (fArray[n] == (float)value) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public boolean removeValue(float value) {
        float[] fArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (fArray[n] == value) {
                this.removeIndex(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public float removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        float[] fArray = this.items;
        float f = this.items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(fArray, index + 1, fArray, index, this.size - index);
        } else {
            fArray[index] = fArray[this.size];
        }
        return f;
    }

    public void removeRange(int start, int end) {
        if (end >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        float[] fArray = this.items;
        int n = end - start + 1;
        if (this.ordered) {
            System.arraycopy(fArray, start + n, fArray, start, this.size - (start + n));
        } else {
            int n2 = this.size - 1;
            int n3 = 0;
            while (n3 < n) {
                fArray[start + n3] = fArray[n2 - n3];
                ++n3;
            }
        }
        this.size -= n;
    }

    public boolean removeAll(FloatArray array) {
        int n;
        int n2 = n = this.size;
        float[] fArray = this.items;
        int n3 = 0;
        int n4 = array.size;
        while (n3 < n4) {
            float f = array.get(n3);
            int n5 = 0;
            while (n5 < n) {
                if (f == fArray[n5]) {
                    this.removeIndex(n5);
                    --n;
                    break;
                }
                ++n5;
            }
            ++n3;
        }
        return n != n2;
    }

    public float pop() {
        return this.items[--this.size];
    }

    public float peek() {
        return this.items[this.size - 1];
    }

    public float first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public float[] shrink() {
        if (this.items.length != this.size) {
            FloatArray floatArray = this;
            floatArray.resize(floatArray.size);
        }
        return this.items;
    }

    public float[] ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        return this.items;
    }

    public float[] setSize(int newSize) {
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected float[] resize(int newSize) {
        float[] fArray = new float[newSize];
        System.arraycopy(this.items, 0, fArray, 0, Math.min(this.size, newSize));
        this.items = fArray;
        return fArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        float[] fArray = this.items;
        int n = 0;
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        while (n < n3) {
            int n4 = n2 - n;
            float f = fArray[n];
            fArray[n] = fArray[n4];
            fArray[n4] = f;
            ++n;
        }
    }

    public void shuffle() {
        float[] fArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            int n2 = MathUtils.random(n);
            float f = fArray[n];
            fArray[n] = fArray[n2];
            fArray[n2] = f;
            --n;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public float random() {
        if (this.size == 0) {
            return 0.0f;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public float[] toArray() {
        float[] fArray = new float[this.size];
        System.arraycopy(this.items, 0, fArray, 0, this.size);
        return fArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        float[] fArray = this.items;
        int n = 1;
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            n = n * 31 + Float.floatToIntBits(fArray[n2]);
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatArray)) {
            return false;
        }
        FloatArray floatArray = (FloatArray)object;
        int n = this.size;
        if (n != floatArray.size) {
            return false;
        }
        float[] fArray = this.items;
        float[] fArray2 = floatArray.items;
        int n2 = 0;
        while (n2 < n) {
            if (fArray[n2] != fArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object, float epsilon) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatArray)) {
            return false;
        }
        FloatArray floatArray = (FloatArray)object;
        int n = this.size;
        if (n != floatArray.size) {
            return false;
        }
        float[] fArray = this.items;
        float[] fArray2 = floatArray.items;
        int n2 = 0;
        while (n2 < n) {
            if (Math.abs(fArray[n2] - fArray2[n2]) > epsilon) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        float[] fArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(fArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(", ");
            stringBuilder.append(fArray[n]);
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        float[] fArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(fArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(separator);
            stringBuilder.append(fArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static FloatArray with(float ... array) {
        return new FloatArray(array);
    }
}

