/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import java.util.Arrays;

public class IntArray {
    public int[] items;
    public int size;
    public boolean ordered;

    public IntArray() {
        this(true, 16);
    }

    public IntArray(int capacity) {
        this(true, capacity);
    }

    public IntArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new int[capacity];
    }

    public IntArray(IntArray array) {
        this.ordered = array.ordered;
        this.size = array.size;
        this.items = new int[this.size];
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public IntArray(int[] array) {
        this(true, array, 0, array.length);
    }

    public IntArray(boolean ordered, int[] array, int startIndex, int count) {
        this(ordered, count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    public void add(int value) {
        int[] nArray = this.items;
        if (this.size == nArray.length) {
            nArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        nArray[this.size++] = value;
    }

    public void addAll(IntArray array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(IntArray array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(int ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(int[] array, int offset, int length) {
        int n = this.size + length;
        int[] nArray = this.items;
        if (n > nArray.length) {
            nArray = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        System.arraycopy(array, offset, nArray, this.size, length);
        this.size += length;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, int value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void incr(int index, int value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] + value;
    }

    public void mul(int index, int value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] * value;
    }

    public void insert(int index, int value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int[] nArray = this.items;
        if (this.size == nArray.length) {
            nArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(nArray, index, nArray, index + 1, this.size - index);
        } else {
            nArray[this.size] = nArray[index];
        }
        ++this.size;
        nArray[index] = value;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        int[] nArray = this.items;
        int n = this.items[first];
        nArray[first] = nArray[second];
        nArray[second] = n;
    }

    public boolean contains(int value) {
        int n = this.size - 1;
        int[] nArray = this.items;
        while (n >= 0) {
            if (nArray[n--] != value) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int value) {
        int[] nArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (nArray[n] == value) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(int value) {
        int[] nArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            if (nArray[n] == value) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public boolean removeValue(int value) {
        int[] nArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (nArray[n] == value) {
                this.removeIndex(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public int removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int[] nArray = this.items;
        int n = this.items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(nArray, index + 1, nArray, index, this.size - index);
        } else {
            nArray[index] = nArray[this.size];
        }
        return n;
    }

    public void removeRange(int start, int end) {
        if (end >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int[] nArray = this.items;
        int n = end - start + 1;
        if (this.ordered) {
            System.arraycopy(nArray, start + n, nArray, start, this.size - (start + n));
        } else {
            int n2 = this.size - 1;
            int n3 = 0;
            while (n3 < n) {
                nArray[start + n3] = nArray[n2 - n3];
                ++n3;
            }
        }
        this.size -= n;
    }

    public boolean removeAll(IntArray array) {
        int n;
        int n2 = n = this.size;
        int[] nArray = this.items;
        int n3 = 0;
        int n4 = array.size;
        while (n3 < n4) {
            int n5 = array.get(n3);
            int n6 = 0;
            while (n6 < n) {
                if (n5 == nArray[n6]) {
                    this.removeIndex(n6);
                    --n;
                    break;
                }
                ++n6;
            }
            ++n3;
        }
        return n != n2;
    }

    public int pop() {
        return this.items[--this.size];
    }

    public int peek() {
        return this.items[this.size - 1];
    }

    public int first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public int[] shrink() {
        if (this.items.length != this.size) {
            IntArray intArray = this;
            intArray.resize(intArray.size);
        }
        return this.items;
    }

    public int[] ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        return this.items;
    }

    public int[] setSize(int newSize) {
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected int[] resize(int newSize) {
        int[] nArray = new int[newSize];
        System.arraycopy(this.items, 0, nArray, 0, Math.min(this.size, newSize));
        this.items = nArray;
        return nArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        int[] nArray = this.items;
        int n = 0;
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        while (n < n3) {
            int n4 = n2 - n;
            int n5 = nArray[n];
            nArray[n] = nArray[n4];
            nArray[n4] = n5;
            ++n;
        }
    }

    public void shuffle() {
        int[] nArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            int n2 = MathUtils.random(n);
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
            --n;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public int random() {
        if (this.size == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.items, 0, nArray, 0, this.size);
        return nArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        int[] nArray = this.items;
        int n = 1;
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            n = n * 31 + nArray[n2];
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntArray)) {
            return false;
        }
        IntArray intArray = (IntArray)object;
        int n = this.size;
        if (n != intArray.size) {
            return false;
        }
        int[] nArray = this.items;
        int[] nArray2 = intArray.items;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(nArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(", ");
            stringBuilder.append(nArray[n]);
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(nArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(separator);
            stringBuilder.append(nArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static IntArray with(int ... array) {
        return new IntArray(array);
    }
}

