/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IntMap<V>
implements Iterable<Entry<V>> {
    public int size;
    int[] a;
    V[] b;
    int c;
    int d;
    V e;
    boolean f;
    private float g;
    private int h;
    private int i;
    private int j;
    private int k;
    private int l;
    private Entries m;
    private Entries n;
    private Values o;
    private Values p;
    private Keys q;
    private Keys r;

    public IntMap() {
        this(51, 0.8f);
    }

    public IntMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public IntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: ".concat(String.valueOf(initialCapacity)));
        }
        if ((initialCapacity = MathUtils.nextPowerOfTwo((int)Math.ceil((float)initialCapacity / loadFactor))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: ".concat(String.valueOf(initialCapacity)));
        }
        this.c = initialCapacity;
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: ".concat(String.valueOf(loadFactor)));
        }
        this.g = loadFactor;
        this.j = (int)((float)this.c * loadFactor);
        this.i = this.c - 1;
        this.h = 31 - Integer.numberOfTrailingZeros(this.c);
        this.k = Math.max(3, (int)Math.ceil(Math.log(this.c)) * 2);
        this.l = Math.max(Math.min(this.c, 8), (int)Math.sqrt(this.c) / 8);
        this.a = new int[this.c + this.k];
        this.b = new Object[this.a.length];
    }

    public IntMap(IntMap<? extends V> map) {
        this((int)Math.floor((float)map.c * map.g), map.g);
        this.d = map.d;
        System.arraycopy(map.a, 0, this.a, 0, map.a.length);
        System.arraycopy(map.b, 0, this.b, 0, map.b.length);
        this.size = map.size;
        this.e = map.e;
        this.f = map.f;
    }

    public V put(int key, V value) {
        if (key == 0) {
            V v = this.e;
            this.e = value;
            if (!this.f) {
                this.f = true;
                ++this.size;
            }
            return v;
        }
        int[] nArray = this.a;
        int n = key & this.i;
        int n2 = nArray[n];
        if (n2 == key) {
            V v = this.b[n];
            this.b[n] = value;
            return v;
        }
        int n3 = this.c(key);
        int n4 = nArray[n3];
        if (n4 == key) {
            V v = this.b[n3];
            this.b[n3] = value;
            return v;
        }
        int n5 = this.d(key);
        int n6 = nArray[n5];
        if (n6 == key) {
            V v = this.b[n5];
            this.b[n5] = value;
            return v;
        }
        int n7 = this.c;
        int n8 = n7 + this.d;
        while (n7 < n8) {
            if (nArray[n7] == key) {
                V v = this.b[n7];
                this.b[n7] = value;
                return v;
            }
            ++n7;
        }
        if (n2 == 0) {
            nArray[n] = key;
            this.b[n] = value;
            if (this.size++ >= this.j) {
                IntMap intMap = this;
                intMap.b(intMap.c << 1);
            }
            return null;
        }
        if (n4 == 0) {
            nArray[n3] = key;
            this.b[n3] = value;
            if (this.size++ >= this.j) {
                IntMap intMap = this;
                intMap.b(intMap.c << 1);
            }
            return null;
        }
        if (n6 == 0) {
            nArray[n5] = key;
            this.b[n5] = value;
            if (this.size++ >= this.j) {
                IntMap intMap = this;
                intMap.b(intMap.c << 1);
            }
            return null;
        }
        this.a(key, value, n, n2, n3, n4, n5, n6);
        return null;
    }

    public void putAll(IntMap<V> map) {
        for (Entry<V> entry : map.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void a(int n, V v) {
        if (n == 0) {
            this.e = v;
            this.f = true;
            return;
        }
        int n2 = n & this.i;
        int n3 = this.a[n2];
        if (n3 == 0) {
            this.a[n2] = n;
            this.b[n2] = v;
            if (this.size++ >= this.j) {
                IntMap intMap = this;
                intMap.b(intMap.c << 1);
            }
            return;
        }
        int n4 = this.c(n);
        int n5 = this.a[n4];
        if (n5 == 0) {
            this.a[n4] = n;
            this.b[n4] = v;
            if (this.size++ >= this.j) {
                IntMap intMap = this;
                intMap.b(intMap.c << 1);
            }
            return;
        }
        int n6 = this.d(n);
        int n7 = this.a[n6];
        if (n7 == 0) {
            this.a[n6] = n;
            this.b[n6] = v;
            if (this.size++ >= this.j) {
                IntMap intMap = this;
                intMap.b(intMap.c << 1);
            }
            return;
        }
        this.a(n, v, n2, n3, n4, n5, n6, n7);
    }

    private void a(int n, V v, int n2, int n3, int n4, int n5, int n6, int n7) {
        V v2;
        int n8;
        int[] nArray = this.a;
        V[] VArray = this.b;
        int n9 = this.i;
        int n10 = 0;
        int n11 = this.l;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    n8 = n3;
                    v2 = VArray[n2];
                    nArray[n2] = n;
                    VArray[n2] = v;
                    break;
                }
                case 1: {
                    n8 = n5;
                    v2 = VArray[n4];
                    nArray[n4] = n;
                    VArray[n4] = v;
                    break;
                }
                default: {
                    n8 = n7;
                    v2 = VArray[n6];
                    nArray[n6] = n;
                    VArray[n6] = v;
                }
            }
            n2 = n8 & n9;
            n3 = nArray[n2];
            if (n3 == 0) {
                nArray[n2] = n8;
                VArray[n2] = v2;
                if (this.size++ >= this.j) {
                    IntMap intMap = this;
                    intMap.b(intMap.c << 1);
                }
                return;
            }
            n4 = this.c(n8);
            n5 = nArray[n4];
            if (n5 == 0) {
                nArray[n4] = n8;
                VArray[n4] = v2;
                if (this.size++ >= this.j) {
                    IntMap intMap = this;
                    intMap.b(intMap.c << 1);
                }
                return;
            }
            n6 = this.d(n8);
            n7 = nArray[n6];
            if (n7 == 0) {
                nArray[n6] = n8;
                VArray[n6] = v2;
                if (this.size++ >= this.j) {
                    IntMap intMap = this;
                    intMap.b(intMap.c << 1);
                }
                return;
            }
            if (++n10 == n11) break;
            n = n8;
            v = v2;
        }
        this.b(n8, v2);
    }

    private void b(int n, V v) {
        if (this.d == this.k) {
            IntMap intMap = this;
            intMap.b(intMap.c << 1);
            this.put(n, v);
            return;
        }
        int n2 = this.c + this.d;
        this.a[n2] = n;
        this.b[n2] = v;
        ++this.d;
        ++this.size;
    }

    public V get(int key) {
        if (key == 0) {
            if (!this.f) {
                return null;
            }
            return this.e;
        }
        int n = key & this.i;
        if (this.a[n] != key && this.a[n = this.c(key)] != key && this.a[n = this.d(key)] != key) {
            return this.c(key, null);
        }
        return this.b[n];
    }

    public V get(int key, V defaultValue) {
        if (key == 0) {
            if (!this.f) {
                return defaultValue;
            }
            return this.e;
        }
        int n = key & this.i;
        if (this.a[n] != key && this.a[n = this.c(key)] != key && this.a[n = this.d(key)] != key) {
            return this.c(key, defaultValue);
        }
        return this.b[n];
    }

    private V c(int n, V v) {
        int[] nArray = this.a;
        int n2 = this.c;
        int n3 = n2 + this.d;
        while (n2 < n3) {
            if (nArray[n2] == n) {
                return this.b[n2];
            }
            ++n2;
        }
        return v;
    }

    public V remove(int key) {
        if (key == 0) {
            if (!this.f) {
                return null;
            }
            V v = this.e;
            this.e = null;
            this.f = false;
            --this.size;
            return v;
        }
        int n = key & this.i;
        if (this.a[n] == key) {
            this.a[n] = 0;
            V v = this.b[n];
            this.b[n] = null;
            --this.size;
            return v;
        }
        n = this.c(key);
        if (this.a[n] == key) {
            this.a[n] = 0;
            V v = this.b[n];
            this.b[n] = null;
            --this.size;
            return v;
        }
        n = this.d(key);
        if (this.a[n] == key) {
            this.a[n] = 0;
            V v = this.b[n];
            this.b[n] = null;
            --this.size;
            return v;
        }
        IntMap intMap = this;
        int[] nArray = intMap.a;
        int n2 = intMap.c;
        int n3 = n2 + intMap.d;
        while (n2 < n3) {
            if (nArray[n2] == key) {
                V v = intMap.b[n2];
                intMap.a(n2);
                --intMap.size;
                return v;
            }
            ++n2;
        }
        return null;
    }

    final void a(int n) {
        --this.d;
        int n2 = this.c + this.d;
        if (n < n2) {
            this.a[n] = this.a[n2];
            this.b[n] = this.b[n2];
            this.b[n2] = null;
            return;
        }
        this.b[n] = null;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(maximumCapacity)));
        }
        if (this.size > maximumCapacity) {
            maximumCapacity = this.size;
        }
        if (this.c <= maximumCapacity) {
            return;
        }
        maximumCapacity = MathUtils.nextPowerOfTwo(maximumCapacity);
        this.b(maximumCapacity);
    }

    public void clear(int maximumCapacity) {
        if (this.c <= maximumCapacity) {
            this.clear();
            return;
        }
        this.e = null;
        this.f = false;
        this.size = 0;
        this.b(maximumCapacity);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        int[] nArray = this.a;
        V[] VArray = this.b;
        int n = this.c + this.d;
        while (n-- > 0) {
            nArray[n] = 0;
            VArray[n] = null;
        }
        this.size = 0;
        this.d = 0;
        this.e = null;
        this.f = false;
    }

    public boolean containsValue(Object value, boolean identity) {
        V[] VArray = this.b;
        if (value == null) {
            if (this.f && this.e == null) {
                return true;
            }
            int[] nArray = this.a;
            int n = this.c + this.d;
            while (n-- > 0) {
                if (nArray[n] == 0 || VArray[n] != null) continue;
                return true;
            }
        } else if (identity) {
            if (value == this.e) {
                return true;
            }
            int n = this.c + this.d;
            while (n-- > 0) {
                if (VArray[n] != value) continue;
                return true;
            }
        } else {
            if (this.f && value.equals(this.e)) {
                return true;
            }
            int n = this.c + this.d;
            while (n-- > 0) {
                if (!value.equals(VArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        if (key == 0) {
            return this.f;
        }
        int n = key & this.i;
        if (this.a[n] != key && this.a[n = this.c(key)] != key && this.a[n = this.d(key)] != key) {
            IntMap intMap = this;
            int[] nArray = intMap.a;
            int n2 = intMap.c;
            int n3 = n2 + intMap.d;
            while (n2 < n3) {
                if (nArray[n2] == key) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public int findKey(Object value, boolean identity, int notFound) {
        V[] VArray = this.b;
        if (value == null) {
            if (this.f && this.e == null) {
                return 0;
            }
            int[] nArray = this.a;
            int n = this.c + this.d;
            while (n-- > 0) {
                if (nArray[n] == 0 || VArray[n] != null) continue;
                return nArray[n];
            }
        } else if (identity) {
            if (value == this.e) {
                return 0;
            }
            int n = this.c + this.d;
            while (n-- > 0) {
                if (VArray[n] != value) continue;
                return this.a[n];
            }
        } else {
            if (this.f && value.equals(this.e)) {
                return 0;
            }
            int n = this.c + this.d;
            while (n-- > 0) {
                if (!value.equals(VArray[n])) continue;
                return this.a[n];
            }
        }
        return notFound;
    }

    public void ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n >= this.j) {
            this.b(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.g)));
        }
    }

    private void b(int n) {
        int n2 = this.c + this.d;
        this.c = n;
        this.j = (int)((float)n * this.g);
        this.i = n - 1;
        this.h = 31 - Integer.numberOfTrailingZeros(n);
        this.k = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.l = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        int[] nArray = this.a;
        V[] VArray = this.b;
        this.a = new int[n + this.k];
        this.b = new Object[n + this.k];
        int n3 = this.size;
        this.size = this.f ? 1 : 0;
        this.d = 0;
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = nArray[n4];
                if (n5 != 0) {
                    this.a(n5, VArray[n4]);
                }
                ++n4;
            }
        }
    }

    private int c(int n) {
        int n2 = n * -1262997959;
        return (n2 ^ n2 >>> this.h) & this.i;
    }

    private int d(int n) {
        int n2 = n * -825114047;
        return (n2 ^ n2 >>> this.h) & this.i;
    }

    public int hashCode() {
        int n = 0;
        if (this.f && this.e != null) {
            n = 0 + this.e.hashCode();
        }
        int[] nArray = this.a;
        V[] VArray = this.b;
        int n2 = 0;
        int n3 = this.c + this.d;
        while (n2 < n3) {
            int n4 = nArray[n2];
            if (n4 != 0) {
                n += n4 * 31;
                V v = VArray[n2];
                if (v != null) {
                    n += v.hashCode();
                }
            }
            ++n2;
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntMap)) {
            return false;
        }
        IntMap intMap = (IntMap)obj;
        if (intMap.size != this.size) {
            return false;
        }
        if (intMap.f != this.f) {
            return false;
        }
        if (this.f && (intMap.e == null ? this.e != null : !intMap.e.equals(this.e))) {
            return false;
        }
        int[] nArray = this.a;
        V[] VArray = this.b;
        int n = 0;
        int n2 = this.c + this.d;
        while (n < n2) {
            V v;
            int n3 = nArray[n];
            if (n3 != 0 && ((v = VArray[n]) == null ? !intMap.containsKey(n3) || intMap.get(n3) != null : !v.equals(intMap.get(n3)))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        block3: {
            if (this.size == 0) {
                return "[]";
            }
            var1_1 = new StringBuilder(32);
            var1_1.append('[');
            var2_2 = this.a;
            var3_3 = this.b;
            var4_4 = var2_2.length;
            if (!this.f) ** GOTO lbl24
            var1_1.append("0=");
            var1_1.append(this.e);
            break block3;
lbl-1000:
            // 1 sources

            {
                var5_5 = var2_2[var4_4];
                if (var5_5 == 0) continue;
                var1_1.append(var5_5);
                var1_1.append('=');
                var1_1.append(var3_3[var4_4]);
                break;
lbl24:
                // 2 sources

                ** while (var4_4-- > 0)
            }
        }
        while (var4_4-- > 0) {
            var5_5 = var2_2[var4_4];
            if (var5_5 == 0) continue;
            var1_1.append(", ");
            var1_1.append(var5_5);
            var1_1.append('=');
            var1_1.append(var3_3[var4_4]);
        }
        var1_1.append(']');
        return var1_1.toString();
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Entries<V> entries() {
        if (this.m == null) {
            this.m = new Entries(this);
            this.n = new Entries(this);
        }
        if (!this.m.d) {
            this.m.reset();
            this.m.d = true;
            this.n.d = false;
            return this.m;
        }
        this.n.reset();
        this.n.d = true;
        this.m.d = false;
        return this.n;
    }

    public Values<V> values() {
        if (this.o == null) {
            this.o = new Values(this);
            this.p = new Values(this);
        }
        if (!this.o.d) {
            this.o.reset();
            this.o.d = true;
            this.p.d = false;
            return this.o;
        }
        this.p.reset();
        this.p.d = true;
        this.o.d = false;
        return this.p;
    }

    public Keys keys() {
        if (this.q == null) {
            this.q = new Keys(this);
            this.r = new Keys(this);
        }
        if (!this.q.d) {
            this.q.reset();
            this.q.d = true;
            this.r.d = false;
            return this.q;
        }
        this.r.reset();
        this.r.d = true;
        this.q.d = false;
        return this.r;
    }

    public static class Entries<V>
    extends a<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private Entry<V> e = new Entry();

        public Entries(IntMap map) {
            super(map);
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int[] nArray = this.a.a;
            if (this.b == -1) {
                this.e.key = 0;
                this.e.value = this.a.e;
            } else {
                this.e.key = nArray[this.b];
                this.e.value = this.a.b[this.b];
            }
            this.c = this.b;
            this.a();
            return this.e;
        }

        @Override
        public boolean hasNext() {
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry<V> {
        public int key;
        public V value;

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value;
        }
    }

    public static class Keys
    extends a {
        public Keys(IntMap map) {
            super(map);
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.b == -1 ? 0 : this.a.a[this.b];
            this.c = this.b;
            this.a();
            return n;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.a.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }

    static class a<V> {
        public boolean hasNext;
        final IntMap<V> a;
        int b;
        int c;
        boolean d = true;

        public a(IntMap<V> intMap) {
            this.a = intMap;
            this.reset();
        }

        public void reset() {
            this.c = -2;
            this.b = -1;
            if (this.a.f) {
                this.hasNext = true;
                return;
            }
            this.a();
        }

        final void a() {
            this.hasNext = false;
            int[] nArray = this.a.a;
            int n = this.a.c + this.a.d;
            while (++this.b < n) {
                if (nArray[this.b] == 0) continue;
                this.hasNext = true;
                return;
            }
        }

        public void remove() {
            if (this.c == -1 && this.a.f) {
                this.a.e = null;
                this.a.f = false;
            } else {
                if (this.c < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.c >= this.a.c) {
                    this.a.a(this.c);
                    this.b = this.c - 1;
                    this.a();
                } else {
                    this.a.a[this.c] = 0;
                    this.a.b[this.c] = null;
                }
            }
            this.c = -2;
            --this.a.size;
        }
    }

    public static class Values<V>
    extends a<V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(IntMap<V> map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object v = this.b == -1 ? this.a.e : this.a.b[this.b];
            this.c = this.b;
            this.a();
            return v;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        public Array<V> toArray() {
            Array<V> array = new Array<V>(true, this.a.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }
}

