/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class JsonValue
implements Iterable<JsonValue> {
    private ValueType a;
    private String b;
    private double c;
    private long d;
    public String name;
    public JsonValue child;
    public JsonValue next;
    public JsonValue prev;
    public JsonValue parent;
    public int size;

    public JsonValue(ValueType type) {
        this.a = type;
    }

    public JsonValue(String value) {
        this.set(value);
    }

    public JsonValue(double value) {
        this.set(value, null);
    }

    public JsonValue(long value) {
        this.set(value, (String)null);
    }

    public JsonValue(double value, String stringValue) {
        this.set(value, stringValue);
    }

    public JsonValue(long value, String stringValue) {
        this.set(value, stringValue);
    }

    public JsonValue(boolean value) {
        this.set(value);
    }

    public JsonValue get(int index) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && index > 0) {
            --index;
            jsonValue = jsonValue.next;
        }
        return jsonValue;
    }

    public JsonValue get(String name) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && !jsonValue.name.equalsIgnoreCase(name)) {
            jsonValue = jsonValue.next;
        }
        return jsonValue;
    }

    public boolean has(String name) {
        return this.get(name) != null;
    }

    public JsonValue require(int index) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && index > 0) {
            --index;
            jsonValue = jsonValue.next;
        }
        if (jsonValue == null) {
            throw new IllegalArgumentException("Child not found with index: ".concat(String.valueOf(index)));
        }
        return jsonValue;
    }

    public JsonValue require(String name) {
        JsonValue jsonValue = this.child;
        while (jsonValue != null && !jsonValue.name.equalsIgnoreCase(name)) {
            jsonValue = jsonValue.next;
        }
        if (jsonValue == null) {
            throw new IllegalArgumentException("Child not found with name: ".concat(String.valueOf(name)));
        }
        return jsonValue;
    }

    public JsonValue remove(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue.prev == null) {
            this.child = jsonValue.next;
            if (this.child != null) {
                this.child.prev = null;
            }
        } else {
            jsonValue.prev.next = jsonValue.next;
            if (jsonValue.next != null) {
                jsonValue.next.prev = jsonValue.prev;
            }
        }
        --this.size;
        return jsonValue;
    }

    public JsonValue remove(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue.prev == null) {
            this.child = jsonValue.next;
            if (this.child != null) {
                this.child.prev = null;
            }
        } else {
            jsonValue.prev.next = jsonValue.next;
            if (jsonValue.next != null) {
                jsonValue.next.prev = jsonValue.prev;
            }
        }
        --this.size;
        return jsonValue;
    }

    @Deprecated
    public int size() {
        return this.size;
    }

    public String asString() {
        switch (this.a) {
            case stringValue: {
                return this.b;
            }
            case doubleValue: {
                if (this.b != null) {
                    return this.b;
                }
                return Double.toString(this.c);
            }
            case longValue: {
                if (this.b != null) {
                    return this.b;
                }
                return Long.toString(this.d);
            }
            case booleanValue: {
                if (this.d != 0L) {
                    return "true";
                }
                return "false";
            }
            case nullValue: {
                return null;
            }
        }
        throw new IllegalStateException("Value cannot be converted to string: " + (Object)((Object)this.a));
    }

    public float asFloat() {
        switch (this.a) {
            case stringValue: {
                return Float.parseFloat(this.b);
            }
            case doubleValue: {
                return (float)this.c;
            }
            case longValue: {
                return this.d;
            }
            case booleanValue: {
                return this.d != 0L ? 1 : 0;
            }
        }
        throw new IllegalStateException("Value cannot be converted to float: " + (Object)((Object)this.a));
    }

    public double asDouble() {
        switch (this.a) {
            case stringValue: {
                return Double.parseDouble(this.b);
            }
            case doubleValue: {
                return this.c;
            }
            case longValue: {
                return this.d;
            }
            case booleanValue: {
                return this.d != 0L ? 1 : 0;
            }
        }
        throw new IllegalStateException("Value cannot be converted to double: " + (Object)((Object)this.a));
    }

    public long asLong() {
        switch (this.a) {
            case stringValue: {
                return Long.parseLong(this.b);
            }
            case doubleValue: {
                return (long)this.c;
            }
            case longValue: {
                return this.d;
            }
            case booleanValue: {
                return this.d != 0L ? 1 : 0;
            }
        }
        throw new IllegalStateException("Value cannot be converted to long: " + (Object)((Object)this.a));
    }

    public int asInt() {
        switch (this.a) {
            case stringValue: {
                return Integer.parseInt(this.b);
            }
            case doubleValue: {
                return (int)this.c;
            }
            case longValue: {
                return (int)this.d;
            }
            case booleanValue: {
                if (this.d != 0L) {
                    return 1;
                }
                return 0;
            }
        }
        throw new IllegalStateException("Value cannot be converted to int: " + (Object)((Object)this.a));
    }

    public boolean asBoolean() {
        switch (this.a) {
            case stringValue: {
                return this.b.equalsIgnoreCase("true");
            }
            case doubleValue: {
                return this.c != 0.0;
            }
            case longValue: {
                return this.d != 0L;
            }
            case booleanValue: {
                return this.d != 0L;
            }
        }
        throw new IllegalStateException("Value cannot be converted to boolean: " + (Object)((Object)this.a));
    }

    public byte asByte() {
        switch (this.a) {
            case stringValue: {
                return Byte.parseByte(this.b);
            }
            case doubleValue: {
                return (byte)this.c;
            }
            case longValue: {
                return (byte)this.d;
            }
            case booleanValue: {
                if (this.d != 0L) {
                    return 1;
                }
                return 0;
            }
        }
        throw new IllegalStateException("Value cannot be converted to byte: " + (Object)((Object)this.a));
    }

    public short asShort() {
        switch (this.a) {
            case stringValue: {
                return Short.parseShort(this.b);
            }
            case doubleValue: {
                return (short)this.c;
            }
            case longValue: {
                return (short)this.d;
            }
            case booleanValue: {
                if (this.d != 0L) {
                    return 1;
                }
                return 0;
            }
        }
        throw new IllegalStateException("Value cannot be converted to short: " + (Object)((Object)this.a));
    }

    public char asChar() {
        switch (this.a) {
            case stringValue: {
                if (this.b.length() == 0) {
                    return '\u0000';
                }
                return this.b.charAt(0);
            }
            case doubleValue: {
                return (char)this.c;
            }
            case longValue: {
                return (char)this.d;
            }
            case booleanValue: {
                if (this.d != 0L) {
                    return '\u0001';
                }
                return '\u0000';
            }
        }
        throw new IllegalStateException("Value cannot be converted to char: " + (Object)((Object)this.a));
    }

    public String[] asStringArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        String[] stringArray = new String[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            String string;
            switch (jsonValue.a) {
                case stringValue: {
                    string = jsonValue.b;
                    break;
                }
                case doubleValue: {
                    string = this.b != null ? this.b : Double.toString(jsonValue.c);
                    break;
                }
                case longValue: {
                    string = this.b != null ? this.b : Long.toString(jsonValue.d);
                    break;
                }
                case booleanValue: {
                    string = jsonValue.d != 0L ? "true" : "false";
                    break;
                }
                case nullValue: {
                    string = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to string: " + (Object)((Object)jsonValue.a));
                }
            }
            stringArray[n] = string;
            jsonValue = jsonValue.next;
            ++n;
        }
        return stringArray;
    }

    public float[] asFloatArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        float[] fArray = new float[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            float f;
            switch (jsonValue.a) {
                case stringValue: {
                    f = Float.parseFloat(jsonValue.b);
                    break;
                }
                case doubleValue: {
                    f = (float)jsonValue.c;
                    break;
                }
                case longValue: {
                    f = jsonValue.d;
                    break;
                }
                case booleanValue: {
                    f = jsonValue.d != 0L ? 1 : 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to float: " + (Object)((Object)jsonValue.a));
                }
            }
            fArray[n] = f;
            jsonValue = jsonValue.next;
            ++n;
        }
        return fArray;
    }

    public double[] asDoubleArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        double[] dArray = new double[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            double d;
            switch (jsonValue.a) {
                case stringValue: {
                    d = Double.parseDouble(jsonValue.b);
                    break;
                }
                case doubleValue: {
                    d = jsonValue.c;
                    break;
                }
                case longValue: {
                    d = jsonValue.d;
                    break;
                }
                case booleanValue: {
                    d = jsonValue.d != 0L ? 1 : 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to double: " + (Object)((Object)jsonValue.a));
                }
            }
            dArray[n] = d;
            jsonValue = jsonValue.next;
            ++n;
        }
        return dArray;
    }

    public long[] asLongArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        long[] lArray = new long[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            long l;
            switch (jsonValue.a) {
                case stringValue: {
                    l = Long.parseLong(jsonValue.b);
                    break;
                }
                case doubleValue: {
                    l = (long)jsonValue.c;
                    break;
                }
                case longValue: {
                    l = jsonValue.d;
                    break;
                }
                case booleanValue: {
                    l = jsonValue.d != 0L ? 1 : 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to long: " + (Object)((Object)jsonValue.a));
                }
            }
            lArray[n] = l;
            jsonValue = jsonValue.next;
            ++n;
        }
        return lArray;
    }

    public int[] asIntArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        int[] nArray = new int[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            int n2;
            switch (jsonValue.a) {
                case stringValue: {
                    n2 = Integer.parseInt(jsonValue.b);
                    break;
                }
                case doubleValue: {
                    n2 = (int)jsonValue.c;
                    break;
                }
                case longValue: {
                    n2 = (int)jsonValue.d;
                    break;
                }
                case booleanValue: {
                    n2 = jsonValue.d != 0L ? 1 : 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to int: " + (Object)((Object)jsonValue.a));
                }
            }
            nArray[n] = n2;
            jsonValue = jsonValue.next;
            ++n;
        }
        return nArray;
    }

    public boolean[] asBooleanArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        boolean[] blArray = new boolean[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            boolean bl;
            switch (jsonValue.a) {
                case stringValue: {
                    bl = Boolean.parseBoolean(jsonValue.b);
                    break;
                }
                case doubleValue: {
                    bl = jsonValue.c == 0.0;
                    break;
                }
                case longValue: {
                    bl = jsonValue.d == 0L;
                    break;
                }
                case booleanValue: {
                    bl = jsonValue.d != 0L;
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to boolean: " + (Object)((Object)jsonValue.a));
                }
            }
            blArray[n] = bl;
            jsonValue = jsonValue.next;
            ++n;
        }
        return blArray;
    }

    public byte[] asByteArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        byte[] byArray = new byte[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            byte by;
            switch (jsonValue.a) {
                case stringValue: {
                    by = Byte.parseByte(jsonValue.b);
                    break;
                }
                case doubleValue: {
                    by = (byte)jsonValue.c;
                    break;
                }
                case longValue: {
                    by = (byte)jsonValue.d;
                    break;
                }
                case booleanValue: {
                    by = jsonValue.d != 0L ? (byte)1 : 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to byte: " + (Object)((Object)jsonValue.a));
                }
            }
            byArray[n] = by;
            jsonValue = jsonValue.next;
            ++n;
        }
        return byArray;
    }

    public short[] asShortArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        short[] sArray = new short[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            short s;
            switch (jsonValue.a) {
                case stringValue: {
                    s = Short.parseShort(jsonValue.b);
                    break;
                }
                case doubleValue: {
                    s = (short)jsonValue.c;
                    break;
                }
                case longValue: {
                    s = (short)jsonValue.d;
                    break;
                }
                case booleanValue: {
                    s = jsonValue.d != 0L ? (short)1 : 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to short: " + (Object)((Object)jsonValue.a));
                }
            }
            sArray[n] = s;
            jsonValue = jsonValue.next;
            ++n;
        }
        return sArray;
    }

    public char[] asCharArray() {
        if (this.a != ValueType.array) {
            throw new IllegalStateException("Value is not an array: " + (Object)((Object)this.a));
        }
        char[] cArray = new char[this.size];
        int n = 0;
        JsonValue jsonValue = this.child;
        while (jsonValue != null) {
            char c2;
            switch (jsonValue.a) {
                case stringValue: {
                    c2 = jsonValue.b.length() == 0 ? (char)'\u0000' : jsonValue.b.charAt(0);
                    break;
                }
                case doubleValue: {
                    c2 = (char)jsonValue.c;
                    break;
                }
                case longValue: {
                    c2 = (char)jsonValue.d;
                    break;
                }
                case booleanValue: {
                    c2 = jsonValue.d != 0L ? (char)'\u0001' : '\u0000';
                    break;
                }
                default: {
                    throw new IllegalStateException("Value cannot be converted to char: " + (Object)((Object)jsonValue.a));
                }
            }
            cArray[n] = c2;
            jsonValue = jsonValue.next;
            ++n;
        }
        return cArray;
    }

    public boolean hasChild(String name) {
        return this.getChild(name) != null;
    }

    public JsonValue getChild(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            return null;
        }
        return jsonValue.child;
    }

    public String getString(String name, String defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue() || jsonValue.isNull()) {
            return defaultValue;
        }
        return jsonValue.asString();
    }

    public float getFloat(String name, float defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue()) {
            return defaultValue;
        }
        return jsonValue.asFloat();
    }

    public double getDouble(String name, double defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue()) {
            return defaultValue;
        }
        return jsonValue.asDouble();
    }

    public long getLong(String name, long defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue()) {
            return defaultValue;
        }
        return jsonValue.asLong();
    }

    public int getInt(String name, int defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue()) {
            return defaultValue;
        }
        return jsonValue.asInt();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue()) {
            return defaultValue;
        }
        return jsonValue.asBoolean();
    }

    public byte getByte(String name, byte defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue()) {
            return defaultValue;
        }
        return jsonValue.asByte();
    }

    public short getShort(String name, short defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue()) {
            return defaultValue;
        }
        return jsonValue.asShort();
    }

    public char getChar(String name, char defaultValue) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null || !jsonValue.isValue()) {
            return defaultValue;
        }
        return jsonValue.asChar();
    }

    public String getString(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asString();
    }

    public float getFloat(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asFloat();
    }

    public double getDouble(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asDouble();
    }

    public long getLong(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asLong();
    }

    public int getInt(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asInt();
    }

    public boolean getBoolean(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asBoolean();
    }

    public byte getByte(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asByte();
    }

    public short getShort(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asShort();
    }

    public char getChar(String name) {
        JsonValue jsonValue = this.get(name);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Named value not found: ".concat(String.valueOf(name)));
        }
        return jsonValue.asChar();
    }

    public String getString(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asString();
    }

    public float getFloat(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asFloat();
    }

    public double getDouble(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asDouble();
    }

    public long getLong(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asLong();
    }

    public int getInt(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asInt();
    }

    public boolean getBoolean(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asBoolean();
    }

    public byte getByte(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asByte();
    }

    public short getShort(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asShort();
    }

    public char getChar(int index) {
        JsonValue jsonValue = this.get(index);
        if (jsonValue == null) {
            throw new IllegalArgumentException("Indexed value not found: " + this.name);
        }
        return jsonValue.asChar();
    }

    public ValueType type() {
        return this.a;
    }

    public void setType(ValueType type) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        this.a = type;
    }

    public boolean isArray() {
        return this.a == ValueType.array;
    }

    public boolean isObject() {
        return this.a == ValueType.object;
    }

    public boolean isString() {
        return this.a == ValueType.stringValue;
    }

    public boolean isNumber() {
        return this.a == ValueType.doubleValue || this.a == ValueType.longValue;
    }

    public boolean isDouble() {
        return this.a == ValueType.doubleValue;
    }

    public boolean isLong() {
        return this.a == ValueType.longValue;
    }

    public boolean isBoolean() {
        return this.a == ValueType.booleanValue;
    }

    public boolean isNull() {
        return this.a == ValueType.nullValue;
    }

    public boolean isValue() {
        switch (this.a) {
            case stringValue: 
            case doubleValue: 
            case longValue: 
            case booleanValue: 
            case nullValue: {
                return true;
            }
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JsonValue parent() {
        return this.parent;
    }

    public JsonValue child() {
        return this.child;
    }

    public JsonValue next() {
        return this.next;
    }

    public void setNext(JsonValue next) {
        this.next = next;
    }

    public JsonValue prev() {
        return this.prev;
    }

    public void setPrev(JsonValue prev) {
        this.prev = prev;
    }

    public void set(String value) {
        this.b = value;
        this.a = value == null ? ValueType.nullValue : ValueType.stringValue;
    }

    public void set(double value, String stringValue) {
        this.c = value;
        this.d = (long)value;
        this.b = stringValue;
        this.a = ValueType.doubleValue;
    }

    public void set(long value, String stringValue) {
        this.d = value;
        this.c = value;
        this.b = stringValue;
        this.a = ValueType.longValue;
    }

    public void set(boolean value) {
        this.d = value ? 1 : 0;
        this.a = ValueType.booleanValue;
    }

    public JsonIterator iterator() {
        return new JsonIterator(this);
    }

    public class JsonIterator
    implements Iterable<JsonValue>,
    Iterator<JsonValue> {
        private JsonValue a;
        private JsonValue b;
        private /* synthetic */ JsonValue c;

        public JsonIterator(JsonValue jsonValue) {
            this.c = jsonValue;
            this.a = jsonValue.child;
        }

        @Override
        public boolean hasNext() {
            return this.a != null;
        }

        @Override
        public JsonValue next() {
            this.b = this.a;
            if (this.b == null) {
                throw new NoSuchElementException();
            }
            this.a = this.b.next;
            return this.b;
        }

        @Override
        public void remove() {
            if (this.b.prev == null) {
                this.c.child = this.b.next;
                if (this.c.child != null) {
                    this.c.child.prev = null;
                }
            } else {
                this.b.prev.next = this.b.next;
                if (this.b.next != null) {
                    this.b.next.prev = this.b.prev;
                }
            }
            --this.c.size;
        }

        @Override
        public Iterator<JsonValue> iterator() {
            return this;
        }
    }

    public static enum ValueType {
        object,
        array,
        stringValue,
        doubleValue,
        longValue,
        booleanValue,
        nullValue;

    }
}

