/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import java.util.Arrays;

public class LongArray {
    public long[] items;
    public int size;
    public boolean ordered;

    public LongArray() {
        this(true, 16);
    }

    public LongArray(int capacity) {
        this(true, capacity);
    }

    public LongArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new long[capacity];
    }

    public LongArray(LongArray array) {
        this.ordered = array.ordered;
        this.size = array.size;
        this.items = new long[this.size];
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public LongArray(long[] array) {
        this(true, array, 0, array.length);
    }

    public LongArray(boolean ordered, long[] array, int startIndex, int count) {
        this(ordered, count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    public void add(long value) {
        long[] lArray = this.items;
        if (this.size == lArray.length) {
            lArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        lArray[this.size++] = value;
    }

    public void addAll(LongArray array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(LongArray array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(long ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(long[] array, int offset, int length) {
        int n = this.size + length;
        long[] lArray = this.items;
        if (n > lArray.length) {
            lArray = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        System.arraycopy(array, offset, lArray, this.size, length);
        this.size += length;
    }

    public long get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, long value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void incr(int index, long value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] + value;
    }

    public void mul(int index, long value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] * value;
    }

    public void insert(int index, long value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        long[] lArray = this.items;
        if (this.size == lArray.length) {
            lArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(lArray, index, lArray, index + 1, this.size - index);
        } else {
            lArray[this.size] = lArray[index];
        }
        ++this.size;
        lArray[index] = value;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        long[] lArray = this.items;
        long l = this.items[first];
        lArray[first] = lArray[second];
        lArray[second] = l;
    }

    public boolean contains(long value) {
        int n = this.size - 1;
        long[] lArray = this.items;
        while (n >= 0) {
            if (lArray[n--] != value) continue;
            return true;
        }
        return false;
    }

    public int indexOf(long value) {
        long[] lArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (lArray[n] == value) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(char value) {
        long[] lArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            if (lArray[n] == (long)value) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public boolean removeValue(long value) {
        long[] lArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (lArray[n] == value) {
                this.removeIndex(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public long removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        long[] lArray = this.items;
        long l = this.items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(lArray, index + 1, lArray, index, this.size - index);
        } else {
            lArray[index] = lArray[this.size];
        }
        return l;
    }

    public void removeRange(int start, int end) {
        if (end >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        long[] lArray = this.items;
        int n = end - start + 1;
        if (this.ordered) {
            System.arraycopy(lArray, start + n, lArray, start, this.size - (start + n));
        } else {
            int n2 = this.size - 1;
            int n3 = 0;
            while (n3 < n) {
                lArray[start + n3] = lArray[n2 - n3];
                ++n3;
            }
        }
        this.size -= n;
    }

    public boolean removeAll(LongArray array) {
        int n;
        int n2 = n = this.size;
        long[] lArray = this.items;
        int n3 = 0;
        int n4 = array.size;
        while (n3 < n4) {
            long l = array.get(n3);
            int n5 = 0;
            while (n5 < n) {
                if (l == lArray[n5]) {
                    this.removeIndex(n5);
                    --n;
                    break;
                }
                ++n5;
            }
            ++n3;
        }
        return n != n2;
    }

    public long pop() {
        return this.items[--this.size];
    }

    public long peek() {
        return this.items[this.size - 1];
    }

    public long first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public long[] shrink() {
        if (this.items.length != this.size) {
            LongArray longArray = this;
            longArray.resize(longArray.size);
        }
        return this.items;
    }

    public long[] ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        return this.items;
    }

    public long[] setSize(int newSize) {
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected long[] resize(int newSize) {
        long[] lArray = new long[newSize];
        System.arraycopy(this.items, 0, lArray, 0, Math.min(this.size, newSize));
        this.items = lArray;
        return lArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        long[] lArray = this.items;
        int n = 0;
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        while (n < n3) {
            int n4 = n2 - n;
            long l = lArray[n];
            lArray[n] = lArray[n4];
            lArray[n4] = l;
            ++n;
        }
    }

    public void shuffle() {
        long[] lArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            int n2 = MathUtils.random(n);
            long l = lArray[n];
            lArray[n] = lArray[n2];
            lArray[n2] = l;
            --n;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public long random() {
        if (this.size == 0) {
            return 0L;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public long[] toArray() {
        long[] lArray = new long[this.size];
        System.arraycopy(this.items, 0, lArray, 0, this.size);
        return lArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        long[] lArray = this.items;
        int n = 1;
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            n = n * 31 + (int)(lArray[n2] ^ lArray[n2] >>> 32);
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongArray)) {
            return false;
        }
        LongArray longArray = (LongArray)object;
        int n = this.size;
        if (n != longArray.size) {
            return false;
        }
        long[] lArray = this.items;
        long[] lArray2 = longArray.items;
        int n2 = 0;
        while (n2 < n) {
            if (lArray[n2] != lArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        long[] lArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(lArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[n]);
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        long[] lArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(lArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(separator);
            stringBuilder.append(lArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static LongArray with(long ... array) {
        return new LongArray(array);
    }
}

