/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.LongArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongMap<V>
implements Iterable<Entry<V>> {
    public int size;
    long[] a;
    V[] b;
    int c;
    int d;
    V e;
    boolean f;
    private float g;
    private int h;
    private int i;
    private int j;
    private int k;
    private int l;
    private Entries m;
    private Entries n;
    private Values o;
    private Values p;
    private Keys q;
    private Keys r;

    public LongMap() {
        this(51, 0.8f);
    }

    public LongMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public LongMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: ".concat(String.valueOf(initialCapacity)));
        }
        if ((initialCapacity = MathUtils.nextPowerOfTwo((int)Math.ceil((float)initialCapacity / loadFactor))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: ".concat(String.valueOf(initialCapacity)));
        }
        this.c = initialCapacity;
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: ".concat(String.valueOf(loadFactor)));
        }
        this.g = loadFactor;
        this.j = (int)((float)this.c * loadFactor);
        this.i = this.c - 1;
        this.h = 63 - Long.numberOfTrailingZeros(this.c);
        this.k = Math.max(3, (int)Math.ceil(Math.log(this.c)) * 2);
        this.l = Math.max(Math.min(this.c, 8), (int)Math.sqrt(this.c) / 8);
        this.a = new long[this.c + this.k];
        this.b = new Object[this.a.length];
    }

    public LongMap(LongMap<? extends V> map) {
        this((int)Math.floor((float)map.c * map.g), map.g);
        this.d = map.d;
        System.arraycopy(map.a, 0, this.a, 0, map.a.length);
        System.arraycopy(map.b, 0, this.b, 0, map.b.length);
        this.size = map.size;
        this.e = map.e;
        this.f = map.f;
    }

    public V put(long key, V value) {
        if (key == 0L) {
            V v = this.e;
            this.e = value;
            if (!this.f) {
                this.f = true;
                ++this.size;
            }
            return v;
        }
        long[] lArray = this.a;
        int n = (int)(key & (long)this.i);
        long l = lArray[n];
        if (l == key) {
            V v = this.b[n];
            this.b[n] = value;
            return v;
        }
        int n2 = this.a(key);
        long l2 = lArray[n2];
        if (l2 == key) {
            V v = this.b[n2];
            this.b[n2] = value;
            return v;
        }
        int n3 = this.b(key);
        long l3 = lArray[n3];
        if (l3 == key) {
            V v = this.b[n3];
            this.b[n3] = value;
            return v;
        }
        int n4 = this.c;
        int n5 = n4 + this.d;
        while (n4 < n5) {
            if (lArray[n4] == key) {
                V v = this.b[n4];
                this.b[n4] = value;
                return v;
            }
            ++n4;
        }
        if (l == 0L) {
            lArray[n] = key;
            this.b[n] = value;
            if (this.size++ >= this.j) {
                LongMap longMap = this;
                longMap.b(longMap.c << 1);
            }
            return null;
        }
        if (l2 == 0L) {
            lArray[n2] = key;
            this.b[n2] = value;
            if (this.size++ >= this.j) {
                LongMap longMap = this;
                longMap.b(longMap.c << 1);
            }
            return null;
        }
        if (l3 == 0L) {
            lArray[n3] = key;
            this.b[n3] = value;
            if (this.size++ >= this.j) {
                LongMap longMap = this;
                longMap.b(longMap.c << 1);
            }
            return null;
        }
        this.a(key, value, n, l, n2, l2, n3, l3);
        return null;
    }

    public void putAll(LongMap<V> map) {
        for (Entry<V> entry : map.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void a(long l, V v) {
        if (l == 0L) {
            this.e = v;
            this.f = true;
            return;
        }
        int n = (int)(l & (long)this.i);
        long l2 = this.a[n];
        if (l2 == 0L) {
            this.a[n] = l;
            this.b[n] = v;
            if (this.size++ >= this.j) {
                LongMap longMap = this;
                longMap.b(longMap.c << 1);
            }
            return;
        }
        int n2 = this.a(l);
        long l3 = this.a[n2];
        if (l3 == 0L) {
            this.a[n2] = l;
            this.b[n2] = v;
            if (this.size++ >= this.j) {
                LongMap longMap = this;
                longMap.b(longMap.c << 1);
            }
            return;
        }
        int n3 = this.b(l);
        long l4 = this.a[n3];
        if (l4 == 0L) {
            this.a[n3] = l;
            this.b[n3] = v;
            if (this.size++ >= this.j) {
                LongMap longMap = this;
                longMap.b(longMap.c << 1);
            }
            return;
        }
        this.a(l, v, n, l2, n2, l3, n3, l4);
    }

    private void a(long l, V v, int n, long l2, int n2, long l3, int n3, long l4) {
        V v2;
        long l5;
        long[] lArray = this.a;
        V[] VArray = this.b;
        int n4 = this.i;
        int n5 = 0;
        int n6 = this.l;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    l5 = l2;
                    v2 = VArray[n];
                    lArray[n] = l;
                    VArray[n] = v;
                    break;
                }
                case 1: {
                    l5 = l3;
                    v2 = VArray[n2];
                    lArray[n2] = l;
                    VArray[n2] = v;
                    break;
                }
                default: {
                    l5 = l4;
                    v2 = VArray[n3];
                    lArray[n3] = l;
                    VArray[n3] = v;
                }
            }
            n = (int)(l5 & (long)n4);
            l2 = lArray[n];
            if (l2 == 0L) {
                lArray[n] = l5;
                VArray[n] = v2;
                if (this.size++ >= this.j) {
                    LongMap longMap = this;
                    longMap.b(longMap.c << 1);
                }
                return;
            }
            n2 = this.a(l5);
            l3 = lArray[n2];
            if (l3 == 0L) {
                lArray[n2] = l5;
                VArray[n2] = v2;
                if (this.size++ >= this.j) {
                    LongMap longMap = this;
                    longMap.b(longMap.c << 1);
                }
                return;
            }
            n3 = this.b(l5);
            l4 = lArray[n3];
            if (l4 == 0L) {
                lArray[n3] = l5;
                VArray[n3] = v2;
                if (this.size++ >= this.j) {
                    LongMap longMap = this;
                    longMap.b(longMap.c << 1);
                }
                return;
            }
            if (++n5 == n6) break;
            l = l5;
            v = v2;
        }
        this.b(l5, v2);
    }

    private void b(long l, V v) {
        if (this.d == this.k) {
            LongMap longMap = this;
            longMap.b(longMap.c << 1);
            this.put(l, v);
            return;
        }
        int n = this.c + this.d;
        this.a[n] = l;
        this.b[n] = v;
        ++this.d;
        ++this.size;
    }

    public V get(long key) {
        if (key == 0L) {
            if (!this.f) {
                return null;
            }
            return this.e;
        }
        int n = (int)(key & (long)this.i);
        if (this.a[n] != key && this.a[n = this.a(key)] != key && this.a[n = this.b(key)] != key) {
            return this.c(key, null);
        }
        return this.b[n];
    }

    public V get(long key, V defaultValue) {
        if (key == 0L) {
            if (!this.f) {
                return defaultValue;
            }
            return this.e;
        }
        int n = (int)(key & (long)this.i);
        if (this.a[n] != key && this.a[n = this.a(key)] != key && this.a[n = this.b(key)] != key) {
            return this.c(key, defaultValue);
        }
        return this.b[n];
    }

    private V c(long l, V v) {
        long[] lArray = this.a;
        int n = this.c;
        int n2 = n + this.d;
        while (n < n2) {
            if (lArray[n] == l) {
                return this.b[n];
            }
            ++n;
        }
        return v;
    }

    public V remove(long key) {
        if (key == 0L) {
            if (!this.f) {
                return null;
            }
            V v = this.e;
            this.e = null;
            this.f = false;
            --this.size;
            return v;
        }
        int n = (int)(key & (long)this.i);
        if (this.a[n] == key) {
            this.a[n] = 0L;
            V v = this.b[n];
            this.b[n] = null;
            --this.size;
            return v;
        }
        n = this.a(key);
        if (this.a[n] == key) {
            this.a[n] = 0L;
            V v = this.b[n];
            this.b[n] = null;
            --this.size;
            return v;
        }
        n = this.b(key);
        if (this.a[n] == key) {
            this.a[n] = 0L;
            V v = this.b[n];
            this.b[n] = null;
            --this.size;
            return v;
        }
        LongMap longMap = this;
        long[] lArray = longMap.a;
        int n2 = longMap.c;
        int n3 = n2 + longMap.d;
        while (n2 < n3) {
            if (lArray[n2] == key) {
                V v = longMap.b[n2];
                longMap.a(n2);
                --longMap.size;
                return v;
            }
            ++n2;
        }
        return null;
    }

    final void a(int n) {
        --this.d;
        int n2 = this.c + this.d;
        if (n < n2) {
            this.a[n] = this.a[n2];
            this.b[n] = this.b[n2];
            this.b[n2] = null;
            return;
        }
        this.b[n] = null;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(maximumCapacity)));
        }
        if (this.size > maximumCapacity) {
            maximumCapacity = this.size;
        }
        if (this.c <= maximumCapacity) {
            return;
        }
        maximumCapacity = MathUtils.nextPowerOfTwo(maximumCapacity);
        this.b(maximumCapacity);
    }

    public void clear(int maximumCapacity) {
        if (this.c <= maximumCapacity) {
            this.clear();
            return;
        }
        this.e = null;
        this.f = false;
        this.size = 0;
        this.b(maximumCapacity);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        long[] lArray = this.a;
        V[] VArray = this.b;
        int n = this.c + this.d;
        while (n-- > 0) {
            lArray[n] = 0L;
            VArray[n] = null;
        }
        this.size = 0;
        this.d = 0;
        this.e = null;
        this.f = false;
    }

    public boolean containsValue(Object value, boolean identity) {
        V[] VArray = this.b;
        if (value == null) {
            if (this.f && this.e == null) {
                return true;
            }
            long[] lArray = this.a;
            int n = this.c + this.d;
            while (n-- > 0) {
                if (lArray[n] == 0L || VArray[n] != null) continue;
                return true;
            }
        } else if (identity) {
            if (value == this.e) {
                return true;
            }
            int n = this.c + this.d;
            while (n-- > 0) {
                if (VArray[n] != value) continue;
                return true;
            }
        } else {
            if (this.f && value.equals(this.e)) {
                return true;
            }
            int n = this.c + this.d;
            while (n-- > 0) {
                if (!value.equals(VArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        if (key == 0L) {
            return this.f;
        }
        int n = (int)(key & (long)this.i);
        if (this.a[n] != key && this.a[n = this.a(key)] != key && this.a[n = this.b(key)] != key) {
            LongMap longMap = this;
            long[] lArray = longMap.a;
            int n2 = longMap.c;
            int n3 = n2 + longMap.d;
            while (n2 < n3) {
                if (lArray[n2] == key) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public long findKey(Object value, boolean identity, long notFound) {
        V[] VArray = this.b;
        if (value == null) {
            if (this.f && this.e == null) {
                return 0L;
            }
            long[] lArray = this.a;
            int n = this.c + this.d;
            while (n-- > 0) {
                if (lArray[n] == 0L || VArray[n] != null) continue;
                return lArray[n];
            }
        } else if (identity) {
            if (value == this.e) {
                return 0L;
            }
            int n = this.c + this.d;
            while (n-- > 0) {
                if (VArray[n] != value) continue;
                return this.a[n];
            }
        } else {
            if (this.f && value.equals(this.e)) {
                return 0L;
            }
            int n = this.c + this.d;
            while (n-- > 0) {
                if (!value.equals(VArray[n])) continue;
                return this.a[n];
            }
        }
        return notFound;
    }

    public void ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n >= this.j) {
            this.b(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.g)));
        }
    }

    private void b(int n) {
        int n2 = this.c + this.d;
        this.c = n;
        this.j = (int)((float)n * this.g);
        this.i = n - 1;
        this.h = 63 - Long.numberOfTrailingZeros(n);
        this.k = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.l = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        long[] lArray = this.a;
        V[] VArray = this.b;
        this.a = new long[n + this.k];
        this.b = new Object[n + this.k];
        int n3 = this.size;
        this.size = this.f ? 1 : 0;
        this.d = 0;
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < n2) {
                long l = lArray[n4];
                if (l != 0L) {
                    this.a(l, VArray[n4]);
                }
                ++n4;
            }
        }
    }

    private int a(long l) {
        long l2 = l * -1262997959L;
        return (int)((l2 ^ l2 >>> this.h) & (long)this.i);
    }

    private int b(long l) {
        long l2 = l * -825114047L;
        return (int)((l2 ^ l2 >>> this.h) & (long)this.i);
    }

    public int hashCode() {
        int n = 0;
        if (this.f && this.e != null) {
            n = 0 + this.e.hashCode();
        }
        long[] lArray = this.a;
        V[] VArray = this.b;
        int n2 = 0;
        int n3 = this.c + this.d;
        while (n2 < n3) {
            long l = lArray[n2];
            if (l != 0L) {
                long l2 = l;
                n += (int)(l2 ^ l2 >>> 32) * 31;
                V v = VArray[n2];
                if (v != null) {
                    n += v.hashCode();
                }
            }
            ++n2;
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongMap)) {
            return false;
        }
        LongMap longMap = (LongMap)obj;
        if (longMap.size != this.size) {
            return false;
        }
        if (longMap.f != this.f) {
            return false;
        }
        if (this.f && (longMap.e == null ? this.e != null : !longMap.e.equals(this.e))) {
            return false;
        }
        long[] lArray = this.a;
        V[] VArray = this.b;
        int n = 0;
        int n2 = this.c + this.d;
        while (n < n2) {
            V v;
            long l = lArray[n];
            if (l != 0L && ((v = VArray[n]) == null ? !longMap.containsKey(l) || longMap.get(l) != null : !v.equals(longMap.get(l)))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        long l;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        long[] lArray = this.a;
        V[] VArray = this.b;
        int n = lArray.length;
        while (n-- > 0) {
            l = lArray[n];
            if (l == 0L) continue;
            stringBuilder.append(l);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
            break;
        }
        while (n-- > 0) {
            l = lArray[n];
            if (l == 0L) continue;
            stringBuilder.append(", ");
            stringBuilder.append(l);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Entries<V> entries() {
        if (this.m == null) {
            this.m = new Entries(this);
            this.n = new Entries(this);
        }
        if (!this.m.d) {
            this.m.reset();
            this.m.d = true;
            this.n.d = false;
            return this.m;
        }
        this.n.reset();
        this.n.d = true;
        this.m.d = false;
        return this.n;
    }

    public Values<V> values() {
        if (this.o == null) {
            this.o = new Values(this);
            this.p = new Values(this);
        }
        if (!this.o.d) {
            this.o.reset();
            this.o.d = true;
            this.p.d = false;
            return this.o;
        }
        this.p.reset();
        this.p.d = true;
        this.o.d = false;
        return this.p;
    }

    public Keys keys() {
        if (this.q == null) {
            this.q = new Keys(this);
            this.r = new Keys(this);
        }
        if (!this.q.d) {
            this.q.reset();
            this.q.d = true;
            this.r.d = false;
            return this.q;
        }
        this.r.reset();
        this.r.d = true;
        this.q.d = false;
        return this.r;
    }

    public static class Entries<V>
    extends a<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private Entry<V> e = new Entry();

        public Entries(LongMap map) {
            super(map);
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            long[] lArray = this.a.a;
            if (this.b == -1) {
                this.e.key = 0L;
                this.e.value = this.a.e;
            } else {
                this.e.key = lArray[this.b];
                this.e.value = this.a.b[this.b];
            }
            this.c = this.b;
            this.a();
            return this.e;
        }

        @Override
        public boolean hasNext() {
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry<V> {
        public long key;
        public V value;

        public String toString() {
            return String.valueOf(this.key) + "=" + this.value;
        }
    }

    public static class Keys
    extends a {
        public Keys(LongMap map) {
            super(map);
        }

        public long next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            long l = this.b == -1 ? 0L : this.a.a[this.b];
            this.c = this.b;
            this.a();
            return l;
        }

        public LongArray toArray() {
            LongArray longArray = new LongArray(true, this.a.size);
            while (this.hasNext) {
                longArray.add(this.next());
            }
            return longArray;
        }
    }

    static class a<V> {
        public boolean hasNext;
        final LongMap<V> a;
        int b;
        int c;
        boolean d = true;

        public a(LongMap<V> longMap) {
            this.a = longMap;
            this.reset();
        }

        public void reset() {
            this.c = -2;
            this.b = -1;
            if (this.a.f) {
                this.hasNext = true;
                return;
            }
            this.a();
        }

        final void a() {
            this.hasNext = false;
            long[] lArray = this.a.a;
            int n = this.a.c + this.a.d;
            while (++this.b < n) {
                if (lArray[this.b] == 0L) continue;
                this.hasNext = true;
                return;
            }
        }

        public void remove() {
            if (this.c == -1 && this.a.f) {
                this.a.e = null;
                this.a.f = false;
            } else {
                if (this.c < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.c >= this.a.c) {
                    this.a.a(this.c);
                    this.b = this.c - 1;
                    this.a();
                } else {
                    this.a.a[this.c] = 0L;
                    this.a.b[this.c] = null;
                }
            }
            this.c = -2;
            --this.a.size;
        }
    }

    public static class Values<V>
    extends a<V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(LongMap<V> map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object v = this.b == -1 ? this.a.e : this.a.b[this.b];
            this.c = this.b;
            this.a();
            return v;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        public Array<V> toArray() {
            Array<V> array = new Array<V>(true, this.a.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }
}

