/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectIntMap<K>
implements Iterable<Entry<K>> {
    public int size;
    K[] a;
    int[] b;
    int c;
    int d;
    private float e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private Entries k;
    private Entries l;
    private Values m;
    private Values n;
    private Keys o;
    private Keys p;

    public ObjectIntMap() {
        this(51, 0.8f);
    }

    public ObjectIntMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public ObjectIntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: ".concat(String.valueOf(initialCapacity)));
        }
        if ((initialCapacity = MathUtils.nextPowerOfTwo((int)Math.ceil((float)initialCapacity / loadFactor))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: ".concat(String.valueOf(initialCapacity)));
        }
        this.c = initialCapacity;
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: ".concat(String.valueOf(loadFactor)));
        }
        this.e = loadFactor;
        this.h = (int)((float)this.c * loadFactor);
        this.g = this.c - 1;
        this.f = 31 - Integer.numberOfTrailingZeros(this.c);
        this.i = Math.max(3, (int)Math.ceil(Math.log(this.c)) * 2);
        this.j = Math.max(Math.min(this.c, 8), (int)Math.sqrt(this.c) / 8);
        this.a = new Object[this.c + this.i];
        this.b = new int[this.a.length];
    }

    public ObjectIntMap(ObjectIntMap<? extends K> map) {
        this((int)Math.floor((float)map.c * map.e), map.e);
        this.d = map.d;
        System.arraycopy(map.a, 0, this.a, 0, map.a.length);
        System.arraycopy(map.b, 0, this.b, 0, map.b.length);
        this.size = map.size;
    }

    public void put(K key, int value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        K[] KArray = this.a;
        int n = key.hashCode();
        int n2 = n & this.g;
        K k = KArray[n2];
        if (key.equals(k)) {
            this.b[n2] = value;
            return;
        }
        int n3 = this.c(n);
        K k2 = KArray[n3];
        if (key.equals(k2)) {
            this.b[n3] = value;
            return;
        }
        int n4 = this.d(n);
        K k3 = KArray[n4];
        if (key.equals(k3)) {
            this.b[n4] = value;
            return;
        }
        int n5 = this.c;
        int n6 = n5 + this.d;
        while (n5 < n6) {
            if (key.equals(KArray[n5])) {
                this.b[n5] = value;
                return;
            }
            ++n5;
        }
        if (k == null) {
            KArray[n2] = key;
            this.b[n2] = value;
            if (this.size++ >= this.h) {
                ObjectIntMap objectIntMap = this;
                objectIntMap.b(objectIntMap.c << 1);
            }
            return;
        }
        if (k2 == null) {
            KArray[n3] = key;
            this.b[n3] = value;
            if (this.size++ >= this.h) {
                ObjectIntMap objectIntMap = this;
                objectIntMap.b(objectIntMap.c << 1);
            }
            return;
        }
        if (k3 == null) {
            KArray[n4] = key;
            this.b[n4] = value;
            if (this.size++ >= this.h) {
                ObjectIntMap objectIntMap = this;
                objectIntMap.b(objectIntMap.c << 1);
            }
            return;
        }
        this.a(key, value, n2, k, n3, k2, n4, k3);
    }

    public void putAll(ObjectIntMap<K> map) {
        for (Entry entry : map.entries()) {
            this.put(entry.key, entry.value);
        }
    }

    private void a(K k, int n) {
        int n2 = k.hashCode();
        int n3 = n2 & this.g;
        K k2 = this.a[n3];
        if (k2 == null) {
            this.a[n3] = k;
            this.b[n3] = n;
            if (this.size++ >= this.h) {
                ObjectIntMap objectIntMap = this;
                objectIntMap.b(objectIntMap.c << 1);
            }
            return;
        }
        int n4 = this.c(n2);
        K k3 = this.a[n4];
        if (k3 == null) {
            this.a[n4] = k;
            this.b[n4] = n;
            if (this.size++ >= this.h) {
                ObjectIntMap objectIntMap = this;
                objectIntMap.b(objectIntMap.c << 1);
            }
            return;
        }
        int n5 = this.d(n2);
        K k4 = this.a[n5];
        if (k4 == null) {
            this.a[n5] = k;
            this.b[n5] = n;
            if (this.size++ >= this.h) {
                ObjectIntMap objectIntMap = this;
                objectIntMap.b(objectIntMap.c << 1);
            }
            return;
        }
        this.a(k, n, n3, k2, n4, k3, n5, k4);
    }

    private void a(K k, int n, int n2, K k2, int n3, K k3, int n4, K k4) {
        int n5;
        K k5;
        K[] KArray = this.a;
        int[] nArray = this.b;
        int n6 = this.g;
        int n7 = 0;
        int n8 = this.j;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    k5 = k2;
                    n5 = nArray[n2];
                    KArray[n2] = k;
                    nArray[n2] = n;
                    break;
                }
                case 1: {
                    k5 = k3;
                    n5 = nArray[n3];
                    KArray[n3] = k;
                    nArray[n3] = n;
                    break;
                }
                default: {
                    k5 = k4;
                    n5 = nArray[n4];
                    KArray[n4] = k;
                    nArray[n4] = n;
                }
            }
            int n9 = k5.hashCode();
            n2 = n9 & n6;
            k2 = KArray[n2];
            if (k2 == null) {
                KArray[n2] = k5;
                nArray[n2] = n5;
                if (this.size++ >= this.h) {
                    ObjectIntMap objectIntMap = this;
                    objectIntMap.b(objectIntMap.c << 1);
                }
                return;
            }
            n3 = this.c(n9);
            k3 = KArray[n3];
            if (k3 == null) {
                KArray[n3] = k5;
                nArray[n3] = n5;
                if (this.size++ >= this.h) {
                    ObjectIntMap objectIntMap = this;
                    objectIntMap.b(objectIntMap.c << 1);
                }
                return;
            }
            n4 = this.d(n9);
            k4 = KArray[n4];
            if (k4 == null) {
                KArray[n4] = k5;
                nArray[n4] = n5;
                if (this.size++ >= this.h) {
                    ObjectIntMap objectIntMap = this;
                    objectIntMap.b(objectIntMap.c << 1);
                }
                return;
            }
            if (++n7 == n8) break;
            k = k5;
            n = n5;
        }
        this.b(k5, n5);
    }

    private void b(K k, int n) {
        if (this.d == this.i) {
            ObjectIntMap objectIntMap = this;
            objectIntMap.b(objectIntMap.c << 1);
            this.put(k, n);
            return;
        }
        int n2 = this.c + this.d;
        this.a[n2] = k;
        this.b[n2] = n;
        ++this.d;
        ++this.size;
    }

    public int get(K key, int defaultValue) {
        int n = key.hashCode();
        int n2 = n & this.g;
        if (!(key.equals(this.a[n2]) || key.equals(this.a[n2 = this.c(n)]) || key.equals(this.a[n2 = this.d(n)]))) {
            K k = key;
            ObjectIntMap objectIntMap = this;
            K[] KArray = objectIntMap.a;
            int n3 = objectIntMap.c;
            int n4 = n3 + objectIntMap.d;
            while (n3 < n4) {
                if (k.equals(KArray[n3])) {
                    return objectIntMap.b[n3];
                }
                ++n3;
            }
            return defaultValue;
        }
        return this.b[n2];
    }

    public int getAndIncrement(K key, int defaultValue, int increment) {
        int n = key.hashCode();
        int n2 = n & this.g;
        if (!(key.equals(this.a[n2]) || key.equals(this.a[n2 = this.c(n)]) || key.equals(this.a[n2 = this.d(n)]))) {
            K k = key;
            ObjectIntMap objectIntMap = this;
            K[] KArray = objectIntMap.a;
            int n3 = objectIntMap.c;
            int n4 = n3 + objectIntMap.d;
            while (n3 < n4) {
                if (k.equals(KArray[n3])) {
                    int n5 = objectIntMap.b[n3];
                    objectIntMap.b[n3] = n5 + increment;
                    return n5;
                }
                ++n3;
            }
            objectIntMap.put(k, defaultValue + increment);
            return defaultValue;
        }
        int n6 = this.b[n2];
        this.b[n2] = n6 + increment;
        return n6;
    }

    public int remove(K key, int defaultValue) {
        int n = key.hashCode();
        int n2 = n & this.g;
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            int n3 = this.b[n2];
            --this.size;
            return n3;
        }
        n2 = this.c(n);
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            int n4 = this.b[n2];
            --this.size;
            return n4;
        }
        n2 = this.d(n);
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            int n5 = this.b[n2];
            --this.size;
            return n5;
        }
        K k = key;
        ObjectIntMap objectIntMap = this;
        K[] KArray = objectIntMap.a;
        int n6 = objectIntMap.c;
        int n7 = n6 + objectIntMap.d;
        while (n6 < n7) {
            if (k.equals(KArray[n6])) {
                int n8 = objectIntMap.b[n6];
                objectIntMap.a(n6);
                --objectIntMap.size;
                return n8;
            }
            ++n6;
        }
        return defaultValue;
    }

    final void a(int n) {
        --this.d;
        int n2 = this.c + this.d;
        if (n < n2) {
            this.a[n] = this.a[n2];
            this.b[n] = this.b[n2];
        }
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(maximumCapacity)));
        }
        if (this.size > maximumCapacity) {
            maximumCapacity = this.size;
        }
        if (this.c <= maximumCapacity) {
            return;
        }
        maximumCapacity = MathUtils.nextPowerOfTwo(maximumCapacity);
        this.b(maximumCapacity);
    }

    public void clear(int maximumCapacity) {
        if (this.c <= maximumCapacity) {
            this.clear();
            return;
        }
        this.size = 0;
        this.b(maximumCapacity);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.a;
        int n = this.c + this.d;
        while (n-- > 0) {
            KArray[n] = null;
        }
        this.size = 0;
        this.d = 0;
    }

    public boolean containsValue(int value) {
        K[] KArray = this.a;
        int[] nArray = this.b;
        int n = this.c + this.d;
        while (n-- > 0) {
            if (KArray[n] == null || nArray[n] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(K key) {
        int n = key.hashCode();
        int n2 = n & this.g;
        if (!(key.equals(this.a[n2]) || key.equals(this.a[n2 = this.c(n)]) || key.equals(this.a[n2 = this.d(n)]))) {
            K k = key;
            ObjectIntMap objectIntMap = this;
            K[] KArray = objectIntMap.a;
            int n3 = objectIntMap.c;
            int n4 = n3 + objectIntMap.d;
            while (n3 < n4) {
                if (k.equals(KArray[n3])) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        return true;
    }

    public K findKey(int value) {
        K[] KArray = this.a;
        int[] nArray = this.b;
        int n = this.c + this.d;
        while (n-- > 0) {
            if (KArray[n] == null || nArray[n] != value) continue;
            return KArray[n];
        }
        return null;
    }

    public void ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n >= this.h) {
            this.b(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.e)));
        }
    }

    private void b(int n) {
        int n2 = this.c + this.d;
        this.c = n;
        this.h = (int)((float)n * this.e);
        this.g = n - 1;
        this.f = 31 - Integer.numberOfTrailingZeros(n);
        this.i = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.j = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        K[] KArray = this.a;
        int[] nArray = this.b;
        this.a = new Object[n + this.i];
        this.b = new int[n + this.i];
        int n3 = this.size;
        this.size = 0;
        this.d = 0;
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < n2) {
                K k = KArray[n4];
                if (k != null) {
                    this.a(k, nArray[n4]);
                }
                ++n4;
            }
        }
    }

    private int c(int n) {
        int n2 = n * -1262997959;
        return (n2 ^ n2 >>> this.f) & this.g;
    }

    private int d(int n) {
        int n2 = n * -825114047;
        return (n2 ^ n2 >>> this.f) & this.g;
    }

    public int hashCode() {
        int n = 0;
        K[] KArray = this.a;
        int[] nArray = this.b;
        int n2 = 0;
        int n3 = this.c + this.d;
        while (n2 < n3) {
            K k = KArray[n2];
            if (k != null) {
                n += k.hashCode() * 31;
                int n4 = nArray[n2];
                n += n4;
            }
            ++n2;
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectIntMap)) {
            return false;
        }
        ObjectIntMap objectIntMap = (ObjectIntMap)obj;
        if (objectIntMap.size != this.size) {
            return false;
        }
        K[] KArray = this.a;
        int[] nArray = this.b;
        int n = 0;
        int n2 = this.c + this.d;
        while (n < n2) {
            K k = KArray[n];
            if (k != null) {
                int n3 = objectIntMap.get(k, 0);
                if (n3 == 0 && !objectIntMap.containsKey(k)) {
                    return false;
                }
                int n4 = nArray[n];
                if (n3 != n4) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        K k;
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        K[] KArray = this.a;
        int[] nArray = this.b;
        int n = KArray.length;
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n]);
            break;
        }
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(", ");
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public Entries<K> iterator() {
        return this.entries();
    }

    public Entries<K> entries() {
        if (this.k == null) {
            this.k = new Entries(this);
            this.l = new Entries(this);
        }
        if (!this.k.d) {
            this.k.reset();
            this.k.d = true;
            this.l.d = false;
            return this.k;
        }
        this.l.reset();
        this.l.d = true;
        this.k.d = false;
        return this.l;
    }

    public Values values() {
        if (this.m == null) {
            this.m = new Values((ObjectIntMap<?>)this);
            this.n = new Values((ObjectIntMap<?>)this);
        }
        if (!this.m.d) {
            this.m.reset();
            this.m.d = true;
            this.n.d = false;
            return this.m;
        }
        this.n.reset();
        this.n.d = true;
        this.m.d = false;
        return this.n;
    }

    public Keys<K> keys() {
        if (this.o == null) {
            this.o = new Keys(this);
            this.p = new Keys(this);
        }
        if (!this.o.d) {
            this.o.reset();
            this.o.d = true;
            this.p.d = false;
            return this.o;
        }
        this.p.reset();
        this.p.d = true;
        this.o.d = false;
        return this.p;
    }

    public static class Entries<K>
    extends a<K>
    implements Iterable<Entry<K>>,
    Iterator<Entry<K>> {
        private Entry<K> e = new Entry();

        public Entries(ObjectIntMap<K> map) {
            super(map);
        }

        @Override
        public Entry<K> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            K[] KArray = this.a.a;
            this.e.key = KArray[this.b];
            this.e.value = this.a.b[this.b];
            this.c = this.b;
            this.a();
            return this.e;
        }

        @Override
        public boolean hasNext() {
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public Entries<K> iterator() {
            return this;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry<K> {
        public K key;
        public int value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static class Keys<K>
    extends a<K>
    implements Iterable<K>,
    Iterator<K> {
        public Keys(ObjectIntMap<K> map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object k = this.a.a[this.b];
            this.c = this.b;
            this.a();
            return k;
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        public Array<K> toArray() {
            Array<K> array = new Array<K>(true, this.a.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    static class a<K> {
        public boolean hasNext;
        final ObjectIntMap<K> a;
        int b;
        int c;
        boolean d = true;

        public a(ObjectIntMap<K> objectIntMap) {
            this.a = objectIntMap;
            this.reset();
        }

        public void reset() {
            this.c = -1;
            this.b = -1;
            this.a();
        }

        final void a() {
            this.hasNext = false;
            K[] KArray = this.a.a;
            int n = this.a.c + this.a.d;
            while (++this.b < n) {
                if (KArray[this.b] == null) continue;
                this.hasNext = true;
                return;
            }
        }

        public void remove() {
            if (this.c < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.c >= this.a.c) {
                this.a.a(this.c);
                this.b = this.c - 1;
                this.a();
            } else {
                this.a.a[this.c] = null;
            }
            this.c = -1;
            --this.a.size;
        }
    }

    public static class Values
    extends a<Object> {
        public Values(ObjectIntMap<?> map) {
            super(map);
        }

        public boolean hasNext() {
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.d) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            int n = this.a.b[this.b];
            this.c = this.b;
            this.a();
            return n;
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.a.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }
}

