/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectMap<K, V>
implements Iterable<Entry<K, V>> {
    public int size;
    K[] a;
    V[] b;
    int c;
    int d;
    private float e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int j;
    private Entries k;
    private Entries l;
    private Values m;
    private Values n;
    private Keys o;
    private Keys p;

    public ObjectMap() {
        this(51, 0.8f);
    }

    public ObjectMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public ObjectMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: ".concat(String.valueOf(initialCapacity)));
        }
        if ((initialCapacity = MathUtils.nextPowerOfTwo((int)Math.ceil((float)initialCapacity / loadFactor))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: ".concat(String.valueOf(initialCapacity)));
        }
        this.c = initialCapacity;
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: ".concat(String.valueOf(loadFactor)));
        }
        this.e = loadFactor;
        this.h = (int)((float)this.c * loadFactor);
        this.g = this.c - 1;
        this.f = 31 - Integer.numberOfTrailingZeros(this.c);
        this.i = Math.max(3, (int)Math.ceil(Math.log(this.c)) * 2);
        this.j = Math.max(Math.min(this.c, 8), (int)Math.sqrt(this.c) / 8);
        this.a = new Object[this.c + this.i];
        this.b = new Object[this.a.length];
    }

    public ObjectMap(ObjectMap<? extends K, ? extends V> map) {
        this((int)Math.floor((float)map.c * map.e), map.e);
        this.d = map.d;
        System.arraycopy(map.a, 0, this.a, 0, map.a.length);
        System.arraycopy(map.b, 0, this.b, 0, map.b.length);
        this.size = map.size;
    }

    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        return this.a(key, value);
    }

    private V a(K k, V v) {
        K[] KArray = this.a;
        int n = k.hashCode();
        int n2 = n & this.g;
        K k2 = KArray[n2];
        if (k.equals(k2)) {
            V v2 = this.b[n2];
            this.b[n2] = v;
            return v2;
        }
        int n3 = this.c(n);
        K k3 = KArray[n3];
        if (k.equals(k3)) {
            V v3 = this.b[n3];
            this.b[n3] = v;
            return v3;
        }
        int n4 = this.d(n);
        K k4 = KArray[n4];
        if (k.equals(k4)) {
            V v4 = this.b[n4];
            this.b[n4] = v;
            return v4;
        }
        int n5 = this.c;
        int n6 = n5 + this.d;
        while (n5 < n6) {
            if (k.equals(KArray[n5])) {
                V v5 = this.b[n5];
                this.b[n5] = v;
                return v5;
            }
            ++n5;
        }
        if (k2 == null) {
            KArray[n2] = k;
            this.b[n2] = v;
            if (this.size++ >= this.h) {
                ObjectMap objectMap = this;
                objectMap.b(objectMap.c << 1);
            }
            return null;
        }
        if (k3 == null) {
            KArray[n3] = k;
            this.b[n3] = v;
            if (this.size++ >= this.h) {
                ObjectMap objectMap = this;
                objectMap.b(objectMap.c << 1);
            }
            return null;
        }
        if (k4 == null) {
            KArray[n4] = k;
            this.b[n4] = v;
            if (this.size++ >= this.h) {
                ObjectMap objectMap = this;
                objectMap.b(objectMap.c << 1);
            }
            return null;
        }
        this.a(k, v, n2, k2, n3, k3, n4, k4);
        return null;
    }

    public void putAll(ObjectMap<K, V> map) {
        this.ensureCapacity(map.size);
        for (Entry entry : map) {
            this.put(entry.key, entry.value);
        }
    }

    private void b(K k, V v) {
        int n = k.hashCode();
        int n2 = n & this.g;
        K k2 = this.a[n2];
        if (k2 == null) {
            this.a[n2] = k;
            this.b[n2] = v;
            if (this.size++ >= this.h) {
                ObjectMap objectMap = this;
                objectMap.b(objectMap.c << 1);
            }
            return;
        }
        int n3 = this.c(n);
        K k3 = this.a[n3];
        if (k3 == null) {
            this.a[n3] = k;
            this.b[n3] = v;
            if (this.size++ >= this.h) {
                ObjectMap objectMap = this;
                objectMap.b(objectMap.c << 1);
            }
            return;
        }
        int n4 = this.d(n);
        K k4 = this.a[n4];
        if (k4 == null) {
            this.a[n4] = k;
            this.b[n4] = v;
            if (this.size++ >= this.h) {
                ObjectMap objectMap = this;
                objectMap.b(objectMap.c << 1);
            }
            return;
        }
        this.a(k, v, n2, k2, n3, k3, n4, k4);
    }

    private void a(K k, V v, int n, K k2, int n2, K k3, int n3, K k4) {
        V v2;
        K k5;
        K[] KArray = this.a;
        V[] VArray = this.b;
        int n4 = this.g;
        int n5 = 0;
        int n6 = this.j;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    k5 = k2;
                    v2 = VArray[n];
                    KArray[n] = k;
                    VArray[n] = v;
                    break;
                }
                case 1: {
                    k5 = k3;
                    v2 = VArray[n2];
                    KArray[n2] = k;
                    VArray[n2] = v;
                    break;
                }
                default: {
                    k5 = k4;
                    v2 = VArray[n3];
                    KArray[n3] = k;
                    VArray[n3] = v;
                }
            }
            int n7 = k5.hashCode();
            n = n7 & n4;
            k2 = KArray[n];
            if (k2 == null) {
                KArray[n] = k5;
                VArray[n] = v2;
                if (this.size++ >= this.h) {
                    ObjectMap objectMap = this;
                    objectMap.b(objectMap.c << 1);
                }
                return;
            }
            n2 = this.c(n7);
            k3 = KArray[n2];
            if (k3 == null) {
                KArray[n2] = k5;
                VArray[n2] = v2;
                if (this.size++ >= this.h) {
                    ObjectMap objectMap = this;
                    objectMap.b(objectMap.c << 1);
                }
                return;
            }
            n3 = this.d(n7);
            k4 = KArray[n3];
            if (k4 == null) {
                KArray[n3] = k5;
                VArray[n3] = v2;
                if (this.size++ >= this.h) {
                    ObjectMap objectMap = this;
                    objectMap.b(objectMap.c << 1);
                }
                return;
            }
            if (++n5 == n6) break;
            k = k5;
            v = v2;
        }
        this.c(k5, v2);
    }

    private void c(K k, V v) {
        if (this.d == this.i) {
            ObjectMap objectMap = this;
            objectMap.b(objectMap.c << 1);
            this.a(k, v);
            return;
        }
        int n = this.c + this.d;
        this.a[n] = k;
        this.b[n] = v;
        ++this.d;
        ++this.size;
    }

    public V get(K key) {
        int n = key.hashCode();
        int n2 = n & this.g;
        if (!(key.equals(this.a[n2]) || key.equals(this.a[n2 = this.c(n)]) || key.equals(this.a[n2 = this.d(n)]))) {
            K k = key;
            ObjectMap objectMap = this;
            K[] KArray = objectMap.a;
            int n3 = objectMap.c;
            int n4 = n3 + objectMap.d;
            while (n3 < n4) {
                if (k.equals(KArray[n3])) {
                    return objectMap.b[n3];
                }
                ++n3;
            }
            return null;
        }
        return this.b[n2];
    }

    public V get(K key, V defaultValue) {
        int n = key.hashCode();
        int n2 = n & this.g;
        if (!(key.equals(this.a[n2]) || key.equals(this.a[n2 = this.c(n)]) || key.equals(this.a[n2 = this.d(n)]))) {
            V v = defaultValue;
            K k = key;
            ObjectMap objectMap = this;
            K[] KArray = objectMap.a;
            int n3 = objectMap.c;
            int n4 = n3 + objectMap.d;
            while (n3 < n4) {
                if (k.equals(KArray[n3])) {
                    return objectMap.b[n3];
                }
                ++n3;
            }
            return v;
        }
        return this.b[n2];
    }

    public V remove(K key) {
        int n = key.hashCode();
        int n2 = n & this.g;
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            V v = this.b[n2];
            this.b[n2] = null;
            --this.size;
            return v;
        }
        n2 = this.c(n);
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            V v = this.b[n2];
            this.b[n2] = null;
            --this.size;
            return v;
        }
        n2 = this.d(n);
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            V v = this.b[n2];
            this.b[n2] = null;
            --this.size;
            return v;
        }
        K k = key;
        ObjectMap objectMap = this;
        K[] KArray = objectMap.a;
        int n3 = objectMap.c;
        int n4 = n3 + objectMap.d;
        while (n3 < n4) {
            if (k.equals(KArray[n3])) {
                V v = objectMap.b[n3];
                objectMap.a(n3);
                --objectMap.size;
                return v;
            }
            ++n3;
        }
        return null;
    }

    final void a(int n) {
        --this.d;
        int n2 = this.c + this.d;
        if (n < n2) {
            this.a[n] = this.a[n2];
            this.b[n] = this.b[n2];
            this.b[n2] = null;
            return;
        }
        this.b[n] = null;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(maximumCapacity)));
        }
        if (this.size > maximumCapacity) {
            maximumCapacity = this.size;
        }
        if (this.c <= maximumCapacity) {
            return;
        }
        maximumCapacity = MathUtils.nextPowerOfTwo(maximumCapacity);
        this.b(maximumCapacity);
    }

    public void clear(int maximumCapacity) {
        if (this.c <= maximumCapacity) {
            this.clear();
            return;
        }
        this.size = 0;
        this.b(maximumCapacity);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.a;
        V[] VArray = this.b;
        int n = this.c + this.d;
        while (n-- > 0) {
            KArray[n] = null;
            VArray[n] = null;
        }
        this.size = 0;
        this.d = 0;
    }

    public boolean containsValue(Object value, boolean identity) {
        V[] VArray = this.b;
        if (value == null) {
            K[] KArray = this.a;
            int n = this.c + this.d;
            while (n-- > 0) {
                if (KArray[n] == null || VArray[n] != null) continue;
                return true;
            }
        } else if (identity) {
            int n = this.c + this.d;
            while (n-- > 0) {
                if (VArray[n] != value) continue;
                return true;
            }
        } else {
            int n = this.c + this.d;
            while (n-- > 0) {
                if (!value.equals(VArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(K key) {
        int n = key.hashCode();
        int n2 = n & this.g;
        if (!(key.equals(this.a[n2]) || key.equals(this.a[n2 = this.c(n)]) || key.equals(this.a[n2 = this.d(n)]))) {
            K k = key;
            ObjectMap objectMap = this;
            K[] KArray = objectMap.a;
            int n3 = objectMap.c;
            int n4 = n3 + objectMap.d;
            while (n3 < n4) {
                if (k.equals(KArray[n3])) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        return true;
    }

    public K findKey(Object value, boolean identity) {
        V[] VArray = this.b;
        if (value == null) {
            K[] KArray = this.a;
            int n = this.c + this.d;
            while (n-- > 0) {
                if (KArray[n] == null || VArray[n] != null) continue;
                return KArray[n];
            }
        } else if (identity) {
            int n = this.c + this.d;
            while (n-- > 0) {
                if (VArray[n] != value) continue;
                return this.a[n];
            }
        } else {
            int n = this.c + this.d;
            while (n-- > 0) {
                if (!value.equals(VArray[n])) continue;
                return this.a[n];
            }
        }
        return null;
    }

    public void ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n >= this.h) {
            this.b(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.e)));
        }
    }

    private void b(int n) {
        int n2 = this.c + this.d;
        this.c = n;
        this.h = (int)((float)n * this.e);
        this.g = n - 1;
        this.f = 31 - Integer.numberOfTrailingZeros(n);
        this.i = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.j = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        K[] KArray = this.a;
        V[] VArray = this.b;
        this.a = new Object[n + this.i];
        this.b = new Object[n + this.i];
        int n3 = this.size;
        this.size = 0;
        this.d = 0;
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < n2) {
                K k = KArray[n4];
                if (k != null) {
                    this.b(k, VArray[n4]);
                }
                ++n4;
            }
        }
    }

    private int c(int n) {
        int n2 = n * -1262997959;
        return (n2 ^ n2 >>> this.f) & this.g;
    }

    private int d(int n) {
        int n2 = n * -825114047;
        return (n2 ^ n2 >>> this.f) & this.g;
    }

    public int hashCode() {
        int n = 0;
        K[] KArray = this.a;
        V[] VArray = this.b;
        int n2 = 0;
        int n3 = this.c + this.d;
        while (n2 < n3) {
            K k = KArray[n2];
            if (k != null) {
                n += k.hashCode() * 31;
                V v = VArray[n2];
                if (v != null) {
                    n += v.hashCode();
                }
            }
            ++n2;
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectMap)) {
            return false;
        }
        ObjectMap objectMap = (ObjectMap)obj;
        if (objectMap.size != this.size) {
            return false;
        }
        K[] KArray = this.a;
        V[] VArray = this.b;
        int n = 0;
        int n2 = this.c + this.d;
        while (n < n2) {
            V v;
            K k = KArray[n];
            if (k != null && ((v = VArray[n]) == null ? !objectMap.containsKey(k) || objectMap.get(k) != null : !v.equals(objectMap.get(k)))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString(String separator) {
        return this.a(separator, false);
    }

    public String toString() {
        return this.a(", ", true);
    }

    private String a(String string, boolean bl) {
        K k;
        if (this.size == 0) {
            if (bl) {
                return "{}";
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        if (bl) {
            stringBuilder.append('{');
        }
        K[] KArray = this.a;
        V[] VArray = this.b;
        int n = KArray.length;
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
            break;
        }
        while (n-- > 0) {
            k = KArray[n];
            if (k == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n]);
        }
        if (bl) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public Entries<K, V> iterator() {
        return this.entries();
    }

    public Entries<K, V> entries() {
        if (this.k == null) {
            this.k = new Entries(this);
            this.l = new Entries(this);
        }
        if (!this.k.e) {
            this.k.reset();
            this.k.e = true;
            this.l.e = false;
            return this.k;
        }
        this.l.reset();
        this.l.e = true;
        this.k.e = false;
        return this.l;
    }

    public Values<V> values() {
        if (this.m == null) {
            this.m = new Values(this);
            this.n = new Values(this);
        }
        if (!this.m.e) {
            this.m.reset();
            this.m.e = true;
            this.n.e = false;
            return this.m;
        }
        this.n.reset();
        this.n.e = true;
        this.m.e = false;
        return this.n;
    }

    public Keys<K> keys() {
        if (this.o == null) {
            this.o = new Keys(this);
            this.p = new Keys(this);
        }
        if (!this.o.e) {
            this.o.reset();
            this.o.e = true;
            this.p.e = false;
            return this.o;
        }
        this.p.reset();
        this.p.e = true;
        this.o.e = false;
        return this.p;
    }

    public static class Entries<K, V>
    extends a<K, V, Entry<K, V>> {
        Entry<K, V> a = new Entry();

        public Entries(ObjectMap<K, V> map) {
            super(map);
        }

        @Override
        public Entry<K, V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            K[] KArray = this.b.a;
            this.a.key = KArray[this.c];
            this.a.value = this.b.b[this.c];
            this.d = this.c;
            this.a();
            return this.a;
        }

        @Override
        public boolean hasNext() {
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        public Entries<K, V> iterator() {
            return this;
        }
    }

    public static class Entry<K, V> {
        public K key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static class Keys<K>
    extends a<K, Object, K> {
        public Keys(ObjectMap<K, ?> map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object k = this.b.a[this.c];
            this.d = this.c;
            this.a();
            return k;
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        public Array<K> toArray() {
            return this.toArray(new Array(true, this.b.size));
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    static abstract class a<K, V, I>
    implements Iterable<I>,
    Iterator<I> {
        public boolean hasNext;
        final ObjectMap<K, V> b;
        int c;
        int d;
        boolean e = true;

        public a(ObjectMap<K, V> objectMap) {
            this.b = objectMap;
            this.reset();
        }

        public void reset() {
            this.d = -1;
            this.c = -1;
            this.a();
        }

        final void a() {
            this.hasNext = false;
            K[] KArray = this.b.a;
            int n = this.b.c + this.b.d;
            while (++this.c < n) {
                if (KArray[this.c] == null) continue;
                this.hasNext = true;
                return;
            }
        }

        @Override
        public void remove() {
            if (this.d < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.d >= this.b.c) {
                this.b.a(this.d);
                this.c = this.d - 1;
                this.a();
            } else {
                this.b.a[this.d] = null;
                this.b.b[this.d] = null;
            }
            this.d = -1;
            --this.b.size;
        }
    }

    public static class Values<V>
    extends a<Object, V, V> {
        public Values(ObjectMap<?, V> map) {
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object v = this.b.b[this.c];
            this.d = this.c;
            this.a();
            return v;
        }

        @Override
        public Values<V> iterator() {
            return this;
        }

        public Array<V> toArray() {
            return this.toArray(new Array(true, this.b.size));
        }

        public Array<V> toArray(Array<V> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }
}

