/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectSet<T>
implements Iterable<T> {
    public int size;
    T[] a;
    int b;
    int c;
    private float d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private ObjectSetIterator j;
    private ObjectSetIterator k;

    public ObjectSet() {
        this(51, 0.8f);
    }

    public ObjectSet(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public ObjectSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: ".concat(String.valueOf(initialCapacity)));
        }
        if ((initialCapacity = MathUtils.nextPowerOfTwo((int)Math.ceil((float)initialCapacity / loadFactor))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: ".concat(String.valueOf(initialCapacity)));
        }
        this.b = initialCapacity;
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: ".concat(String.valueOf(loadFactor)));
        }
        this.d = loadFactor;
        this.g = (int)((float)this.b * loadFactor);
        this.f = this.b - 1;
        this.e = 31 - Integer.numberOfTrailingZeros(this.b);
        this.h = Math.max(3, (int)Math.ceil(Math.log(this.b)) * 2);
        this.i = Math.max(Math.min(this.b, 8), (int)Math.sqrt(this.b) / 8);
        this.a = new Object[this.b + this.h];
    }

    public ObjectSet(ObjectSet set) {
        this((int)Math.floor((float)set.b * set.d), set.d);
        this.c = set.c;
        System.arraycopy(set.a, 0, this.a, 0, set.a.length);
        this.size = set.size;
    }

    public boolean add(T key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        T[] TArray = this.a;
        int n = key.hashCode();
        int n2 = n & this.f;
        T t = TArray[n2];
        if (key.equals(t)) {
            return false;
        }
        int n3 = this.c(n);
        T t2 = TArray[n3];
        if (key.equals(t2)) {
            return false;
        }
        int n4 = this.d(n);
        T t3 = TArray[n4];
        if (key.equals(t3)) {
            return false;
        }
        int n5 = this.b;
        int n6 = n5 + this.c;
        while (n5 < n6) {
            if (key.equals(TArray[n5])) {
                return false;
            }
            ++n5;
        }
        if (t == null) {
            TArray[n2] = key;
            if (this.size++ >= this.g) {
                ObjectSet objectSet = this;
                objectSet.b(objectSet.b << 1);
            }
            return true;
        }
        if (t2 == null) {
            TArray[n3] = key;
            if (this.size++ >= this.g) {
                ObjectSet objectSet = this;
                objectSet.b(objectSet.b << 1);
            }
            return true;
        }
        if (t3 == null) {
            TArray[n4] = key;
            if (this.size++ >= this.g) {
                ObjectSet objectSet = this;
                objectSet.b(objectSet.b << 1);
            }
            return true;
        }
        this.a(key, n2, t, n3, t2, n4, t3);
        return true;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(T ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(T[] array, int offset, int length) {
        this.ensureCapacity(length);
        int n = offset;
        int n2 = offset + length;
        while (n < n2) {
            this.add(array[n]);
            ++n;
        }
    }

    public void addAll(ObjectSet<T> set) {
        this.ensureCapacity(set.size);
        for (Object e : set) {
            this.add(e);
        }
    }

    private void a(T t) {
        int n = t.hashCode();
        int n2 = n & this.f;
        T t2 = this.a[n2];
        if (t2 == null) {
            this.a[n2] = t;
            if (this.size++ >= this.g) {
                ObjectSet objectSet = this;
                objectSet.b(objectSet.b << 1);
            }
            return;
        }
        int n3 = this.c(n);
        T t3 = this.a[n3];
        if (t3 == null) {
            this.a[n3] = t;
            if (this.size++ >= this.g) {
                ObjectSet objectSet = this;
                objectSet.b(objectSet.b << 1);
            }
            return;
        }
        int n4 = this.d(n);
        T t4 = this.a[n4];
        if (t4 == null) {
            this.a[n4] = t;
            if (this.size++ >= this.g) {
                ObjectSet objectSet = this;
                objectSet.b(objectSet.b << 1);
            }
            return;
        }
        this.a(t, n2, t2, n3, t3, n4, t4);
    }

    private void a(T t, int n, T t2, int n2, T t3, int n3, T t4) {
        T t5;
        T[] TArray = this.a;
        int n4 = this.f;
        int n5 = 0;
        int n6 = this.i;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    t5 = t2;
                    TArray[n] = t;
                    break;
                }
                case 1: {
                    t5 = t3;
                    TArray[n2] = t;
                    break;
                }
                default: {
                    t5 = t4;
                    TArray[n3] = t;
                }
            }
            int n7 = t5.hashCode();
            n = n7 & n4;
            t2 = TArray[n];
            if (t2 == null) {
                TArray[n] = t5;
                if (this.size++ >= this.g) {
                    ObjectSet objectSet = this;
                    objectSet.b(objectSet.b << 1);
                }
                return;
            }
            n2 = this.c(n7);
            t3 = TArray[n2];
            if (t3 == null) {
                TArray[n2] = t5;
                if (this.size++ >= this.g) {
                    ObjectSet objectSet = this;
                    objectSet.b(objectSet.b << 1);
                }
                return;
            }
            n3 = this.d(n7);
            t4 = TArray[n3];
            if (t4 == null) {
                TArray[n3] = t5;
                if (this.size++ >= this.g) {
                    ObjectSet objectSet = this;
                    objectSet.b(objectSet.b << 1);
                }
                return;
            }
            if (++n5 == n6) break;
            t = t5;
        }
        this.b(t5);
    }

    private void b(T t) {
        if (this.c == this.h) {
            ObjectSet objectSet = this;
            objectSet.b(objectSet.b << 1);
            this.add(t);
            return;
        }
        int n = this.b + this.c;
        this.a[n] = t;
        ++this.c;
        ++this.size;
    }

    public boolean remove(T key) {
        int n = key.hashCode();
        int n2 = n & this.f;
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            --this.size;
            return true;
        }
        n2 = this.c(n);
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            --this.size;
            return true;
        }
        n2 = this.d(n);
        if (key.equals(this.a[n2])) {
            this.a[n2] = null;
            --this.size;
            return true;
        }
        T t = key;
        ObjectSet objectSet = this;
        T[] TArray = objectSet.a;
        int n3 = objectSet.b;
        int n4 = n3 + objectSet.c;
        while (n3 < n4) {
            if (t.equals(TArray[n3])) {
                objectSet.a(n3);
                --objectSet.size;
                return true;
            }
            ++n3;
        }
        return false;
    }

    final void a(int n) {
        --this.c;
        int n2 = this.b + this.c;
        if (n < n2) {
            this.a[n] = this.a[n2];
        }
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: ".concat(String.valueOf(maximumCapacity)));
        }
        if (this.size > maximumCapacity) {
            maximumCapacity = this.size;
        }
        if (this.b <= maximumCapacity) {
            return;
        }
        maximumCapacity = MathUtils.nextPowerOfTwo(maximumCapacity);
        this.b(maximumCapacity);
    }

    public void clear(int maximumCapacity) {
        if (this.b <= maximumCapacity) {
            this.clear();
            return;
        }
        this.size = 0;
        this.b(maximumCapacity);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        T[] TArray = this.a;
        int n = this.b + this.c;
        while (n-- > 0) {
            TArray[n] = null;
        }
        this.size = 0;
        this.c = 0;
    }

    public boolean contains(T key) {
        int n = key.hashCode();
        int n2 = n & this.f;
        if (!(key.equals(this.a[n2]) || key.equals(this.a[n2 = this.c(n)]) || key.equals(this.a[n2 = this.d(n)]))) {
            T t = key;
            ObjectSet objectSet = this;
            T[] TArray = objectSet.a;
            int n3 = objectSet.b;
            int n4 = n3 + objectSet.c;
            while (n3 < n4) {
                if (t.equals(TArray[n3])) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        return true;
    }

    public T first() {
        T[] TArray = this.a;
        int n = 0;
        int n2 = this.b + this.c;
        while (n < n2) {
            if (TArray[n] != null) {
                return TArray[n];
            }
            ++n;
        }
        throw new IllegalStateException("ObjectSet is empty.");
    }

    public void ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n >= this.g) {
            this.b(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.d)));
        }
    }

    private void b(int n) {
        int n2 = this.b + this.c;
        this.b = n;
        this.g = (int)((float)n * this.d);
        this.f = n - 1;
        this.e = 31 - Integer.numberOfTrailingZeros(n);
        this.h = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.i = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        T[] TArray = this.a;
        this.a = new Object[n + this.h];
        int n3 = this.size;
        this.size = 0;
        this.c = 0;
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < n2) {
                T t = TArray[n4];
                if (t != null) {
                    this.a(t);
                }
                ++n4;
            }
        }
    }

    private int c(int n) {
        int n2 = n * -1262997959;
        return (n2 ^ n2 >>> this.e) & this.f;
    }

    private int d(int n) {
        int n2 = n * -825114047;
        return (n2 ^ n2 >>> this.e) & this.f;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        int n3 = this.b + this.c;
        while (n2 < n3) {
            if (this.a[n2] != null) {
                n += this.a[n2].hashCode();
            }
            ++n2;
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectSet)) {
            return false;
        }
        ObjectSet objectSet = (ObjectSet)obj;
        if (objectSet.size != this.size) {
            return false;
        }
        int n = 0;
        int n2 = this.b + this.c;
        while (n < n2) {
            if (this.a[n] != null && !objectSet.contains(this.a[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        return "{" + this.toString(", ") + '}';
    }

    public String toString(String separator) {
        T t;
        if (this.size == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        T[] TArray = this.a;
        int n = this.a.length;
        while (n-- > 0) {
            t = TArray[n];
            if (t == null) continue;
            stringBuilder.append(t);
            break;
        }
        while (n-- > 0) {
            t = TArray[n];
            if (t == null) continue;
            stringBuilder.append(separator);
            stringBuilder.append(t);
        }
        return stringBuilder.toString();
    }

    @Override
    public ObjectSetIterator<T> iterator() {
        if (this.j == null) {
            this.j = new ObjectSetIterator(this);
            this.k = new ObjectSetIterator(this);
        }
        if (!this.j.a) {
            this.j.reset();
            this.j.a = true;
            this.k.a = false;
            return this.j;
        }
        this.k.reset();
        this.k.a = true;
        this.j.a = false;
        return this.k;
    }

    public static <T> ObjectSet<T> with(T ... array) {
        ObjectSet<T> objectSet = new ObjectSet<T>();
        objectSet.addAll(array);
        return objectSet;
    }

    public static class ObjectSetIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public boolean hasNext;
        private ObjectSet<K> b;
        private int c;
        private int d;
        boolean a = true;

        public ObjectSetIterator(ObjectSet<K> set) {
            this.b = set;
            this.reset();
        }

        public void reset() {
            this.d = -1;
            this.c = -1;
            this.a();
        }

        private void a() {
            this.hasNext = false;
            T[] TArray = this.b.a;
            int n = this.b.b + this.b.c;
            while (++this.c < n) {
                if (TArray[this.c] == null) continue;
                this.hasNext = true;
                return;
            }
        }

        @Override
        public void remove() {
            if (this.d < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.d >= this.b.b) {
                this.b.a(this.d);
                this.c = this.d - 1;
                this.a();
            } else {
                this.b.a[this.d] = null;
            }
            this.d = -1;
            --this.b.size;
        }

        @Override
        public boolean hasNext() {
            if (!this.a) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.a) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object t = this.b.a[this.c];
            this.d = this.c;
            this.a();
            return (K)t;
        }

        @Override
        public ObjectSetIterator<K> iterator() {
            return this;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray() {
            return this.toArray(new Array(true, this.b.size));
        }
    }
}

