/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.NoSuchElementException;

public class OrderedMap<K, V>
extends ObjectMap<K, V> {
    final Array<K> e;
    private ObjectMap.Entries f;
    private ObjectMap.Entries g;
    private ObjectMap.Values h;
    private ObjectMap.Values i;
    private ObjectMap.Keys j;
    private ObjectMap.Keys k;

    public OrderedMap() {
        this.e = new Array();
    }

    public OrderedMap(int initialCapacity) {
        super(initialCapacity);
        this.e = new Array(this.c);
    }

    public OrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.e = new Array(this.c);
    }

    public OrderedMap(OrderedMap<? extends K, ? extends V> map) {
        super(map);
        this.e = new Array<K>(map.e);
    }

    @Override
    public V put(K key, V value) {
        if (!this.containsKey(key)) {
            this.e.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public V remove(K key) {
        this.e.removeValue(key, false);
        return super.remove(key);
    }

    @Override
    public void clear(int maximumCapacity) {
        this.e.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.e.clear();
        super.clear();
    }

    public Array<K> orderedKeys() {
        return this.e;
    }

    @Override
    public ObjectMap.Entries<K, V> iterator() {
        return this.entries();
    }

    @Override
    public ObjectMap.Entries<K, V> entries() {
        if (this.f == null) {
            this.f = new OrderedMapEntries(this);
            this.g = new OrderedMapEntries(this);
        }
        if (!this.f.e) {
            this.f.reset();
            this.f.e = true;
            this.g.e = false;
            return this.f;
        }
        this.g.reset();
        this.g.e = true;
        this.f.e = false;
        return this.g;
    }

    @Override
    public ObjectMap.Values<V> values() {
        if (this.h == null) {
            this.h = new OrderedMapValues(this);
            this.i = new OrderedMapValues(this);
        }
        if (!this.h.e) {
            this.h.reset();
            this.h.e = true;
            this.i.e = false;
            return this.h;
        }
        this.i.reset();
        this.i.e = true;
        this.h.e = false;
        return this.i;
    }

    @Override
    public ObjectMap.Keys<K> keys() {
        if (this.j == null) {
            this.j = new OrderedMapKeys(this);
            this.k = new OrderedMapKeys(this);
        }
        if (!this.j.e) {
            this.j.reset();
            this.j.e = true;
            this.k.e = false;
            return this.j;
        }
        this.k.reset();
        this.k.e = true;
        this.j.e = false;
        return this.k;
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('{');
        Array<K> array = this.e;
        int n = 0;
        int n2 = array.size;
        while (n < n2) {
            K k = array.get(n);
            if (n > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(this.get(k));
            ++n;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static class OrderedMapEntries<K, V>
    extends ObjectMap.Entries<K, V> {
        private Array<K> f;

        public OrderedMapEntries(OrderedMap<K, V> map) {
            super(map);
            this.f = map.e;
        }

        @Override
        public void reset() {
            this.c = 0;
            this.hasNext = this.b.size > 0;
        }

        @Override
        public ObjectMap.Entry next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            this.a.key = this.f.get(this.c);
            this.a.value = this.b.get(this.a.key);
            ++this.c;
            this.hasNext = this.c < this.b.size;
            return this.a;
        }

        @Override
        public void remove() {
            if (this.d < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            this.b.remove(this.a.key);
            --this.c;
        }
    }

    public static class OrderedMapKeys<K>
    extends ObjectMap.Keys<K> {
        private Array<K> a;

        public OrderedMapKeys(OrderedMap<K, ?> map) {
            super(map);
            this.a = map.e;
        }

        @Override
        public void reset() {
            this.c = 0;
            this.hasNext = this.b.size > 0;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            K k = this.a.get(this.c);
            ++this.c;
            this.hasNext = this.c < this.b.size;
            return k;
        }

        @Override
        public void remove() {
            if (this.d < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            this.b.remove(this.a.get(this.c - 1));
        }
    }

    public static class OrderedMapValues<V>
    extends ObjectMap.Values<V> {
        private Array a;

        public OrderedMapValues(OrderedMap<?, V> map) {
            super(map);
            this.a = map.e;
        }

        @Override
        public void reset() {
            this.c = 0;
            this.hasNext = this.b.size > 0;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.e) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object v = this.b.get(this.a.get(this.c));
            ++this.c;
            this.hasNext = this.c < this.b.size;
            return v;
        }

        @Override
        public void remove() {
            if (this.d < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            this.b.remove(this.a.get(this.c - 1));
        }
    }
}

