/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;

public abstract class Pool<T> {
    public final int max;
    public int peak;
    private final Array<T> a;

    public Pool() {
        this(16, Integer.MAX_VALUE);
    }

    public Pool(int initialCapacity) {
        this(initialCapacity, Integer.MAX_VALUE);
    }

    public Pool(int initialCapacity, int max) {
        this.a = new Array(false, initialCapacity);
        this.max = max;
    }

    protected abstract T newObject();

    public T obtain() {
        if (this.a.size == 0) {
            return this.newObject();
        }
        return this.a.pop();
    }

    public void free(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        if (this.a.size < this.max) {
            this.a.add(object);
            this.peak = Math.max(this.peak, this.a.size);
        }
        this.reset(object);
    }

    protected void reset(T object) {
        if (object instanceof Poolable) {
            ((Poolable)object).reset();
        }
    }

    public void freeAll(Array<T> objects) {
        if (objects == null) {
            throw new IllegalArgumentException("object cannot be null.");
        }
        Array<T> array = this.a;
        int n = this.max;
        int n2 = 0;
        while (n2 < objects.size) {
            T t = objects.get(n2);
            if (t != null) {
                if (array.size < n) {
                    array.add(t);
                }
                this.reset(t);
            }
            ++n2;
        }
        this.peak = Math.max(this.peak, array.size);
    }

    public void clear() {
        this.a.clear();
    }

    public int getFree() {
        return this.a.size;
    }

    public static interface Poolable {
        public void reset();
    }
}

