/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class Pools {
    private static final ObjectMap<Class, Pool> a = new ObjectMap();

    public static <T> Pool<T> get(Class<T> type, int max) {
        ReflectionPool<T> reflectionPool = a.get(type);
        if (reflectionPool == null) {
            reflectionPool = new ReflectionPool<T>(type, 4, max);
            a.put(type, reflectionPool);
        }
        return reflectionPool;
    }

    public static <T> Pool<T> get(Class<T> type) {
        return Pools.get(type, 100);
    }

    public static <T> void set(Class<T> type, Pool<T> pool) {
        a.put(type, pool);
    }

    public static <T> T obtain(Class<T> type) {
        return Pools.get(type).obtain();
    }

    public static void free(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        Pool pool = a.get(object.getClass());
        if (pool == null) {
            return;
        }
        pool.free(object);
    }

    public static void freeAll(Array objects) {
        Pools.freeAll(objects, false);
    }

    public static void freeAll(Array objects, boolean samePool) {
        if (objects == null) {
            throw new IllegalArgumentException("Objects cannot be null.");
        }
        Pool pool = null;
        int n = 0;
        int n2 = objects.size;
        while (n < n2) {
            Object t = objects.get(n);
            if (t != null && (pool != null || (pool = a.get(t.getClass())) != null)) {
                pool.free(t);
                if (!samePool) {
                    pool = null;
                }
            }
            ++n;
        }
    }

    private Pools() {
    }
}

