/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.ReflectionException;

public class ReflectionPool<T>
extends Pool<T> {
    private final Constructor a;

    public ReflectionPool(Class<T> type) {
        this(type, 16, Integer.MAX_VALUE);
    }

    public ReflectionPool(Class<T> type, int initialCapacity) {
        this(type, initialCapacity, Integer.MAX_VALUE);
    }

    public ReflectionPool(Class<T> type, int initialCapacity, int max) {
        super(initialCapacity, max);
        this.a = ReflectionPool.a(type);
        if (this.a == null) {
            throw new RuntimeException("Class cannot be created (missing no-arg constructor): " + type.getName());
        }
    }

    private static Constructor a(Class<T> clazz) {
        try {
            return ClassReflection.getConstructor(clazz, null);
        }
        catch (Exception exception) {
            try {
                Constructor constructor = ClassReflection.getDeclaredConstructor(clazz, null);
                constructor.setAccessible(true);
                return constructor;
            }
            catch (ReflectionException reflectionException) {
                return null;
            }
        }
    }

    @Override
    protected T newObject() {
        try {
            return (T)this.a.newInstance(null);
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Unable to create new instance: " + this.a.getDeclaringClass().getName(), exception);
        }
    }
}

