/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.Vector2;

public enum Scaling {
    fit,
    fill,
    fillX,
    fillY,
    stretch,
    stretchX,
    stretchY,
    none;

    private static final Vector2 a;

    static {
        a = new Vector2();
    }

    public final Vector2 apply(float sourceWidth, float sourceHeight, float targetWidth, float targetHeight) {
        switch (this) {
            case fit: {
                float f = targetHeight / targetWidth;
                float f2 = sourceHeight / sourceWidth;
                float f3 = f > f2 ? targetWidth / sourceWidth : targetHeight / sourceHeight;
                Scaling.a.x = sourceWidth * f3;
                Scaling.a.y = sourceHeight * f3;
                break;
            }
            case fill: {
                float f = targetHeight / targetWidth;
                float f4 = sourceHeight / sourceWidth;
                float f5 = f < f4 ? targetWidth / sourceWidth : targetHeight / sourceHeight;
                Scaling.a.x = sourceWidth * f5;
                Scaling.a.y = sourceHeight * f5;
                break;
            }
            case fillX: {
                float f = targetWidth / sourceWidth;
                Scaling.a.x = sourceWidth * f;
                Scaling.a.y = sourceHeight * f;
                break;
            }
            case fillY: {
                float f = targetHeight / sourceHeight;
                Scaling.a.x = sourceWidth * f;
                Scaling.a.y = sourceHeight * f;
                break;
            }
            case stretch: {
                Scaling.a.x = targetWidth;
                Scaling.a.y = targetHeight;
                break;
            }
            case stretchX: {
                Scaling.a.x = targetWidth;
                Scaling.a.y = sourceHeight;
                break;
            }
            case stretchY: {
                Scaling.a.x = sourceWidth;
                Scaling.a.y = targetHeight;
                break;
            }
            case none: {
                Scaling.a.x = sourceWidth;
                Scaling.a.y = sourceHeight;
            }
        }
        return a;
    }
}

