/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.QuickSelect;
import java.util.Comparator;

public class Select {
    private static Select a;
    private QuickSelect b;

    public static Select instance() {
        if (a == null) {
            a = new Select();
        }
        return a;
    }

    public <T> T select(T[] items, Comparator<T> comp, int kthLowest, int size) {
        int n = this.selectIndex(items, comp, kthLowest, size);
        return items[n];
    }

    public <T> int selectIndex(T[] items, Comparator<T> comp, int kthLowest, int size) {
        int n;
        if (size <= 0) {
            throw new GdxRuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new GdxRuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        if (kthLowest == 1) {
            n = Select.a(items, comp, size);
        } else if (kthLowest == size) {
            n = Select.b(items, comp, size);
        } else {
            if (this.b == null) {
                this.b = new QuickSelect();
            }
            n = this.b.select(items, comp, kthLowest, size);
        }
        return n;
    }

    private static <T> int a(T[] TArray, Comparator<T> comparator, int n) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            if (comparator.compare(TArray[n3], TArray[n2]) < 0) {
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    private static <T> int b(T[] TArray, Comparator<T> comparator, int n) {
        int n2 = 0;
        int n3 = 1;
        while (n3 < n) {
            if (comparator.compare(TArray[n3], TArray[n2]) > 0) {
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }
}

