/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.UUID;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SharedLibraryLoader {
    public static boolean isWindows = System.getProperty("os.name").contains("Windows");
    public static boolean isLinux = System.getProperty("os.name").contains("Linux");
    public static boolean isMac = System.getProperty("os.name").contains("Mac");
    public static boolean isIos = false;
    public static boolean isAndroid = false;
    public static boolean isARM = System.getProperty("os.arch").startsWith("arm");
    public static boolean is64Bit = System.getProperty("os.arch").equals("amd64") || System.getProperty("os.arch").equals("x86_64");
    public static String abi = System.getProperty("sun.arch.abi") != null ? System.getProperty("sun.arch.abi") : "";
    private static final HashSet<String> a;
    private String b;

    static {
        String string = System.getProperty("java.runtime.name");
        if (string != null && string.contains("Android Runtime")) {
            isAndroid = true;
            isWindows = false;
            isLinux = false;
            isMac = false;
            is64Bit = false;
        }
        if (!(isAndroid || isWindows || isLinux || isMac)) {
            isIos = true;
            is64Bit = false;
        }
        a = new HashSet();
    }

    public SharedLibraryLoader() {
    }

    public SharedLibraryLoader(String nativesJar) {
        this.b = nativesJar;
    }

    public String crc(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[4096];
        try {
            int n;
            while ((n = input.read(byArray)) != -1) {
                cRC32.update(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            StreamUtils.closeQuietly(input);
        }
        return Long.toString(cRC32.getValue(), 16);
    }

    public String mapLibraryName(String libraryName) {
        if (isWindows) {
            return String.valueOf(libraryName) + (is64Bit ? "64.dll" : ".dll");
        }
        if (isLinux) {
            return "lib" + libraryName + (isARM ? "arm" + abi : "") + (is64Bit ? "64.so" : ".so");
        }
        if (isMac) {
            return "lib" + libraryName + (is64Bit ? "64.dylib" : ".dylib");
        }
        return libraryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String libraryName) {
        if (isIos) {
            return;
        }
        Class<SharedLibraryLoader> clazz = SharedLibraryLoader.class;
        synchronized (SharedLibraryLoader.class) {
            if (SharedLibraryLoader.isLoaded(libraryName)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            String string = this.mapLibraryName(libraryName);
            try {
                block16: {
                    if (isAndroid) {
                        System.loadLibrary(string);
                    } else {
                        String string2 = string;
                        SharedLibraryLoader sharedLibraryLoader = this;
                        String string3 = sharedLibraryLoader.crc(sharedLibraryLoader.a(string2));
                        String string4 = new File(string2).getName();
                        File file = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/libgdx" + System.getProperty("user.name") + "/" + string3, string4);
                        Throwable throwable = sharedLibraryLoader.b(string2, string3, file);
                        if (throwable != null) {
                            block15: {
                                try {
                                    file = File.createTempFile(string3, null);
                                    if (!file.delete() || sharedLibraryLoader.b(string2, string3, file) != null) break block15;
                                    break block16;
                                }
                                catch (Throwable throwable2) {}
                            }
                            if (sharedLibraryLoader.b(string2, string3, file = new File(String.valueOf(System.getProperty("user.home")) + "/.libgdx/" + string3, string4)) != null && sharedLibraryLoader.b(string2, string3, file = new File(".temp/".concat(String.valueOf(string3)), string4)) != null) {
                                file = new File(System.getProperty("java.library.path"), string2);
                                if (file.exists()) {
                                    System.load(file.getAbsolutePath());
                                } else {
                                    throw new GdxRuntimeException(throwable);
                                }
                            }
                        }
                    }
                }
                SharedLibraryLoader.setLoaded(libraryName);
            }
            catch (Throwable throwable) {
                throw new GdxRuntimeException("Couldn't load shared library '" + string + "' for target: " + System.getProperty("os.name") + (is64Bit ? ", 64-bit" : ", 32-bit"), throwable);
            }
            return;
        }
    }

    private InputStream a(String string) {
        if (this.b == null) {
            InputStream inputStream = SharedLibraryLoader.class.getResourceAsStream("/".concat(String.valueOf(string)));
            if (inputStream == null) {
                throw new GdxRuntimeException("Unable to read file for extraction: ".concat(String.valueOf(string)));
            }
            return inputStream;
        }
        try {
            ZipFile zipFile = new ZipFile(this.b);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                throw new GdxRuntimeException("Couldn't find '" + string + "' in JAR: " + this.b);
            }
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Error reading '" + string + "' in JAR: " + this.b, iOException);
        }
    }

    public File extractFile(String sourcePath, String dirName) throws IOException {
        try {
            File file;
            SharedLibraryLoader sharedLibraryLoader = this;
            String string = sharedLibraryLoader.crc(sharedLibraryLoader.a(sourcePath));
            if (dirName == null) {
                dirName = string;
            }
            if ((file = SharedLibraryLoader.a(dirName, new File(sourcePath).getName())) == null && (file = SharedLibraryLoader.a(UUID.randomUUID().toString(), new File(sourcePath).getName())) == null) {
                throw new GdxRuntimeException("Unable to find writable path to extract file. Is the user home directory writable?");
            }
            return this.a(sourcePath, string, file);
        }
        catch (RuntimeException runtimeException) {
            File file = new File(System.getProperty("java.library.path"), sourcePath);
            if (file.exists()) {
                return file;
            }
            throw runtimeException;
        }
    }

    public void extractFileTo(String sourcePath, File dir) throws IOException {
        SharedLibraryLoader sharedLibraryLoader = this;
        this.a(sourcePath, sharedLibraryLoader.crc(sharedLibraryLoader.a(sourcePath)), new File(dir, new File(sourcePath).getName()));
    }

    private static File a(String string, String string2) {
        File file;
        File file2 = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + "/libgdx" + System.getProperty("user.name") + "/" + string, string2);
        if (SharedLibraryLoader.a(file2)) {
            return file2;
        }
        try {
            file = File.createTempFile(string, null);
            if (file.delete() && SharedLibraryLoader.a(file = new File(file, string2))) {
                return file;
            }
        }
        catch (IOException iOException) {}
        file = new File(String.valueOf(System.getProperty("user.home")) + "/.libgdx/" + string, string2);
        if (SharedLibraryLoader.a(file)) {
            return file;
        }
        file = new File(".temp/".concat(String.valueOf(string)), string2);
        if (SharedLibraryLoader.a(file)) {
            return file;
        }
        if (System.getenv("APP_SANDBOX_CONTAINER_ID") != null) {
            return file2;
        }
        return null;
    }

    private static boolean a(File file) {
        File file2;
        File file3 = file.getParentFile();
        if (file.exists()) {
            if (!file.canWrite() || !SharedLibraryLoader.b(file)) {
                return false;
            }
            file2 = new File(file3, UUID.randomUUID().toString());
        } else {
            file3.mkdirs();
            if (!file3.isDirectory()) {
                return false;
            }
            file2 = file;
        }
        try {
            new FileOutputStream(file2).close();
            return SharedLibraryLoader.b(file2);
            {
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        finally {
            file2.delete();
        }
    }

    private static boolean b(File file) {
        Method method;
        block3: {
            try {
                method = File.class.getMethod("canExecute", new Class[0]);
                if (!((Boolean)method.invoke((Object)file, new Object[0])).booleanValue()) break block3;
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE).invoke((Object)file, Boolean.TRUE, Boolean.FALSE);
        return (Boolean)method.invoke((Object)file, new Object[0]);
    }

    private File a(String string, String string2, File file) throws IOException {
        String string3 = null;
        if (file.exists()) {
            try {
                string3 = this.crc(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (string3 == null || !string3.equals(string2)) {
            try {
                int n;
                InputStream inputStream = this.a(string);
                file.getParentFile().mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                inputStream.close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error extracting file: " + string + "\nTo: " + file.getAbsolutePath(), iOException);
            }
        }
        return file;
    }

    private Throwable b(String string, String string2, File file) {
        try {
            System.load(this.a(string, string2, file).getAbsolutePath());
            return null;
        }
        catch (Throwable throwable) {
            return throwable;
        }
    }

    public static synchronized void setLoaded(String libraryName) {
        a.add(libraryName);
    }

    public static synchronized boolean isLoaded(String libraryName) {
        return a.contains(libraryName);
    }
}

