/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import java.util.Arrays;

public class ShortArray {
    public short[] items;
    public int size;
    public boolean ordered;

    public ShortArray() {
        this(true, 16);
    }

    public ShortArray(int capacity) {
        this(true, capacity);
    }

    public ShortArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new short[capacity];
    }

    public ShortArray(ShortArray array) {
        this.ordered = array.ordered;
        this.size = array.size;
        this.items = new short[this.size];
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public ShortArray(short[] array) {
        this(true, array, 0, array.length);
    }

    public ShortArray(boolean ordered, short[] array, int startIndex, int count) {
        this(ordered, count);
        this.size = count;
        System.arraycopy(array, startIndex, this.items, 0, count);
    }

    public void add(int value) {
        short[] sArray = this.items;
        if (this.size == sArray.length) {
            sArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        sArray[this.size++] = (short)value;
    }

    public void add(short value) {
        short[] sArray = this.items;
        if (this.size == sArray.length) {
            sArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        sArray[this.size++] = value;
    }

    public void addAll(ShortArray array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(ShortArray array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(short ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(short[] array, int offset, int length) {
        int n = this.size + length;
        short[] sArray = this.items;
        if (n > sArray.length) {
            sArray = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        System.arraycopy(array, offset, sArray, this.size, length);
        this.size += length;
    }

    public short get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, short value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void incr(int index, short value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = (short)(this.items[n] + value);
    }

    public void mul(int index, short value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = (short)(this.items[n] * value);
    }

    public void insert(int index, short value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        short[] sArray = this.items;
        if (this.size == sArray.length) {
            sArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(sArray, index, sArray, index + 1, this.size - index);
        } else {
            sArray[this.size] = sArray[index];
        }
        ++this.size;
        sArray[index] = value;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        short[] sArray = this.items;
        short s = this.items[first];
        sArray[first] = sArray[second];
        sArray[second] = s;
    }

    public boolean contains(short value) {
        int n = this.size - 1;
        short[] sArray = this.items;
        while (n >= 0) {
            if (sArray[n--] != value) continue;
            return true;
        }
        return false;
    }

    public int indexOf(short value) {
        short[] sArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (sArray[n] == value) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(char value) {
        short[] sArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            if (sArray[n] == value) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public boolean removeValue(short value) {
        short[] sArray = this.items;
        int n = 0;
        int n2 = this.size;
        while (n < n2) {
            if (sArray[n] == value) {
                this.removeIndex(n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public short removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        short[] sArray = this.items;
        short s = this.items[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(sArray, index + 1, sArray, index, this.size - index);
        } else {
            sArray[index] = sArray[this.size];
        }
        return s;
    }

    public void removeRange(int start, int end) {
        if (end >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        short[] sArray = this.items;
        int n = end - start + 1;
        if (this.ordered) {
            System.arraycopy(sArray, start + n, sArray, start, this.size - (start + n));
        } else {
            int n2 = this.size - 1;
            int n3 = 0;
            while (n3 < n) {
                sArray[start + n3] = sArray[n2 - n3];
                ++n3;
            }
        }
        this.size -= n;
    }

    public boolean removeAll(ShortArray array) {
        int n;
        int n2 = n = this.size;
        short[] sArray = this.items;
        int n3 = 0;
        int n4 = array.size;
        while (n3 < n4) {
            short s = array.get(n3);
            int n5 = 0;
            while (n5 < n) {
                if (s == sArray[n5]) {
                    this.removeIndex(n5);
                    --n;
                    break;
                }
                ++n5;
            }
            ++n3;
        }
        return n != n2;
    }

    public short pop() {
        return this.items[--this.size];
    }

    public short peek() {
        return this.items[this.size - 1];
    }

    public short first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public short[] shrink() {
        if (this.items.length != this.size) {
            ShortArray shortArray = this;
            shortArray.resize(shortArray.size);
        }
        return this.items;
    }

    public short[] ensureCapacity(int additionalCapacity) {
        int n = this.size + additionalCapacity;
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        return this.items;
    }

    public short[] setSize(int newSize) {
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected short[] resize(int newSize) {
        short[] sArray = new short[newSize];
        System.arraycopy(this.items, 0, sArray, 0, Math.min(this.size, newSize));
        this.items = sArray;
        return sArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        short[] sArray = this.items;
        int n = 0;
        int n2 = this.size - 1;
        int n3 = this.size / 2;
        while (n < n3) {
            int n4 = n2 - n;
            short s = sArray[n];
            sArray[n] = sArray[n4];
            sArray[n4] = s;
            ++n;
        }
    }

    public void shuffle() {
        short[] sArray = this.items;
        int n = this.size - 1;
        while (n >= 0) {
            int n2 = MathUtils.random(n);
            short s = sArray[n];
            sArray[n] = sArray[n2];
            sArray[n2] = s;
            --n;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public short random() {
        if (this.size == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public short[] toArray() {
        short[] sArray = new short[this.size];
        System.arraycopy(this.items, 0, sArray, 0, this.size);
        return sArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        short[] sArray = this.items;
        int n = 1;
        int n2 = 0;
        int n3 = this.size;
        while (n2 < n3) {
            n = n * 31 + sArray[n2];
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ShortArray)) {
            return false;
        }
        ShortArray shortArray = (ShortArray)object;
        int n = this.size;
        if (n != shortArray.size) {
            return false;
        }
        short[] sArray = this.items;
        short[] sArray2 = shortArray.items;
        int n2 = 0;
        while (n2 < n) {
            if (sArray[n2] != sArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        short[] sArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(sArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(", ");
            stringBuilder.append(sArray[n]);
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        short[] sArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(sArray[0]);
        int n = 1;
        while (n < this.size) {
            stringBuilder.append(separator);
            stringBuilder.append(sArray[n]);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static ShortArray with(short ... array) {
        return new ShortArray(array);
    }
}

