/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.BufferUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class StreamUtils {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final byte[] EMPTY_BYTES = new byte[0];

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        StreamUtils.copyStream(input, output, new byte[4096]);
    }

    public static void copyStream(InputStream input, OutputStream output, int bufferSize) throws IOException {
        StreamUtils.copyStream(input, output, new byte[bufferSize]);
    }

    public static void copyStream(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
        }
    }

    public static void copyStream(InputStream input, ByteBuffer output) throws IOException {
        StreamUtils.copyStream(input, output, new byte[4096]);
    }

    public static void copyStream(InputStream input, ByteBuffer output, int bufferSize) throws IOException {
        StreamUtils.copyStream(input, output, new byte[bufferSize]);
    }

    public static int copyStream(InputStream input, ByteBuffer output, byte[] buffer) throws IOException {
        int n;
        int n2 = output.position();
        int n3 = 0;
        while ((n = input.read(buffer)) != -1) {
            BufferUtils.copy(buffer, 0, (Buffer)output, n);
            output.position(n2 + (n3 += n));
        }
        output.position(n2);
        return n3;
    }

    public static byte[] copyStreamToByteArray(InputStream input) throws IOException {
        InputStream inputStream = input;
        return StreamUtils.copyStreamToByteArray(inputStream, inputStream.available());
    }

    public static byte[] copyStreamToByteArray(InputStream input, int estimatedSize) throws IOException {
        OptimizedByteArrayOutputStream optimizedByteArrayOutputStream = new OptimizedByteArrayOutputStream(Math.max(0, estimatedSize));
        StreamUtils.copyStream(input, optimizedByteArrayOutputStream);
        return ((ByteArrayOutputStream)optimizedByteArrayOutputStream).toByteArray();
    }

    public static String copyStreamToString(InputStream input) throws IOException {
        InputStream inputStream = input;
        return StreamUtils.copyStreamToString(inputStream, inputStream.available(), null);
    }

    public static String copyStreamToString(InputStream input, int estimatedSize) throws IOException {
        return StreamUtils.copyStreamToString(input, estimatedSize, null);
    }

    public static String copyStreamToString(InputStream input, int estimatedSize, String charset) throws IOException {
        int n;
        InputStreamReader inputStreamReader = charset == null ? new InputStreamReader(input) : new InputStreamReader(input, charset);
        StringWriter stringWriter = new StringWriter(Math.max(0, estimatedSize));
        char[] cArray = new char[4096];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringWriter.write(cArray, 0, n);
        }
        return stringWriter.toString();
    }

    public static void closeQuietly(Closeable c2) {
        if (c2 != null) {
            try {
                c2.close();
                return;
            }
            catch (Exception exception) {}
        }
    }

    public static class OptimizedByteArrayOutputStream
    extends ByteArrayOutputStream {
        public OptimizedByteArrayOutputStream(int initialSize) {
            super(initialSize);
        }

        @Override
        public synchronized byte[] toByteArray() {
            if (this.count == this.buf.length) {
                return this.buf;
            }
            return super.toByteArray();
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

