/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.async;

import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.async.AsyncResult;
import com.badlogic.gdx.utils.async.AsyncTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AsyncExecutor
implements Disposable {
    private final ExecutorService a;

    public AsyncExecutor(int maxConcurrent) {
        this.a = Executors.newFixedThreadPool(maxConcurrent, new ThreadFactory(this){
            private /* synthetic */ AsyncExecutor a;
            {
                this.a = asyncExecutor;
            }

            @Override
            public final Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "AsynchExecutor-Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    public <T> AsyncResult<T> submit(AsyncTask<T> task) {
        if (this.a.isShutdown()) {
            throw new GdxRuntimeException("Cannot run tasks on an executor that has been shutdown (disposed)");
        }
        return new AsyncResult(this.a.submit(new Callable<T>(this, task){
            private /* synthetic */ AsyncExecutor a;
            private final /* synthetic */ AsyncTask b;
            {
                this.a = asyncExecutor;
                this.b = asyncTask;
            }

            @Override
            public final T call() throws Exception {
                return this.b.call();
            }
        }));
    }

    @Override
    public void dispose() {
        this.a.shutdown();
        try {
            this.a.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            throw new GdxRuntimeException("Couldn't shutdown loading thread", interruptedException);
        }
    }
}

