/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Constructor;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.Modifier;

public final class ClassReflection {
    public static Class forName(String name) throws ReflectionException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException("Class not found: ".concat(String.valueOf(name)), classNotFoundException);
        }
    }

    public static String getSimpleName(Class c2) {
        return c2.getSimpleName();
    }

    public static boolean isInstance(Class c2, Object obj) {
        return c2.isInstance(obj);
    }

    public static boolean isAssignableFrom(Class c1, Class c2) {
        return c1.isAssignableFrom(c2);
    }

    public static boolean isMemberClass(Class c2) {
        return c2.isMemberClass();
    }

    public static boolean isStaticClass(Class c2) {
        return Modifier.isStatic(c2.getModifiers());
    }

    public static boolean isArray(Class c2) {
        return c2.isArray();
    }

    public static <T> T newInstance(Class<T> c2) throws ReflectionException {
        try {
            return c2.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException("Could not instantiate instance of class: " + c2.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException("Could not instantiate instance of class: " + c2.getName(), illegalAccessException);
        }
    }

    public static Constructor[] getConstructors(Class c2) {
        java.lang.reflect.Constructor<?>[] constructorArray = c2.getConstructors();
        Constructor[] constructorArray2 = new Constructor[constructorArray.length];
        int n = 0;
        int n2 = constructorArray.length;
        while (n < n2) {
            constructorArray2[n] = new Constructor(constructorArray[n]);
            ++n;
        }
        return constructorArray2;
    }

    public static Constructor getConstructor(Class c2, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Constructor(c2.getConstructor(parameterTypes));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation occurred while getting constructor for class: '" + c2.getName() + "'.", securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Constructor not found for class: " + c2.getName(), noSuchMethodException);
        }
    }

    public static Constructor getDeclaredConstructor(Class c2, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Constructor(c2.getDeclaredConstructor(parameterTypes));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting constructor for class: " + c2.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Constructor not found for class: " + c2.getName(), noSuchMethodException);
        }
    }

    public static Method[] getMethods(Class c2) {
        java.lang.reflect.Method[] methodArray = c2.getMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            methodArray2[n] = new Method(methodArray[n]);
            ++n;
        }
        return methodArray2;
    }

    public static Method getMethod(Class c2, String name, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Method(c2.getMethod(name, parameterTypes));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting method: " + name + ", for class: " + c2.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Method not found: " + name + ", for class: " + c2.getName(), noSuchMethodException);
        }
    }

    public static Method[] getDeclaredMethods(Class c2) {
        java.lang.reflect.Method[] methodArray = c2.getDeclaredMethods();
        Method[] methodArray2 = new Method[methodArray.length];
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            methodArray2[n] = new Method(methodArray[n]);
            ++n;
        }
        return methodArray2;
    }

    public static Method getDeclaredMethod(Class c2, String name, Class ... parameterTypes) throws ReflectionException {
        try {
            return new Method(c2.getDeclaredMethod(name, parameterTypes));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting method: " + name + ", for class: " + c2.getName(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException("Method not found: " + name + ", for class: " + c2.getName(), noSuchMethodException);
        }
    }

    public static Field[] getFields(Class c2) {
        java.lang.reflect.Field[] fieldArray = c2.getFields();
        Field[] fieldArray2 = new Field[fieldArray.length];
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            fieldArray2[n] = new Field(fieldArray[n]);
            ++n;
        }
        return fieldArray2;
    }

    public static Field getField(Class c2, String name) throws ReflectionException {
        try {
            return new Field(c2.getField(name));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting field: " + name + ", for class: " + c2.getName(), securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionException("Field not found: " + name + ", for class: " + c2.getName(), noSuchFieldException);
        }
    }

    public static Field[] getDeclaredFields(Class c2) {
        java.lang.reflect.Field[] fieldArray = c2.getDeclaredFields();
        Field[] fieldArray2 = new Field[fieldArray.length];
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            fieldArray2[n] = new Field(fieldArray[n]);
            ++n;
        }
        return fieldArray2;
    }

    public static Field getDeclaredField(Class c2, String name) throws ReflectionException {
        try {
            return new Field(c2.getDeclaredField(name));
        }
        catch (SecurityException securityException) {
            throw new ReflectionException("Security violation while getting field: " + name + ", for class: " + c2.getName(), securityException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectionException("Field not found: " + name + ", for class: " + c2.getName(), noSuchFieldException);
        }
    }
}

