/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.ArrayReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class Field {
    private final java.lang.reflect.Field a;

    Field(java.lang.reflect.Field field) {
        this.a = field;
    }

    public final String getName() {
        return this.a.getName();
    }

    public final Class getType() {
        return this.a.getType();
    }

    public final Class getDeclaringClass() {
        return this.a.getDeclaringClass();
    }

    public final boolean isAccessible() {
        return this.a.isAccessible();
    }

    public final void setAccessible(boolean accessible) {
        this.a.setAccessible(accessible);
    }

    public final boolean isDefaultAccess() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.a.getModifiers());
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.a.getModifiers());
    }

    public final boolean isProtected() {
        return Modifier.isProtected(this.a.getModifiers());
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.a.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.a.getModifiers());
    }

    public final boolean isTransient() {
        return Modifier.isTransient(this.a.getModifiers());
    }

    public final boolean isVolatile() {
        return Modifier.isVolatile(this.a.getModifiers());
    }

    public final boolean isSynthetic() {
        return this.a.isSynthetic();
    }

    public final Class getElementType(int index) {
        Type[] typeArray;
        Type type = this.a.getGenericType();
        if (type instanceof ParameterizedType && (typeArray = ((ParameterizedType)type).getActualTypeArguments()).length - 1 >= index) {
            Type type2;
            Type type3 = typeArray[index];
            if (type3 instanceof Class) {
                return (Class)type3;
            }
            if (type3 instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type3).getRawType();
            }
            if (type3 instanceof GenericArrayType && (type2 = ((GenericArrayType)type3).getGenericComponentType()) instanceof Class) {
                return ArrayReflection.newInstance((Class)type2, 0).getClass();
            }
        }
        return null;
    }

    public final Object get(Object obj) throws ReflectionException {
        try {
            return this.a.get(obj);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException("Object is not an instance of " + this.getDeclaringClass(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException("Illegal access to field: " + this.getName(), illegalAccessException);
        }
    }

    public final void set(Object obj, Object value) throws ReflectionException {
        try {
            this.a.set(obj, value);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException("Argument not valid for field: " + this.getName(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException("Illegal access to field: " + this.getName(), illegalAccessException);
        }
    }
}

