//
//  KSCrashMonitor_Deadlock.h
//
//  Created by Karl Stenerud on 2012-12-09.
//
//  Copyright (c) 2012 Karl Stenerud. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall remain in place
// in this source code.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//

/* Catches deadlocks in threads and queues.
 */


#ifndef HDR_KSCrashMonitor_Deadlock_h
#define HDR_KSCrashMonitor_Deadlock_h

#ifdef __cplusplus
extern "C" {
#endif


#include "KSCrashMonitor.h"

#include <stdbool.h>

    
/** Set the interval between watchdog checks on the main thread.
 * Default is 5 seconds.
 *
 * @param value The number of seconds between checks (0 = disabled).
 */
void kscm_setDeadlockHandlerWatchdogInterval(double value);

/** Access the Monitor API.
 */
KSCrashMonitorAPI* kscm_deadlock_getAPI(void);


#ifdef __cplusplus
}
#endif

#endif // HDR_KSCrashMonitor_Deadlock_h
