/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ConnectorUtils;
import anywheresoftware.b4a.DynamicBuilder;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.objects.streams.File;
import anywheresoftware.b4j.objects.ButtonWrapper;
import anywheresoftware.b4j.objects.CustomViewWrapper;
import anywheresoftware.b4j.objects.Form;
import anywheresoftware.b4j.objects.LabeledWrapper;
import anywheresoftware.b4j.objects.LayoutValues;
import anywheresoftware.b4j.objects.NodeWrapper;
import anywheresoftware.b4j.objects.PaneWrapper;
import anywheresoftware.b4j.objects.TextInputControlWrapper;
import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;

@BA.Hide
public class LayoutBuilder {
    private LayoutData layoutData;
    private HashMap<String, Object> viewsToSendInShellMode;
    private List<CustomViewWrapper> customViewWrappers = new ArrayList<CustomViewWrapper>();
    private HashMap<String, Field> classFields;
    private static WeakReference<Scene> lastScene;
    private static final int LOADLAYOUT = 1;
    private static final int RESIZE = 2;
    private static final int AUTOSCALE = 3;

    public LayoutBuilder(LayoutData ld) {
        this.layoutData = ld;
    }

    public LayoutValues loadLayout(String file, BA ba, Pane parent) throws Exception {
        int ph;
        int pw;
        if (BA.isShellModeRuntimeCheck(ba)) {
            this.viewsToSendInShellMode = new HashMap();
        }
        this.layoutData = new LayoutData();
        File.InputStreamWrapper in = File.OpenInput(File.getDirAssets(), file);
        DataInputStream din = new DataInputStream((InputStream)in.getObject());
        int version = ConnectorUtils.readInt(din);
        int pos = ConnectorUtils.readInt(din);
        while (pos > 0) {
            pos = (int)((long)pos - din.skip(pos));
        }
        String[] cache = null;
        cache = new String[ConnectorUtils.readInt(din)];
        int i = 0;
        while (i < cache.length) {
            cache[i] = ConnectorUtils.readString(din);
            ++i;
        }
        int numberOfVariants = ConnectorUtils.readInt(din);
        int i2 = 0;
        while (i2 < numberOfVariants) {
            this.layoutData.variants.add(LayoutValues.readFromStream(din));
            ++i2;
        }
        int chosenIndex = this.findBestVariant(parent.getScene());
        this.layoutData.props = ConnectorUtils.readMap(din, cache);
        din.close();
        int[] pwh = PaneWrapper.getDesignerWidthAndHeight(parent);
        if (pwh[0] == 0 || pwh[1] == 0) {
            if (parent.getScene() != null) {
                pw = (int)parent.getScene().getWidth();
                ph = (int)parent.getScene().getHeight();
            } else {
                pw = 300;
                ph = 300;
            }
        } else {
            pw = pwh[0];
            ph = pwh[1];
        }
        this.loadLayoutHeader(this.layoutData.props, ba, parent, true, "variant" + chosenIndex, pw, ph, 1, 0, 1.0f);
        if (((Boolean)this.layoutData.props.get("handleResizeEvent")).booleanValue()) {
            AbsObjectWrapper.getExtraTags(parent).put("layoutdata", this.layoutData);
        }
        this.layoutData.designerScriptName = file.toLowerCase(BA.cul);
        LayoutBuilder.runScripts(ba, parent, this.layoutData, chosenIndex, pw, ph);
        if (this.viewsToSendInShellMode != null) {
            ba.raiseEvent(null, "SEND_VIEWS_AFTER_LAYOUT", this.viewsToSendInShellMode);
        }
        for (CustomViewWrapper cvw : this.customViewWrappers) {
            cvw.AfterDesignerScript();
        }
        ButtonWrapper.RadioButtonWrapper.automaticGroups.clear();
        return this.layoutData.variants.get(chosenIndex);
    }

    private void loadLayoutHeader(Map<String, Object> props, BA ba, Pane parent, boolean firstCall, String currentVariant, int pw, int ph, int buildType, int duration, float autoscale) throws Exception {
        Map kids;
        Pane o;
        if (firstCall) {
            duration = (Integer)props.get("duration");
            if (buildType == 3) {
                duration = 0;
            } else if (buildType == 2) {
                duration = Math.min(duration, 50);
            }
            o = parent;
            if (buildType == 1) {
                Form.build(o, props, false);
            }
        } else {
            HashMap variant = (HashMap)props.get(currentVariant);
            String[] stringArray = new String[]{"left", "top", "width", "height", "hanchor", "vanchor"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                props.put(p, variant.get(p));
                ++n2;
            }
            props.put("pw", pw);
            props.put("ph", ph);
            props.put("duration", duration);
            props.put("ba", ba);
            String upperCaseName = (String)props.get("name");
            String name = upperCaseName.toLowerCase(BA.cul);
            if (buildType == 1) {
                ObjectWrapper<Object> assigningObject;
                NodeWrapper ow;
                Field field;
                o = (Node)DynamicBuilder.build(null, props, false, ba);
                String cls = (String)props.get("type");
                if (cls.startsWith(".")) {
                    cls = "anywheresoftware.b4j.objects" + cls;
                }
                if (this.classFields == null) {
                    this.classFields = new HashMap();
                    Field[] fieldArray = Class.forName(ba.className).getDeclaredFields();
                    int n3 = fieldArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        field = fieldArray[n4];
                        if (field.getName().startsWith("_")) {
                            this.classFields.put(field.getName(), field);
                        }
                        ++n4;
                    }
                }
                field = this.classFields.get("_" + name);
                if (cls.equals("anywheresoftware.b4j.objects.CustomViewWrapper")) {
                    CustomViewWrapper cvw = new CustomViewWrapper();
                    ow = cvw;
                    cvw.setObject(o);
                    this.customViewWrappers.add(cvw);
                    Object customObject = this.findCustomViewClass(props).newInstance();
                    cvw.customObject = customObject;
                    cvw.props = new HashMap<String, Object>(props);
                    assigningObject = customObject;
                } else {
                    ow = (NodeWrapper)Class.forName(cls).newInstance();
                    ow.setObject(o);
                    assigningObject = ow;
                    if (field != null && field.getType() != assigningObject.getClass()) {
                        ParameterizedType pt;
                        Type t;
                        if (BA.debugMode && (t = ow.getClass().getGenericSuperclass()) instanceof ParameterizedType && (pt = (ParameterizedType)t).getActualTypeArguments().length > 0) {
                            ParameterizedType fieldParamType = (ParameterizedType)field.getType().getGenericSuperclass();
                            Class actualType = pt.getActualTypeArguments()[0] instanceof ParameterizedType ? (Class)((ParameterizedType)pt.getActualTypeArguments()[0]).getActualTypeArguments()[0] : (Class)pt.getActualTypeArguments()[0];
                            if (!((Class)fieldParamType.getActualTypeArguments()[0]).isAssignableFrom(actualType)) {
                                throw new RuntimeException("Cannot convert: " + ow.getClass() + ", to: " + field.getType());
                            }
                        }
                        ObjectWrapper nw = (ObjectWrapper)field.getType().newInstance();
                        nw.setObject(o);
                        assigningObject = nw;
                    }
                }
                if (this.viewsToSendInShellMode != null) {
                    this.viewsToSendInShellMode.put(name, assigningObject);
                }
                this.layoutData.viewsMap.put(name, new WeakReference<Pane>(o));
                if (field != null) {
                    try {
                        field.set(ba.eventsTarget, assigningObject);
                    }
                    catch (IllegalArgumentException ee) {
                        throw new RuntimeException("Field " + name + " was declared with the wrong type.");
                    }
                }
                ow.innerInitialize(ba, ((String)props.get("eventName")).toLowerCase(BA.cul), true);
                parent.getChildren().add((Object)o);
            } else {
                WeakReference<Node> viewData = this.layoutData.viewsMap.get(name);
                o = (Node)viewData.get();
                if (o == null) {
                    return;
                }
                NodeWrapper.buildResize((Node)o, props, autoscale);
            }
        }
        if ((kids = (Map)props.get(":kids")) != null) {
            if (!firstCall) {
                int[] pwh = PaneWrapper.getDesignerWidthAndHeight(o);
                pw = pwh[0];
                ph = pwh[1];
            }
            int i = 0;
            while (i < kids.size()) {
                this.loadLayoutHeader((Map)kids.get(Integer.toString(i)), ba, o, false, currentVariant, pw, ph, buildType, duration, autoscale);
                ++i;
            }
        }
    }

    private Class<?> findCustomViewClass(Map<String, Object> props) throws ClassNotFoundException {
        Class<?> customClass;
        String cclass = (String)props.get("customType");
        if (cclass == null || cclass.length() == 0) {
            throw new RuntimeException("CustomView CustomType property was not set.");
        }
        try {
            customClass = Class.forName(cclass);
        }
        catch (ClassNotFoundException cnfe) {
            int dollar = cclass.lastIndexOf(".");
            if (dollar > -1) {
                String corrected = String.valueOf(BA.packageName) + cclass.substring(dollar);
                customClass = Class.forName(corrected);
            }
            throw cnfe;
        }
        return customClass;
    }

    private static void runScripts(BA ba, Pane parent, LayoutData ld, int chosenIndex, int w, int h) throws IllegalArgumentException, IllegalAccessException {
        lastScene = new WeakReference<Scene>(parent.getScene());
        StringBuilder sb = new StringBuilder();
        sb.append("LS_");
        int i = 0;
        while (i < ld.designerScriptName.length() - 4) {
            char c = ld.designerScriptName.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(c);
            } else {
                sb.append("_");
            }
            ++i;
        }
        try {
            Class<?> c = Class.forName(String.valueOf(BA.packageName) + ".designerscripts." + sb.toString());
            LayoutValues variant = ld.variants.get(chosenIndex);
            try {
                LayoutBuilder.runScriptMethod(c, LayoutBuilder.variantToMethod(null), variant, ba, parent, ld, w, h);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            LayoutBuilder.runScriptMethod(c, LayoutBuilder.variantToMethod(variant), variant, ba, parent, ld, w, h);
        }
        catch (ClassNotFoundException c) {
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private static void runScriptMethod(Class<?> c, String methodName, LayoutValues lv, BA ba, Pane parent, LayoutData ld, int w, int h) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method m = c.getMethod(methodName, BA.class, Node.class, LayoutValues.class, LayoutData.class, Integer.TYPE, Integer.TYPE, Float.TYPE);
        m.invoke(null, ba, parent, lv, ld, w, h, Float.valueOf(1.0f));
    }

    private static String variantToMethod(LayoutValues lv) {
        String variant = lv == null ? "general" : String.valueOf(String.valueOf(lv.Width)) + "x" + String.valueOf(lv.Height) + "_" + BA.NumberToString(lv.Scale).replace(".", "_");
        return "LS_" + variant;
    }

    private int findBestVariant(Scene scene) {
        LayoutValues device = new LayoutValues();
        if (scene == null) {
            return 0;
        }
        device.Width = (int)scene.getWidth();
        device.Height = (int)scene.getHeight();
        device.Scale = Common.Density;
        int chosenIndex = 0;
        LayoutValues chosen = null;
        float distance = Float.MAX_VALUE;
        int i = 0;
        while (i < this.layoutData.variants.size()) {
            LayoutValues test = this.layoutData.variants.get(i);
            if (chosen == null) {
                chosen = test;
                distance = test.calcDistance(device);
            } else {
                float testDistance = test.calcDistance(device);
                if (testDistance < distance) {
                    chosen = test;
                    distance = testDistance;
                    chosenIndex = i;
                }
            }
            ++i;
        }
        return chosenIndex;
    }

    public void resizeLayout(BA ba, Pane parent) {
        try {
            int chosenIndex = this.findBestVariant(parent.getScene());
            int[] pwh = PaneWrapper.getDesignerWidthAndHeight(parent);
            this.layoutData.firstRun = false;
            this.loadLayoutHeader(this.layoutData.props, ba, parent, true, "variant" + chosenIndex, pwh[0], pwh[1], 2, 0, 1.0f);
            LayoutBuilder.runScripts(ba, parent, this.layoutData, chosenIndex, pwh[0], pwh[1]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static double getScreenSize() {
        Scene sc = (Scene)lastScene.get();
        if (sc == null) {
            System.out.println("Scene is null!!!");
            return 10.0;
        }
        return Math.sqrt(Math.pow(sc.getWidth(), 2.0) + Math.pow(sc.getHeight(), 2.0)) / Screen.getPrimary().getDpi();
    }

    public static interface B4JTextControl {
        public String getText();

        public void setText(String var1);
    }

    @BA.Hide
    public static class LayoutData {
        public List<LayoutValues> variants = new ArrayList<LayoutValues>();
        public Map<String, Object> props;
        public Map<String, WeakReference<Node>> viewsMap = new HashMap<String, WeakReference<Node>>();
        public String designerScriptName;
        public boolean firstRun = true;

        public NodeWrapper get(String name) {
            Node d = (Node)this.viewsMap.get(name).get();
            NodeWrapper cnw = d instanceof Labeled ? new LabeledWrapper<Node>() : (d instanceof TextInputControl ? new TextInputControlWrapper() : new NodeWrapper.ConcreteNodeWrapper());
            cnw.setObject(d);
            return cnw;
        }
    }
}

