﻿B4A=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.85
@EndOfDesignText@
#Region Shared Files
#CustomBuildAction: folders ready, %WINDIR%\System32\Robocopy.exe,"..\..\Shared Files" "..\Files"
'Ctrl + click to sync files: ide://run?file=%WINDIR%\System32\Robocopy.exe&args=..\..\Shared+Files&args=..\Files&FilesSync=True
#End Region

'Ctrl + click to export as zip: ide://run?File=%B4X%\Zipper.jar&Args=TextRecognition.zip

Sub Class_Globals
	Private Root As B4XView
	Private xui As XUI
	Private recognizer As TextRecognizer
	Private smm As SimpleMediaManager
	Private chooser As MediaChooser
	Private Panel1 As B4XView
	Private CustomListView1 As CustomListView
	Private AnotherProgressBar1 As AnotherProgressBar
	Private pnlTop As B4XView
End Sub

Public Sub Initialize
'	B4XPages.GetManager.LogEvents = True
End Sub

'This event will be called once, before the page becomes visible.
Private Sub B4XPage_Created (Root1 As B4XView)
	Root = Root1
	Root.LoadLayout("MainPage")
	B4XPages.SetTitle(Me, "Text Recognition Example")
	recognizer.Initialize("Latin")
	smm.Initialize
	chooser.Initialize(Me, "chooser")
End Sub


Private Sub Button1_Click
	
End Sub

Private Sub btnChooseImage_Click
	Wait For (chooser.ChooseImage(Sender)) Complete (Result As MediaChooserResult)
	HandeChooserResult(Result)
End Sub

Private Sub btnCaptureImage_Click
	Wait For (chooser.CaptureImage) Complete (Result As MediaChooserResult)
	HandeChooserResult(Result)
End Sub

Private Sub Chooser_Progress (Value As Int)
	Select Value
		Case chooser.PROGRESS_HIDE
			AnotherProgressBar1.Visible = False
		Case chooser.PROGRESS_SHOW
			AnotherProgressBar1.Visible = True
		Case chooser.PROGRESS_INDETERMINATE
			AnotherProgressBar1.Value = 100
		Case Else
			AnotherProgressBar1.Value = Value
	End Select
	If Value = chooser.PROGRESS_HIDE Or Value = chooser.PROGRESS_SHOW Then
		For Each btn As B4XView In pnlTop.GetAllViewsRecursive
			btn.Enabled = Value = chooser.PROGRESS_HIDE
		Next
	End If
End Sub


Private Sub HandeChooserResult (ChooserResult As MediaChooserResult)
	Panel1.RemoveAllViews
	CustomListView1.Clear
	If ChooserResult.Success Then
		smm.SetMediaFromFile(Panel1, ChooserResult.MediaDir, ChooserResult.MediaFile, ChooserResult.Mime, Null)
		AnotherProgressBar1.Visible = True
		AnotherProgressBar1.Value = 100
		Wait For (recognizer.Recognize(xui.LoadBitmap(ChooserResult.MediaDir, ChooserResult.MediaFile))) Complete (Result As TextRecognizerResult)
		AnotherProgressBar1.Visible = False
		If Result.Success Then
			CustomListView1.AddTextItem(Result.Text, "")
		End If
	End If
End Sub