#import <Foundation/Foundation.h>
#import "iCore.h"

@class MQTTClientConnectionOptions;

/**
 * Implementation of a MQTT client.
 */
//~shortname: MqttClient
//~version: 1.10
//~event: Connected (Success As Boolean)
//~event: Disconnected
//~event: MessageArrived (Topic As String, Payload() As Byte)
@interface MQTTClient : NSObject
@property (nonatomic, readonly) int QOS_0_MOST_ONCE;
@property (nonatomic, readonly) int QOS_1_LEAST_ONCE;
@property (nonatomic, readonly) int QOS_2_EXACTLY_ONCE;
@property (nonatomic, readonly) BOOL IsInitialized;
@property (nonatomic, readonly) BOOL Connected;
@property (nonatomic, readonly) NSString* ClientId;
/**
 * Initializes the client.
 *EventName - Sets the subs that will handle the events.
 *ServerURI - The server URI. For example: tcp://localhost:51044
 */
- (void)Initialize:(B4I *)bi :(NSString *)EventName :(NSString *)ServerURI :(NSString *)ClientId;
/**
 * Tries to connect to the broker. The Connected event will be raised.
 */
- (void)Connect;
/**
 * Similar to Connect. Allows you to configure the connection options.
 */
- (void)Connect2:(MQTTClientConnectionOptions *)Options;
/**
 * Subscribes to the given topic.
 *Topic - Topic to subscribe.
 *QOS - QOS setting.
 */
- (void)Subscribe:(NSString *)Topic :(int)QOS;
/**
 * Unsubscribes from the given topic.
 */
- (void)Unsubscribe:(NSString *)Topic;
/**
 * Publishes a message to the given topic. The QOS will be set to 0 (note that it is different than jMQTT default).
 *Topic - The message will be delivered to this topic.
 *Payload - Message payload.
 *For example:<code>
 *Client.Publish("Topic", "Message".GetBytes("UTF8"))</code>
 */
- (void)Publish:(NSString *)Topic :(B4IArray */*unsigned char,1*/)Payload;
/**
 * Publishes a message to the given topic
 *Topic - The message will be delivered to this topic.
 *Payload - Message payload.
 *QOS - The QOS level.
 *Retained - Whether the server should retain the message (only the last message per topic is retained).
 */
- (void)Publish2:(NSString *)Topic :(B4IArray */*byte,1*/)Payload :(int)QOS :(BOOL)Retained;
/**
 * Closes the connection.
 */
- (void)Close;
@end

//~shortname: MqttConnectOptions
@interface MQTTClientConnectionOptions : NSObject
@property (nonatomic)NSString* Password;
@property (nonatomic)NSString* UserName;
//If set to true (default value) then the state will not be preserved in the case of client restarts.
@property (nonatomic)BOOL CleanSession;
@property (nonatomic)BOOL TrustAllCertificates;
/**
 * Initializes the object and sets the username and password.
 *Pass empty strings if username or password are not required.
 */
- (void)Initialize:(NSString *)Username :(NSString *)Password;
/**
 * Sets the Last Will message that will be sent if the client was disconnected abruptly.
 */
- (void)SetLastWill:(NSString *)Topic :(B4IArray */*byte,1*/)Payload :(int)QOS :(BOOL)Retained;

@end
