/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.objects;

import anywheresoftware.b4a.BA;

@BA.ShortName(value="Timer")
public class Timer
implements BA.CheckForReinitialize {
    private long interval;
    private boolean enabled = false;
    private int relevantTimer = 0;
    private BA ba;
    private String eventName;

    public void Initialize(BA ba, String EventName, long Interval) {
        this.interval = Interval;
        this.ba = ba;
        this.eventName = String.valueOf(EventName.toLowerCase(BA.cul)) + "_tick";
    }

    @Override
    public boolean IsInitialized() {
        return this.ba != null;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setInterval(long Interval) {
        if (this.interval == Interval) {
            return;
        }
        this.interval = Interval;
        if (this.enabled) {
            this.stopTicking();
            this.startTicking();
        }
    }

    public long getInterval() {
        return this.interval;
    }

    private void startTicking() {
        Thread t = new Thread(new TickTack(this.relevantTimer));
        t.setDaemon(true);
        t.start();
    }

    public void setEnabled(boolean Enabled) {
        if (Enabled == this.enabled) {
            return;
        }
        if (Enabled) {
            if (this.interval <= 0L) {
                throw new IllegalStateException("Interval must be larger than 0.");
            }
            this.startTicking();
        } else {
            this.stopTicking();
        }
        this.enabled = Enabled;
    }

    private void stopTicking() {
        ++this.relevantTimer;
    }

    class TickTack
    implements Runnable {
        private final int currentTimer;

        public TickTack(int currentTimer) {
            this.currentTimer = currentTimer;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(Timer.this.interval);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                if (this.currentTimer != Timer.this.relevantTimer) {
                    return;
                }
                Timer.this.ba.raiseEventFromDifferentThread(null, null, Timer.this, Timer.this.eventName, true, null);
            }
        }
    }
}

