/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4j.objects.JFX;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.util.HashMap;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;

@BA.ShortName(value="Canvas")
public class CanvasWrapper
extends NodeWrapper<Canvas> {
    @Override
    @BA.Hide
    public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new Canvas());
        }
        super.innerInitialize(ba, eventName, true);
    }

    public double getHeight() {
        return ((Canvas)this.getObject()).getHeight();
    }

    public double getWidth() {
        return ((Canvas)this.getObject()).getWidth();
    }

    public void setHeight(double d) {
        ((Canvas)this.getObject()).setHeight(d);
    }

    public void setWidth(double d) {
        ((Canvas)this.getObject()).setWidth(d);
    }

    public void ClipPath(List Points) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        if (Points.getSize() == 0) {
            return;
        }
        gc.beginPath();
        double[] p = (double[])Points.Get(0);
        gc.moveTo(p[0], p[1]);
        int i = 1;
        while (i < Points.getSize()) {
            double[] p2 = (double[])Points.Get(i);
            gc.lineTo(p2[0], p2[1]);
            ++i;
        }
        gc.closePath();
        gc.clip();
    }

    public void RemoveClip() {
        ((Canvas)this.getObject()).getGraphicsContext2D().restore();
    }

    public void DrawImage(Image Image2, double x, double y, double Width, double Height) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.drawImage(Image2, x, y, Width, Height);
    }

    public void DrawImageRotated(Image Image2, double x, double y, double Width, double Height, double Degree) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            this.rotate(gc, Degree, x + Width / 2.0, y + Height / 2.0);
            this.DrawImage(Image2, x, y, Width, Height);
        }
        finally {
            gc.restore();
        }
    }

    public void DrawImage2(Image Image2, double SourceX, double SourceY, double SourceWidth, double SourceHeight, double DestX, double DestY, double DestWidth, double DestHeight) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.drawImage(Image2, SourceX, SourceY, SourceWidth, SourceHeight, DestX, DestY, DestWidth, DestHeight);
    }

    public void DrawCircle(double x, double y, double Radius, Paint Paint2, boolean Filled, double StrokeWidth) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            if (Filled) {
                gc.setFill(Paint2);
                gc.fillOval(x - Radius, y - Radius, 2.0 * Radius, 2.0 * Radius);
            } else {
                gc.setStroke(Paint2);
                gc.setLineWidth(StrokeWidth);
                gc.strokeOval(x - Radius, y - Radius, 2.0 * Radius, 2.0 * Radius);
            }
        }
        finally {
            gc.restore();
        }
    }

    public void DrawRect(double x, double y, double Width, double Height, Paint Paint2, boolean Filled, double StrokeWidth) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            if (Filled) {
                gc.setFill(Paint2);
                gc.fillRect(x, y, Width, Height);
            } else {
                gc.setStroke(Paint2);
                gc.setLineWidth(StrokeWidth);
                gc.strokeRect(x, y, Width, Height);
            }
        }
        finally {
            gc.restore();
        }
    }

    private void rotate(GraphicsContext gc, double angle, double px, double py) {
        Rotate r = new Rotate(angle, px, py);
        gc.setTransform(r.getMxx(), r.getMyx(), r.getMxy(), r.getMyy(), r.getTx(), r.getTy());
    }

    public void DrawRectRotated(double x, double y, double Width, double Height, Paint Paint2, boolean Filled, double StrokeWidth, double Degree) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            this.rotate(gc, Degree, x + Width / 2.0, y + Height / 2.0);
            this.DrawRect(x, y, Width, Height, Paint2, Filled, StrokeWidth);
        }
        finally {
            gc.restore();
        }
    }

    public void DrawLine(double x1, double y1, double x2, double y2, Paint Paint2, double StrokeWidth) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            gc.setStroke(Paint2);
            gc.setLineWidth(StrokeWidth);
            gc.strokeLine(x1, y1, x2, y2);
        }
        finally {
            gc.restore();
        }
    }

    public void DrawText(String Text, double x, double y, Font Font2, Paint Paint2, TextAlignment Alignment) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            gc.setFill(Paint2);
            gc.setFont(Font2);
            gc.setTextAlign(Alignment);
            gc.fillText(Text, x, y);
        }
        finally {
            gc.restore();
        }
    }

    public void DrawTextRotated(String Text, double x, double y, Font Font2, Paint Paint2, TextAlignment Alignment, double Degree) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            this.rotate(gc, Degree, x, y);
            this.DrawText(Text, x, y, Font2, Paint2, Alignment);
        }
        finally {
            gc.restore();
        }
    }

    public void DrawText2(String Text, double x, double y, Font Font2, Paint Paint2, TextAlignment Alignment, double MaxWidth) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.save();
        try {
            gc.setFill(Paint2);
            gc.setFont(Font2);
            gc.setTextAlign(Alignment);
            gc.fillText(Text, x, y, MaxWidth);
        }
        finally {
            gc.restore();
        }
    }

    public void ClearRect(double x, double y, double Width, double Height) {
        GraphicsContext gc = ((Canvas)this.getObject()).getGraphicsContext2D();
        gc.clearRect(x, y, Width, Height);
    }

    public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
        Canvas vg = (Canvas)prev;
        if (vg == null) {
            vg = NodeWrapper.buildNativeView(Canvas.class, props, designer);
        }
        NodeWrapper.build(vg, props, designer);
        if (designer) {
            GraphicsContext gc = vg.getGraphicsContext2D();
            gc.save();
            try {
                gc.setStroke(JFX.Colors.Red);
                gc.setLineWidth(2.0);
                gc.clearRect(0.0, 0.0, vg.getWidth(), vg.getHeight());
                gc.strokeLine(0.0, 0.0, vg.getWidth(), vg.getHeight());
                gc.strokeLine(vg.getWidth(), 0.0, 0.0, vg.getHeight());
            }
            finally {
                gc.restore();
            }
        }
        return vg;
    }
}

