/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4j.objects.ImageViewWrapper;
import anywheresoftware.b4j.objects.MenuItemWrapper;
import anywheresoftware.b4j.objects.NodeWrapper;
import anywheresoftware.b4j.objects.PaneWrapper;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;

@BA.ShortName(value="TabPane")
public class TabPaneWrapper
extends NodeWrapper.ControlWrapper<TabPane> {
    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new TabPane());
        }
        super.innerInitialize(ba, eventName, true);
        final Object sender = this.getObject();
        if (ba.subExists(String.valueOf(eventName) + "_tabchanged")) {
            ((TabPane)this.getObject()).getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){

                public void changed(ObservableValue<? extends Tab> arg0, Tab arg1, Tab arg2) {
                    ba.raiseEventFromUI(sender, String.valueOf(eventName) + "_tabchanged", AbsObjectWrapper.ConvertToWrapper(new TabWrapper(), arg2));
                }
            });
        }
        ((TabPane)this.getObject()).setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
    }

    public void SetSide(Side Side2) {
        ((TabPane)this.getObject()).setSide(Side2);
    }

    public List getTabs() {
        List l1 = new List();
        l1.setObject(((TabPane)this.getObject()).getTabs());
        return l1;
    }

    public int getSelectedIndex() {
        return ((TabPane)this.getObject()).getSelectionModel().getSelectedIndex();
    }

    public void setSelectedIndex(int i) {
        ((TabPane)this.getObject()).getSelectionModel().select(i);
    }

    public TabWrapper getSelectedItem() {
        return (TabWrapper)AbsObjectWrapper.ConvertToWrapper(new TabWrapper(), ((TabPane)this.getObject()).getSelectionModel().getSelectedItem());
    }

    @BA.RaisesSynchronousEvents
    public TabWrapper LoadLayout(BA ba, String LayoutFile, String TabText) throws Exception {
        TabWrapper tw = new TabWrapper();
        tw.Initialize();
        tw.setText(TabText);
        PaneWrapper.ConcretePaneWrapper cnw = new PaneWrapper.ConcretePaneWrapper();
        cnw.Initialize(ba, "");
        tw.setContent((Pane)cnw.getObject());
        cnw.LoadLayout(ba, LayoutFile);
        this.getTabs().Add(tw.getObject());
        return tw;
    }

    public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
        TabPane vg = (TabPane)prev;
        if (vg == null) {
            vg = NodeWrapper.buildNativeView(TabPane.class, props, designer);
            if (designer) {
                int i = 1;
                while (i <= 3) {
                    vg.getTabs().add((Object)new Tab("Tab #" + i));
                    ++i;
                }
            }
            vg.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        }
        vg.setSide(Side.valueOf((String)((String)props.get("side"))));
        return NodeWrapper.ControlWrapper.build((Object)vg, props, designer);
    }

    @BA.ShortName(value="TabPage")
    public static class TabWrapper
    extends AbsObjectWrapper<Tab> {
        public void Initialize() {
            this.setObject(new Tab());
        }

        public String getText() {
            return ((Tab)this.getObject()).getText();
        }

        public void setText(String s) {
            ((Tab)this.getObject()).setText(s);
        }

        public void setImage(Image Image2) {
            ImageView iv = new ImageView(Image2);
            ((Tab)this.getObject()).setGraphic((Node)iv);
        }

        public ImageViewWrapper.ImageWrapper getImage() {
            ImageViewWrapper.ImageWrapper iv = new ImageViewWrapper.ImageWrapper();
            if (((Tab)this.getObject()).getGraphic() instanceof ImageView) {
                iv.setObject(((ImageView)((Tab)this.getObject()).getGraphic()).getImage());
            }
            return iv;
        }

        public PaneWrapper.ConcretePaneWrapper getContent() {
            return (PaneWrapper.ConcretePaneWrapper)AbsObjectWrapper.ConvertToWrapper(new PaneWrapper.ConcretePaneWrapper(), ((Tab)this.getObject()).getContent());
        }

        public void setContent(Pane Pane2) {
            ((Tab)this.getObject()).setContent((Node)Pane2);
        }

        public Object getTag() {
            Object o = ((Tab)this.getObject()).getUserData();
            return o == null ? "" : o;
        }

        public void setTag(Object o) {
            ((Tab)this.getObject()).setUserData(o);
        }

        public String getId() {
            return ((Tab)this.getObject()).getId() == null ? "" : ((Tab)this.getObject()).getId();
        }

        public void setId(String s) {
            ((Tab)this.getObject()).setId(s);
        }

        public void setContextMenu(MenuItemWrapper.ContextMenuWrapper c) {
            ((Tab)this.getObject()).setContextMenu((ContextMenu)c.getObject());
        }

        public MenuItemWrapper.ContextMenuWrapper getContextMenu() {
            return (MenuItemWrapper.ContextMenuWrapper)AbsObjectWrapper.ConvertToWrapper(new MenuItemWrapper.ContextMenuWrapper(), ((Tab)this.getObject()).getContextMenu());
        }
    }
}

