/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.Form;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Control;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebView;
import javafx.util.Duration;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.decoration.Decorator;
import org.controlsfx.control.decoration.GraphicDecoration;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFontRegistry;

@BA.ShortName(value="ControlsUtils")
@BA.Version(value=1.5f)
public class ControlsUtils {
    private static boolean registeredFontAwesome;
    public static final int ICON_NONE = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_CONFIRM = 2;
    public static final int ICON_INFORMATION = 3;
    public static final int ICON_ERROR = 4;

    static void registerFontAwesome() {
        if (registeredFontAwesome) {
            return;
        }
        registeredFontAwesome = true;
        GlyphFontRegistry.register(new FontAwesome());
    }

    public void DisableCssWarnings() {
    }

    public void SetBackgroundColor(Node Node2, Paint Color2, double CornersRadius) {
        if (Node2 instanceof Region) {
            ((Region)Node2).setBackground(new Background(new BackgroundFill[]{new BackgroundFill(Color2, new CornerRadii(CornersRadius), Insets.EMPTY)}));
        } else {
            System.out.println("Unsupported type of node: " + Node2.getClass());
        }
    }

    public void SetBackgroundImage(Node Node2, Image Image2, boolean Tile) {
        if (Node2 instanceof Region) {
            BackgroundImage bi = Tile ? new BackgroundImage(Image2, null, null, null, null) : new BackgroundImage(Image2, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, new BackgroundSize(100.0, 100.0, true, true, true, false));
            ((Region)Node2).setBackground(new Background(new BackgroundImage[]{bi}));
        } else {
            System.out.println("Unsupported type of node: " + Node2.getClass());
        }
    }

    public void AddDecoration(Node Node2, Image Image2, String Position2, double OffsetX, double OffsetY) {
        Decorator.addDecoration(Node2, new GraphicDecoration((Node)new ImageView(Image2), this.getPosition(Position2), OffsetX, OffsetY));
    }

    @BA.Hide
    public Pos getPosition(String Position2) {
        return Enum.valueOf(Pos.class, Position2);
    }

    public void RemoveDecorations(Node Node2) {
        Decorator.removeAllDecorations(Node2);
    }

    public void ShowNotification(String Title, String Text, int Icon2) {
        this.ShowNotification2(Title, Text, Icon2, null);
    }

    public void ShowNotification2(String Title, String Text, int Icon2, Form Owner) {
        this.ShowNotification3(Title, Text, Icon2, Owner, "BOTTOM_RIGHT", 5000);
    }

    public void ShowNotification3(String Title, String Text, int Icon2, Form Owner, String Position2, int DurationMs) {
        Notifications n = Notifications.create().title(Title).text(Text);
        if (Owner != null) {
            n.owner(Owner.stage);
        }
        n.position(this.getPosition(Position2));
        n.hideAfter(Duration.millis((double)DurationMs));
        if (Icon2 == 1) {
            n.showWarning();
        } else if (Icon2 == 2) {
            n.showConfirm();
        } else if (Icon2 == 3) {
            n.showInformation();
        } else if (Icon2 == 4) {
            n.showError();
        } else {
            n.show();
        }
    }

    public static void SetSize(Node Node2, double Width, double Height) {
        if (Node2 instanceof Control) {
            ((Control)Node2).setPrefSize(Width > 0.0 ? Width : -1.0, Height > 0.0 ? Height : -1.0);
        } else if (Node2 instanceof Region) {
            ((Region)Node2).setPrefSize(Width > 0.0 ? Width : -1.0, Height > 0.0 ? Height : -1.0);
        } else if (Node2 instanceof ImageView) {
            ((ImageView)Node2).setFitWidth(Width);
            ((ImageView)Node2).setFitHeight(Height);
        } else if (Node2 instanceof Canvas) {
            ((Canvas)Node2).setWidth(Width);
            ((Canvas)Node2).setHeight(Height);
        } else if (Node2 instanceof WebView) {
            ((WebView)Node2).setPrefWidth(Width);
            ((WebView)Node2).setPrefHeight(Height);
        }
    }
}

