/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.DialogResponse;
import anywheresoftware.b4j.objects.Form;
import anywheresoftware.b4j.objects.FxBA;
import anywheresoftware.b4j.objects.ImageViewWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javafx.scene.Cursor;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;

@BA.Version(value=6.0f)
@BA.ShortName(value="JFX")
public class JFX {
    public static Colors Colors;
    private static boolean fontAwesomeLoaded;
    private static boolean materialIconsLoaded;
    public static final DialogResponse DialogResponse;
    public static Object MSGBOX_INFORMATION;
    public static Object MSGBOX_CONFIRMATION;
    public static Object MSGBOX_ERROR;
    public static Object MSGBOX_NONE;
    public static Object MSGBOX_WARNING;
    public static final ClipboardWrapper Clipboard;
    public static final Cursors Cursors;

    static {
        DialogResponse = null;
        MSGBOX_INFORMATION = Alert.AlertType.INFORMATION;
        MSGBOX_CONFIRMATION = Alert.AlertType.CONFIRMATION;
        MSGBOX_ERROR = Alert.AlertType.ERROR;
        MSGBOX_NONE = Alert.AlertType.NONE;
        MSGBOX_WARNING = Alert.AlertType.WARNING;
        Clipboard = null;
        Cursors = null;
    }

    public static FontWrapper CreateFont(String FamilyName, double Size, boolean Bold, boolean Italic) {
        FontWrapper fw = new FontWrapper();
        Font f = Font.font((String)FamilyName, (FontWeight)(Bold ? FontWeight.BOLD : FontWeight.NORMAL), (FontPosture)(Italic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)Size);
        fw.setObject(f);
        return fw;
    }

    @BA.Hide
    public static void loadFontAwesome() throws IOException {
        if (!fontAwesomeLoaded) {
            fontAwesomeLoaded = true;
            JFX.LoadFont(anywheresoftware.b4a.objects.streams.File.getDirAssets(), "FontAwesome.otf", 20.0);
        }
    }

    @BA.Hide
    public static void loadMaterialIcons() throws IOException {
        if (!materialIconsLoaded) {
            materialIconsLoaded = true;
            JFX.LoadFont(anywheresoftware.b4a.objects.streams.File.getDirAssets(), "MaterialIcons.ttf", 20.0);
        }
    }

    public static FontWrapper CreateFontAwesome(double Size) throws IOException {
        JFX.loadFontAwesome();
        return JFX.CreateFont("FontAwesome", Size, false, false);
    }

    public static FontWrapper CreateMaterialIcons(double Size) throws IOException {
        JFX.loadMaterialIcons();
        return JFX.CreateFont("Material Icons", Size, false, false);
    }

    public static anywheresoftware.b4a.objects.collections.List GetAllFontFamilies() {
        return (anywheresoftware.b4a.objects.collections.List)AbsObjectWrapper.ConvertToWrapper(new anywheresoftware.b4a.objects.collections.List(), Font.getFamilies());
    }

    public static ScreenWrapper getPrimaryScreen() {
        return (ScreenWrapper)AbsObjectWrapper.ConvertToWrapper(new ScreenWrapper(), Screen.getPrimary());
    }

    public static anywheresoftware.b4a.objects.collections.List getScreens() {
        anywheresoftware.b4a.objects.collections.List l = new anywheresoftware.b4a.objects.collections.List();
        l.Initialize();
        for (Screen s : Screen.getScreens()) {
            l.Add(s);
        }
        return l;
    }

    public void ShowExternalDocument(String DocUri) {
        FxBA.application.getHostServices().showDocument(DocUri);
    }

    public static FontWrapper DefaultFont(double Size) {
        return (FontWrapper)AbsObjectWrapper.ConvertToWrapper(new FontWrapper(), new Font(null, Size));
    }

    public static FontWrapper LoadFont(String Dir, String FileName, double Size) throws IOException {
        FontWrapper fw = new FontWrapper();
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream in = (InputStream)anywheresoftware.b4a.objects.streams.File.OpenInput(Dir, FileName).getObject();){
            Font f = Font.loadFont((InputStream)in, (double)Size);
            fw.setObject(f);
            return fw;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ImageViewWrapper.ImageWrapper LoadImage(String Dir, String FileName) throws IOException {
        ImageViewWrapper.ImageWrapper iw = new ImageViewWrapper.ImageWrapper();
        iw.Initialize(Dir, FileName);
        return iw;
    }

    public static ImageViewWrapper.ImageWrapper LoadImageSample(String Dir, String FileName, double Width, double Height) throws IOException {
        ImageViewWrapper.ImageWrapper iw = new ImageViewWrapper.ImageWrapper();
        iw.InitializeSample(Dir, FileName, Width, Height);
        return iw;
    }

    private static void setOwnerAndIcon(Dialog<?> d, Form f) {
        if (f != null) {
            d.initOwner((Window)f.stage);
            if (f.getIcon().IsInitialized()) {
                ((Stage)d.getDialogPane().getScene().getWindow()).getIcons().add((Object)((Image)f.getIcon().getObject()));
            }
        }
    }

    @BA.RaisesSynchronousEvents
    public static void Msgbox(Form Owner, String Message, String Title) {
        JFX.Msgbox2(Owner, Message, Title, "OK", "", "", Alert.AlertType.INFORMATION);
    }

    @BA.RaisesSynchronousEvents
    public static int Msgbox2(Form Owner, String Message, String Title, String Positive, String Cancel, String Negative, Object Style2) {
        Alert alrt = new Alert((Alert.AlertType)Style2);
        JFX.setOwnerAndIcon(alrt, Owner);
        String[] texts = new String[]{Positive, Cancel, Negative};
        ButtonBar.ButtonData[] datas = new ButtonBar.ButtonData[]{ButtonBar.ButtonData.YES, ButtonBar.ButtonData.CANCEL_CLOSE, ButtonBar.ButtonData.NO};
        HashMap<ButtonBar.ButtonData, Integer> res = new HashMap<ButtonBar.ButtonData, Integer>();
        res.put(ButtonBar.ButtonData.YES, -1);
        res.put(ButtonBar.ButtonData.CANCEL_CLOSE, -3);
        res.put(ButtonBar.ButtonData.NO, -2);
        alrt.getButtonTypes().clear();
        int i = 0;
        while (i < texts.length) {
            if (texts[i].length() > 0) {
                alrt.getButtonTypes().add((Object)new ButtonType(texts[i], datas[i]));
            }
            ++i;
        }
        alrt.setTitle(Title);
        alrt.setContentText(Message);
        alrt.setHeaderText("");
        Optional bt = alrt.showAndWait();
        if (!bt.isPresent()) {
            return -3;
        }
        return (Integer)res.get(((ButtonType)bt.get()).getButtonData());
    }

    @BA.RaisesSynchronousEvents
    public static int InputList(Form Owner, anywheresoftware.b4a.objects.collections.List Items, String Message, String Title, int DefaultItem) {
        ChoiceDialog cd = DefaultItem > -1 ? new ChoiceDialog(Items.Get(DefaultItem), (Collection)Items.getObject()) : new ChoiceDialog(null, (Collection)Items.getObject());
        JFX.setOwnerAndIcon(cd, Owner);
        cd.setTitle(Title);
        cd.setHeaderText(Message);
        Optional result = cd.showAndWait();
        if (result.isPresent() && result.get() != null) {
            return Items.IndexOf(result.get());
        }
        return -3;
    }

    public static class ClipboardWrapper {
        public static void SetString(String Text) {
            HashMap<DataFormat, String> m = new HashMap<DataFormat, String>();
            m.put(DataFormat.PLAIN_TEXT, Text);
            javafx.scene.input.Clipboard.getSystemClipboard().setContent(m);
        }

        public static boolean HasString() {
            return javafx.scene.input.Clipboard.getSystemClipboard().hasString();
        }

        public static String GetString() {
            String s = javafx.scene.input.Clipboard.getSystemClipboard().getString();
            return s == null ? "" : s;
        }

        public static void SetImage(Image Img) {
            HashMap<DataFormat, Image> m = new HashMap<DataFormat, Image>();
            m.put(DataFormat.IMAGE, Img);
            javafx.scene.input.Clipboard.getSystemClipboard().setContent(m);
        }

        public static boolean HasImage() {
            return javafx.scene.input.Clipboard.getSystemClipboard().hasImage();
        }

        public static ImageViewWrapper.ImageWrapper GetImage() {
            ImageViewWrapper.ImageWrapper iw = new ImageViewWrapper.ImageWrapper();
            iw.setObject(javafx.scene.input.Clipboard.getSystemClipboard().getImage());
            return iw;
        }

        public static void SetFiles(anywheresoftware.b4a.objects.collections.List Files) {
            HashMap m = new HashMap();
            ArrayList<File> f = new ArrayList<File>();
            for (Object s : (List)Files.getObject()) {
                f.add(new File(String.valueOf(s)));
            }
            m.put(DataFormat.FILES, f);
            javafx.scene.input.Clipboard.getSystemClipboard().setContent(m);
        }

        public static boolean HasFiles() {
            return javafx.scene.input.Clipboard.getSystemClipboard().hasFiles();
        }

        public static anywheresoftware.b4a.objects.collections.List GetFiles() {
            anywheresoftware.b4a.objects.collections.List iw = new anywheresoftware.b4a.objects.collections.List();
            iw.Initialize();
            for (File f : javafx.scene.input.Clipboard.getSystemClipboard().getFiles()) {
                iw.Add(f.toString());
            }
            return iw;
        }
    }

    public static class Colors {
        public static final Paint Black = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-16777216);
        public static final Paint DarkGray = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-12303292);
        public static final Paint Gray = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-7829368);
        public static final Paint LightGray = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-3355444);
        public static final Paint White = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-1);
        public static final Paint Red = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-65536);
        public static final Paint Green = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-16711936);
        public static final Paint Blue = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-16776961);
        public static final Paint Yellow = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-256);
        public static final Paint Cyan = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-16711681);
        public static final Paint Magenta = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(-65281);
        public static final Paint Transparent = anywheresoftware.b4j.objects.JFX$Colors.From32Bit(0);

        public static Color From32Bit(int Color2) {
            double a = (double)((Color2 & 0xFF000000) >>> 24) / 255.0;
            double r = (double)((Color2 & 0xFF0000) >>> 16) / 255.0;
            double g = (double)((Color2 & 0xFF00) >>> 8) / 255.0;
            double b = (double)(Color2 & 0xFF) / 255.0;
            return new Color(r, g, b, a);
        }

        public static int To32Bit(Paint Color2) {
            int a;
            if (!(Color2 instanceof Color)) {
                return 0;
            }
            Color c = (Color)Color2;
            int r = (int)Math.round(c.getRed() * 255.0);
            int g = (int)Math.round(c.getGreen() * 255.0);
            int b = (int)Math.round(c.getBlue() * 255.0);
            int i = a = (int)Math.round(c.getOpacity() * 255.0);
            i <<= 8;
            i |= r;
            i <<= 8;
            i |= g;
            i <<= 8;
            return i |= b;
        }

        public static Color RGB(int R, int G, int B) {
            return Color.rgb((int)R, (int)G, (int)B);
        }

        public static Color ARGB(int Alpha, int R, int G, int B) {
            return Color.rgb((int)R, (int)G, (int)B, (double)((double)Alpha / 255.0));
        }
    }

    public static class Cursors {
        public static Cursor DEFAULT = Cursor.DEFAULT;
        public static final Cursor CROSSHAIR = Cursor.CROSSHAIR;
        public static final Cursor TEXT = Cursor.TEXT;
        public static final Cursor WAIT = Cursor.WAIT;
        public static final Cursor OPEN_HAND = Cursor.OPEN_HAND;
        public static final Cursor CLOSED_HAND = Cursor.CLOSED_HAND;
        public static final Cursor HAND = Cursor.HAND;
        public static final Cursor MOVE = Cursor.MOVE;
        public static final Cursor DISAPPEAR = Cursor.DISAPPEAR;
        public static final Cursor NONE = Cursor.NONE;
    }

    @BA.ShortName(value="Font")
    public static class FontWrapper
    extends AbsObjectWrapper<Font> {
        public double getSize() {
            return ((Font)this.getObject()).getSize();
        }

        public String getFamilyName() {
            return ((Font)this.getObject()).getFamily();
        }
    }

    @BA.ShortName(value="Paint")
    public static class PaintWrapper
    extends AbsObjectWrapper<Paint> {
    }

    @BA.ShortName(value="Screen")
    public static class ScreenWrapper
    extends AbsObjectWrapper<Screen> {
        public double getMinX() {
            return ((Screen)this.getObject()).getVisualBounds().getMinX();
        }

        public double getMinY() {
            return ((Screen)this.getObject()).getVisualBounds().getMinY();
        }

        public double getMaxX() {
            return ((Screen)this.getObject()).getVisualBounds().getMaxX();
        }

        public double getMaxY() {
            return ((Screen)this.getObject()).getVisualBounds().getMaxY();
        }
    }
}

