/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.ImageViewWrapper;
import anywheresoftware.b4j.objects.NodeWrapper;
import anywheresoftware.b4j.objects.collections.JSONParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.AnchorPane;

@BA.Hide
public class MenuItemWrapper<T extends MenuItem>
extends AbsObjectWrapper<T> {
    protected BA ba;

    public void Initialize(BA ba, String Text, String EventName) {
        this.innerInitialize(ba, EventName.toLowerCase(BA.cul), false);
        ((MenuItem)this.getObject()).setText(Text);
    }

    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        this.ba = ba;
        if (ba == null) {
            return;
        }
        if (ba.subExists(String.valueOf(eventName) + "_action")) {
            ((MenuItem)this.getObject()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    ba.raiseEventFromUI(MenuItemWrapper.this.getObject(), String.valueOf(eventName) + "_action", new Object[0]);
                    arg0.consume();
                }
            });
        }
    }

    public String getText() {
        return ((MenuItem)this.getObject()).getText();
    }

    public void setText(String s) {
        ((MenuItem)this.getObject()).setText(s);
    }

    public Object getTag() {
        return ((MenuItem)this.getObject()).getUserData();
    }

    public void setTag(Object o) {
        ((MenuItem)this.getObject()).setUserData(o);
    }

    public boolean getEnabled() {
        return !((MenuItem)this.getObject()).isDisable();
    }

    public void setEnabled(boolean b) {
        ((MenuItem)this.getObject()).setDisable(!b);
    }

    public boolean getVisible() {
        return ((MenuItem)this.getObject()).isVisible();
    }

    public void setVisible(boolean v) {
        ((MenuItem)this.getObject()).setVisible(v);
    }

    public void setImage(Image Image2) {
        ImageView iv = new ImageView(Image2);
        ((MenuItem)this.getObject()).setGraphic((Node)iv);
    }

    public ImageViewWrapper.ImageWrapper getImage() {
        ImageViewWrapper.ImageWrapper iv = new ImageViewWrapper.ImageWrapper();
        if (((MenuItem)this.getObject()).getGraphic() instanceof ImageView) {
            iv.setObject(((ImageView)((MenuItem)this.getObject()).getGraphic()).getImage());
        }
        return iv;
    }

    @BA.ShortName(value="CheckMenuItem")
    public static class CheckMenuItemWrapper
    extends MenuItemWrapper<CheckMenuItem> {
        @Override
        @BA.Hide
        public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new CheckMenuItem());
            }
            super.innerInitialize(ba, eventName, true);
            if (ba == null) {
                return;
            }
            if (ba.subExists(String.valueOf(eventName) + "_selectedchange")) {
                ((CheckMenuItem)this.getObject()).selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                        ba.raiseEventFromUI(CheckMenuItemWrapper.this.getObject(), String.valueOf(eventName) + "_selectedchange", (boolean)arg2);
                    }
                });
            }
        }

        public boolean getSelected() {
            return ((CheckMenuItem)this.getObject()).isSelected();
        }

        public void setSelected(boolean b) {
            ((CheckMenuItem)this.getObject()).setSelected(b);
        }
    }

    @BA.ShortName(value="MenuItem")
    public static class ConcreteMenuItemWrapper
    extends MenuItemWrapper<MenuItem> {
        @Override
        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new MenuItem());
            }
            super.innerInitialize(ba, eventName, true);
        }
    }

    @BA.ShortName(value="ContextMenu")
    public static class ContextMenuWrapper
    extends AbsObjectWrapper<ContextMenu> {
        public void Initialize(BA ba, String EventName) {
            this.innerInitialize(ba, EventName.toLowerCase(BA.cul), false);
        }

        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new ContextMenu());
            }
        }

        public anywheresoftware.b4a.objects.collections.List getMenuItems() {
            return (anywheresoftware.b4a.objects.collections.List)AbsObjectWrapper.ConvertToWrapper(new anywheresoftware.b4a.objects.collections.List(), ((ContextMenu)this.getObject()).getItems());
        }
    }

    @BA.ShortName(value="MenuBar")
    public static class MenuBarWrapper
    extends NodeWrapper.ControlWrapper<MenuBar> {
        @Override
        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new MenuBar());
            }
            super.innerInitialize(ba, eventName, true);
            AnchorPane.setLeftAnchor((Node)((Node)this.getObject()), (Double)0.0);
            AnchorPane.setRightAnchor((Node)((Node)this.getObject()), (Double)0.0);
        }

        public anywheresoftware.b4a.objects.collections.List getMenus() {
            return (anywheresoftware.b4a.objects.collections.List)AbsObjectWrapper.ConvertToWrapper(new anywheresoftware.b4a.objects.collections.List(), ((MenuBar)this.getObject()).getMenus());
        }

        @BA.Hide
        public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
            MenuBar vg = (MenuBar)prev;
            if (vg == null) {
                vg = NodeWrapper.buildNativeView(MenuBar.class, props, designer);
            }
            vg.getMenus().setAll(MenuBarWrapper.parseMenusJson((BA)props.get("ba"), (String)props.get("menuItems"), (String)props.get("eventName")));
            vg = (MenuBar)NodeWrapper.ControlWrapper.build((Object)vg, props, designer);
            return vg;
        }

        @BA.Hide
        public static ArrayList<Menu> parseMenusJson(BA ba, String json, String defaultEventName) {
            String menuItems = json.trim();
            if (menuItems.length() > 0) {
                anywheresoftware.b4a.objects.collections.List items = null;
                try {
                    JSONParser parser = new JSONParser();
                    parser.Initialize(menuItems);
                    items = parser.NextArray();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new ArrayList<Menu>(Arrays.asList(new Menu("Error parsing JSON string")));
                }
                return (ArrayList)MenuBarWrapper.createMenus(ba, items, defaultEventName).getObject();
            }
            return new ArrayList<Menu>();
        }

        @BA.Hide
        public static anywheresoftware.b4a.objects.collections.List createMenus(BA ba, anywheresoftware.b4a.objects.collections.List items, String defaultEventName) {
            anywheresoftware.b4a.objects.collections.List menus = new anywheresoftware.b4a.objects.collections.List();
            menus.Initialize();
            for (Object o : (List)items.getObject()) {
                menus.Add(MenuBarWrapper.createMenuItem(ba, o, defaultEventName));
            }
            return menus;
        }

        private static MenuItem createMenuItem(BA ba, Object item, String defaultEventName) {
            MenuItemWrapper mmm;
            ArrayList children;
            String imageUri;
            if (item instanceof String) {
                if (((String)item).equals("-")) {
                    return new SeparatorMenuItem();
                }
                ConcreteMenuItemWrapper miw = new ConcreteMenuItemWrapper();
                miw.Initialize(ba, (String)item, defaultEventName);
                return (MenuItem)miw.getObject();
            }
            Map map = (Map)item;
            String text = (String)map.get("Text");
            String eventName = (String)map.get("EventName");
            String tag = (String)map.get("Tag");
            Boolean enabled = (Boolean)map.get("Enabled");
            if (eventName == null) {
                eventName = defaultEventName;
            }
            String image = (String)map.get("Image");
            Image img = null;
            if (image != null && (imageUri = NodeWrapper.getImageUri(image, ba == null)) != null) {
                img = new Image(imageUri);
            }
            if ((children = (ArrayList)map.get("Children")) != null) {
                MenuWrapper mw = new MenuWrapper();
                mw.Initialize(ba, text, eventName);
                anywheresoftware.b4a.objects.collections.List items = mw.getMenuItems();
                for (Object o : children) {
                    items.Add(MenuBarWrapper.createMenuItem(ba, o, defaultEventName));
                }
                mw.setTag(tag);
                if (img != null) {
                    ImageView iv = new ImageView();
                    iv.setImage(img);
                    ((Menu)mw.getObject()).setGraphic((Node)iv);
                }
                return (MenuItem)mw.getObject();
            }
            Boolean checked = (Boolean)map.get("Selected");
            if (checked != null) {
                CheckMenuItemWrapper cmi = new CheckMenuItemWrapper();
                cmi.Initialize(ba, text, eventName);
                cmi.setSelected(checked);
                mmm = cmi;
            } else {
                ConcreteMenuItemWrapper miw2 = new ConcreteMenuItemWrapper();
                miw2.Initialize(ba, text, eventName);
                mmm = miw2;
            }
            if (enabled != null) {
                mmm.setEnabled(enabled);
            }
            if (img != null) {
                mmm.setImage(img);
            }
            mmm.setTag(tag);
            Map shortcut = (Map)map.get("Shortcut");
            if (shortcut != null) {
                String keyCode = (String)shortcut.get("Key");
                if (Character.isDigit(keyCode.charAt(0))) {
                    keyCode = "DIGIT" + keyCode.charAt(0);
                }
                KeyCode kc = KeyCode.valueOf((String)keyCode.toUpperCase(BA.cul));
                Object modifier = shortcut.get("Modifier");
                KeyCodeCombination combine = null;
                if (modifier instanceof String) {
                    combine = new KeyCodeCombination(kc, new KeyCombination.Modifier[]{MenuBarWrapper.stringToModifier((String)modifier)});
                } else if (modifier instanceof List) {
                    List modifiers = (List)modifier;
                    KeyCombination.Modifier[] modArray = new KeyCombination.Modifier[modifiers.size()];
                    int i = 0;
                    while (i < modifiers.size()) {
                        modArray[i] = MenuBarWrapper.stringToModifier((String)modifiers.get(i));
                        ++i;
                    }
                    combine = new KeyCodeCombination(kc, modArray);
                } else {
                    combine = new KeyCodeCombination(kc, new KeyCombination.Modifier[0]);
                }
                ((MenuItem)mmm.getObject()).setAccelerator((KeyCombination)combine);
            }
            return (MenuItem)mmm.getObject();
        }

        private static KeyCombination.Modifier stringToModifier(String s) {
            if ((s = s.toUpperCase(BA.cul)).equals("ALT")) {
                return KeyCombination.ALT_DOWN;
            }
            if (s.equals("CONTROL")) {
                return KeyCombination.CONTROL_DOWN;
            }
            if (s.equals("SHIFT")) {
                return KeyCombination.SHIFT_DOWN;
            }
            if (s.equals("SHORTCUT")) {
                return KeyCombination.SHORTCUT_DOWN;
            }
            BA.LogError("Invalid modifier: " + s);
            return null;
        }
    }

    @BA.ShortName(value="Menu")
    public static class MenuWrapper
    extends AbsObjectWrapper<Menu> {
        public void Initialize(BA ba, String Text, String EventName) {
            this.setObject(new Menu());
            ((Menu)this.getObject()).setText(Text);
            this.innerInitialize(ba, EventName.toLowerCase(BA.cul), true);
        }

        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
        }

        public anywheresoftware.b4a.objects.collections.List getMenuItems() {
            return (anywheresoftware.b4a.objects.collections.List)AbsObjectWrapper.ConvertToWrapper(new anywheresoftware.b4a.objects.collections.List(), ((Menu)this.getObject()).getItems());
        }

        public String getText() {
            return ((Menu)this.getObject()).getText();
        }

        public void setText(String s) {
            ((Menu)this.getObject()).setText(s);
        }

        public Object getTag() {
            return ((Menu)this.getObject()).getUserData();
        }

        public void setTag(Object o) {
            ((Menu)this.getObject()).setUserData(o);
        }
    }
}

