/*
 * Decompiled with CFR 0.152.
 */
package b4j.packager;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4a.keywords.Regex;
import anywheresoftware.b4a.objects.Timer;
import anywheresoftware.b4a.objects.collections.List;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.objects.streams.File;
import anywheresoftware.b4j.objects.ButtonWrapper;
import anywheresoftware.b4j.objects.ControlsUtils;
import anywheresoftware.b4j.objects.FileChooserWrapper;
import anywheresoftware.b4j.objects.Form;
import anywheresoftware.b4j.objects.FxBA;
import anywheresoftware.b4j.objects.JFX;
import anywheresoftware.b4j.objects.ProgressIndicatorWrapper;
import anywheresoftware.b4j.objects.Shell;
import anywheresoftware.b4j.objects.TextInputControlWrapper;
import flm.b4a.archiver.ArchiverForB4A;
import javafx.application.Application;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class main
extends Application {
    public static main mostCurrent = new main();
    public static BA ba = new FxBA("b4j.packager", "b4j.packager.main", null);
    public static Common __c;
    public static JFX _fx;
    public static Form _mainform;
    public static ButtonWrapper _btnbuild;
    public static ButtonWrapper _btniconbrowse;
    public static ButtonWrapper _btnjarbrowse;
    public static TextInputControlWrapper.TextFieldWrapper _txtjar;
    public static TextInputControlWrapper.TextFieldWrapper _txticon;
    public static TextInputControlWrapper.TextFieldWrapper _txtname;
    public static TextInputControlWrapper.TextFieldWrapper _txttitle;
    public static FileChooserWrapper _filechooser;
    public static String _iconextension;
    public static String _packageextension;
    public static ControlsUtils _cutils;
    public static TextInputControlWrapper.TextFieldWrapper _txtversion;
    public static ButtonWrapper _btnpackagerbrowse;
    public static TextInputControlWrapper.TextFieldWrapper _txtpackager;
    public static ProgressIndicatorWrapper.ProgressBarWrapper _progressbar1;
    public static Timer _timer1;
    public static String _filename;
    public static Shell _shl;
    public static boolean _windows;
    public static String _workingfolder;
    public static String _version;
    private static boolean processGlobalsRun;

    public static Class<?> getObject() {
        return main.class;
    }

    public static void main(String[] stringArray) {
        main.launch((String[])stringArray);
    }

    public void start(Stage stage) {
        try {
            System.setProperty("prism.lcdtext", "false");
            FxBA.application = this;
            Common.setDensity(Screen.getPrimary().getDpi());
            Common.LogDebug("Program started.");
            main.initializeProcessGlobals();
            Form form = new Form();
            form.initWithStage(ba, stage, 600.0, 350.0);
            ba.raiseEvent(null, "appstart", form, this.getParameters().getRaw().toArray(new String[0]));
        }
        catch (Throwable throwable) {
            BA.printException(throwable, true);
            System.exit(1);
        }
    }

    public static String _appstart(Form form, String[] stringArray) throws Exception {
        String string = "";
        String string2 = "";
        Map map = null;
        string = Common.GetSystemProperty("os.name", "").toLowerCase();
        if (string.contains("win")) {
            _iconextension = "ico";
            _packageextension = "exe";
            _windows = true;
            _workingfolder = File.Combine(Common.GetEnvironmentVariable("AppData", ""), "B4JPackager");
            File.MakeDir(_workingfolder, "");
        } else if (string.contains("mac")) {
            _iconextension = "icns";
            _packageextension = "dmg";
            _windows = false;
            _workingfolder = Common.File.getDirApp();
        } else {
            _cutils.ShowNotification2("", "Platform not supported", 4, _mainform);
        }
        _mainform = form;
        _mainform.getRootPane().LoadLayout(ba, "1");
        _mainform.setTitle(_mainform.getTitle() + " " + _version);
        _filechooser.Initialize();
        _mainform.Show();
        string2 = File.Combine(Common.GetSystemProperty("java.home", ""), "../bin/javapackager.exe");
        if (File.Exists(string2, "")) {
            _txtpackager.setText(string2);
        }
        if (File.Exists(_workingfolder, "settings.txt")) {
            map = new Map();
            map = File.ReadMap(_workingfolder, "settings.txt");
            _txtjar.setText(BA.ObjectToString(map.Get("jar")));
            _txticon.setText(BA.ObjectToString(map.Get("icon")));
            _txtname.setText(BA.ObjectToString(map.Get("name")));
            _txttitle.setText(BA.ObjectToString(map.Get("title")));
            _txtversion.setText(BA.ObjectToString(map.Get("version")));
            _txtpackager.setText(BA.ObjectToString(map.Get("packager")));
        }
        _timer1.Initialize(ba, "timer1", 1000L);
        return "";
    }

    public static String _btnbuild_action() throws Exception {
        ArchiverForB4A archiverForB4A = null;
        String string = "";
        Regex.MatcherWrapper matcherWrapper = null;
        String string2 = "";
        List list = null;
        if (_txtjar.getText().equals("")) {
            _cutils.ShowNotification2("", "Please set the jar file", 4, _mainform);
            return "";
        }
        if (_txtpackager.getText().equals("")) {
            _cutils.ShowNotification2("", "Please set the path to javapackager", 4, _mainform);
            return "";
        }
        try {
            archiverForB4A = new ArchiverForB4A();
            if (archiverForB4A.UnZipFiles(ba, _txtjar.getText(), "", _workingfolder, new String[]{"META-INF/MANIFEST.MF"}, "") != 1) {
                _cutils.ShowNotification2("", "Manifest file not found. Make sure that the jar file was compiled in release mode.", 4, _mainform);
                return "";
            }
            string = File.ReadString(_workingfolder, "META-INF/MANIFEST.MF");
            matcherWrapper = new Regex.MatcherWrapper();
            matcherWrapper = Regex.Matcher2("JavaFX-Application-Class:\\s*(.*)$", 8, string);
            string2 = "";
            if (!matcherWrapper.Find()) {
                _cutils.ShowNotification2("", "Error parsing manifest file.", 4, _mainform);
                return "";
            }
            string2 = matcherWrapper.Group(1);
            Common.Log("App identifier: " + string2);
            _shl = new Shell();
            list = new List();
            list.Initialize();
            Object[] objectArray = new Object[22];
            objectArray[0] = "-deploy";
            objectArray[1] = "-verbose";
            objectArray[2] = "-srcdir";
            objectArray[3] = File.GetFileParent(_txtjar.getText());
            objectArray[4] = "-srcfiles";
            objectArray[5] = File.GetName(_txtjar.getText());
            objectArray[6] = "-Bmainjar=" + File.GetName(_txtjar.getText());
            objectArray[7] = "-native";
            objectArray[8] = _packageextension;
            objectArray[9] = "-BsystemWide=true";
            objectArray[10] = "-title";
            objectArray[11] = _txttitle.getText();
            objectArray[12] = "-name";
            objectArray[13] = _txtname.getText();
            objectArray[14] = "-outdir";
            objectArray[15] = _workingfolder;
            objectArray[16] = "-outfile";
            objectArray[17] = "1.exe";
            objectArray[18] = "-BappVersion=" + _txtversion.getText();
            objectArray[19] = "-appclass";
            objectArray[20] = string2;
            objectArray[21] = "-Bidentifier=" + string2;
            list.AddAll(Common.ArrayToList(objectArray));
            if (_windows) {
                list.Add("-Bruntime=" + Common.GetSystemProperty("java.home", ""));
            }
            if (!_txticon.getText().equals("")) {
                list.Add("-Bicon=" + Common.SmartStringFormatter("", _txticon.getText()) + "");
            }
            _filename = File.Combine(_workingfolder, "bundles/" + _txtname.getText() + "-" + _txtversion.getText() + "." + _packageextension);
            File.Delete(_filename, "");
            _shl.InitializeDoNotHandleQuotes("shl", _txtpackager.getText(), list);
            _shl.RunWithOutputEvents(ba, -1L);
            if (_windows) {
                _progressbar1.setProgress(0.0);
                _timer1.setEnabled(true);
            } else {
                _progressbar1.setProgress(-1.0);
            }
            _btnbuild.setEnabled(false);
            _progressbar1.setVisible(true);
        }
        catch (Exception exception) {
            ba.setLastException(exception);
            Common.Log(BA.ObjectToString(Common.LastException(ba)));
            _cutils.ShowNotification2("", "Error: " + Common.LastException(ba).getMessage(), 4, _mainform);
        }
        return "";
    }

    public static String _btniconbrowse_action() throws Exception {
        _filechooser.SetExtensionFilter("Icon", Common.ArrayToList(new Object[]{"*." + _iconextension}));
        main._handlebrowse(_txticon);
        return "";
    }

    public static String _btnjarbrowse_action() throws Exception {
        _filechooser.SetExtensionFilter("Jar", Common.ArrayToList(new Object[]{"*.jar"}));
        main._handlebrowse(_txtjar);
        return "";
    }

    public static String _btnpackagerbrowse_action() throws Exception {
        if (_txtjar.getText().equals("")) {
            _filechooser.setInitialDirectory(File.GetFileParent(Common.GetSystemProperty("java.home", "")));
        }
        _filechooser.SetExtensionFilter("javapackager", Common.ArrayToList(new Object[]{"javapackager.*"}));
        main._handlebrowse(_txtpackager);
        return "";
    }

    public static String _handlebrowse(TextInputControlWrapper.TextFieldWrapper textFieldWrapper) throws Exception {
        String string = "";
        if (!textFieldWrapper.getText().equals("")) {
            if (!File.GetFileParent(textFieldWrapper.getText()).equals("")) {
                _filechooser.setInitialDirectory(File.GetFileParent(textFieldWrapper.getText()));
            }
        }
        if (!(string = _filechooser.ShowOpen(_mainform)).equals("")) {
            textFieldWrapper.setText(string);
        }
        return "";
    }

    public static String _mainform_closed() throws Exception {
        File.WriteMap(_workingfolder, "settings.txt", Common.createMap(new Object[]{"jar", _txtjar.getText(), "icon", _txticon.getText(), "name", _txtname.getText(), "title", _txttitle.getText(), "version", _txtversion.getText(), "packager", _txtpackager.getText()}));
        return "";
    }

    public static void initializeProcessGlobals() {
        if (!processGlobalsRun) {
            processGlobalsRun = true;
            try {
                main._process_globals();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static String _process_globals() throws Exception {
        _fx = new JFX();
        _mainform = new Form();
        _btnbuild = new ButtonWrapper();
        _btniconbrowse = new ButtonWrapper();
        _btnjarbrowse = new ButtonWrapper();
        _txtjar = new TextInputControlWrapper.TextFieldWrapper();
        _txticon = new TextInputControlWrapper.TextFieldWrapper();
        _txtname = new TextInputControlWrapper.TextFieldWrapper();
        _txttitle = new TextInputControlWrapper.TextFieldWrapper();
        _filechooser = new FileChooserWrapper();
        _iconextension = "";
        _packageextension = "";
        _cutils = new ControlsUtils();
        _txtversion = new TextInputControlWrapper.TextFieldWrapper();
        _btnpackagerbrowse = new ButtonWrapper();
        _txtpackager = new TextInputControlWrapper.TextFieldWrapper();
        _progressbar1 = new ProgressIndicatorWrapper.ProgressBarWrapper();
        _timer1 = new Timer();
        _filename = "";
        _shl = new Shell();
        _windows = false;
        _workingfolder = "";
        _version = "1.50";
        return "";
    }

    public static String _shl_processcompleted(boolean bl, int n, String string, String string2) throws Exception {
        Common.Log("Success: " + BA.ObjectToString(bl));
        Common.Log("ExitCode: " + BA.NumberToString(n));
        _timer1.setEnabled(false);
        _btnbuild.setEnabled(true);
        _progressbar1.setProgress(1.0);
        if (n != 0 || !bl) {
            _cutils.ShowNotification2("", "Error: " + string2, 4, _mainform);
        } else {
            _fx.ShowExternalDocument(File.GetUri(File.GetFileParent(_filename), ""));
            _cutils.ShowNotification2("", "Package built successfully.", 3, _mainform);
        }
        return "";
    }

    public static String _shl_stderr(byte[] byArray, int n) throws Exception {
        Common.LogError(Common.BytesToString(byArray, 0, n, "utf8"));
        return "";
    }

    public static String _shl_stdout(byte[] byArray, int n) throws Exception {
        Common.Log(Common.BytesToString(byArray, 0, n, "utf8"));
        return "";
    }

    public static String _timer1_tick() throws Exception {
        if (File.Exists(_filename, "")) {
            _progressbar1.setProgress((double)File.Size(_filename, "") / 5.0E7);
        }
        return "";
    }

    static {
        ba.loadHtSubs(main.class);
        if (ba.getClass().getName().endsWith("ShellBA")) {
            ba.raiseEvent2(null, true, "SHELL", false, new Object[0]);
            ba.raiseEvent2(null, true, "CREATE", true, "b4j.packager.main", ba);
        }
        __c = null;
        _fx = null;
        _mainform = null;
        _btnbuild = null;
        _btniconbrowse = null;
        _btnjarbrowse = null;
        _txtjar = null;
        _txticon = null;
        _txtname = null;
        _txttitle = null;
        _filechooser = null;
        _iconextension = "";
        _packageextension = "";
        _cutils = null;
        _txtversion = null;
        _btnpackagerbrowse = null;
        _txtpackager = null;
        _progressbar1 = null;
        _timer1 = null;
        _filename = "";
        _shl = null;
        _windows = false;
        _workingfolder = "";
        _version = "";
    }
}

