﻿B4J=true
Group=Default Group
ModulesStructureVersion=1
Type=Class
Version=9.3
@EndOfDesignText@
Sub Class_Globals
	Public const Charset As String = "UTF-32LE"
	Private Emojies As Map
	Private const NO_BITMAP As B4XBitmap
	Private xui As XUI
	Private bc As ByteConverter
End Sub

Public Sub Initialize
	bc.LittleEndian = True
	Dim ser As B4XSerializator
'	CreateEmojies
	Emojies = ser.ConvertBytesToObject(File.ReadBytes(File.DirAssets, "emojies.dat"))
End Sub

Public Sub ProcessText (text As String, views As Map, SizePx As Int, VerticalOffset As Int) As String
	Dim b() As Byte = text.GetBytes(Charset)
	Dim bb As B4XBytesBuilder
	bb.Initialize
	Dim i As Int = 0
	Do While i < b.Length - 1
		Dim key As String = BytesToString(b, i, 4, Charset)
		If Emojies.ContainsKey(key) Then
			Dim TempKey As String = key
			Dim t As Int = i + 4
			Do While True
				TempKey = TempKey & BytesToString(b, t, 4, Charset)
				If Emojies.ContainsKey(TempKey) Then
					t = t + 4
					If t >= b.Length Then
						key = TempKey
						i = t
						Exit
					End If
				Else
					t = t - 4
					If t > i Then
						key = BytesToString(b, i, t - i + 4, Charset)
						i = t
					End If
					Exit
				End If
			Loop
			Dim bmp As B4XBitmap = GetBitmapFromMap(key)
			If bmp.IsInitialized = False Then
				bb.Append(key.GetBytes(Charset))
			Else
				Dim iv As ImageView
				iv.Initialize("")
				Dim xiv As B4XView = iv
				xiv.SetLayoutAnimated(0, 0, 0, SizePx, SizePx)
				xiv.SetBitmap(bmp)
				Dim id As String = "iv" & views.Size
				views.Put(id, iv)
				Dim s As String = $"[View=${id} Vertical=${VerticalOffset}/]"$
				bb.Append(s.GetBytes(Charset))
			End If
		Else
			bb.Append2(b, i, 4)
		End If
		i = i + 4
	Loop
	Return BytesToString(bb.ToArray, 0, bb.Length, Charset)
End Sub

Private Sub GetBitmapFromMap(key As String) As B4XBitmap
	Dim b() As Byte = Emojies.Get(key)
	If b.Length = 0 Then Return NO_BITMAP
	Dim in As InputStream
	in.InitializeFromBytesArray(b, 0, b.Length)
	Dim bmp As Image
	bmp.Initialize2(in)
	in.Close
	Return bmp
End Sub

Private Sub CreateEmojies 'ignore
	Log("Don't forget to copy the output to the shared files folder")
	Dim m As Map = CreateEmojiesMap("C:\Users\H\Downloads\projects\emojitwo-master\png\64")
	Dim ser As B4XSerializator
	Dim data() As Byte = ser.ConvertObjectToBytes(m)
	File.WriteBytes(File.DirApp, "emojies.dat", data)
End Sub

Private Sub CreateEmojiesMap (ImagesFolder As String) As Map
	Dim m As Map
	m.Initialize
	Dim bb As B4XBytesBuilder
	bb.Initialize
	
	For Each f As String In File.ListFiles(ImagesFolder)
		Dim CodePoints() As String = Regex.Split("\-", f.SubString2(0, f.Length - 4))
		bb.Remove(0, bb.Length)
		For i = 0 To CodePoints.Length - 1
			Dim cp As String = CodePoints(i)
			Dim n As Int = Bit.ParseInt(cp, 16)
			bb.Append(bc.IntsToBytes(Array As Int(n)))
			If i < CodePoints.Length - 1 Then
				Dim subkey As String = BytesToString(bb.ToArray, 0, bb.Length, Charset)
				If m.ContainsKey(subkey) = False Then m.Put(subkey, Array As Byte())
			End If
		Next
		Dim key As String = BytesToString(bb.ToArray, 0, bb.Length, Charset)
		m.Put(key, File.ReadBytes(ImagesFolder, f))
	Next
	Return m
End Sub


Private Sub BytesToInt (Bytes() As Byte, StartIndex As Int) As Int 'ignore
	Dim cp As Int
	For i = 0 To 3
		cp = Bit.Or(cp, Bit.ShiftLeft(Bit.And(0xff, Bytes(i + StartIndex)), 8 * i))
	Next
	Return cp
End Sub

Public Sub CodePointsToString (CodePoints() As Int) As String
	Dim b() As Byte = bc.IntsToBytes(CodePoints)
	Return BytesToString(b, 0, b.Length, Charset)
End Sub

