/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.randomaccessfile;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.randomaccessfile.RandomAccessFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

@BA.ShortName(value="B4XSerializator")
public class B4XSerializator {
    private OutputStream out;
    private DataInputStream in;
    private ByteBuffer bb = ByteBuffer.wrap(new byte[8]);
    private static final byte T_NULL = 0;
    private static final byte T_STRING = 1;
    private static final byte T_SHORT = 2;
    private static final byte T_INT = 3;
    private static final byte T_LONG = 4;
    private static final byte T_FLOAT = 5;
    private static final byte T_DOUBLE = 6;
    private static final byte T_BOOLEAN = 7;
    private static final byte T_BYTE = 10;
    private static final byte T_CHAR = 14;
    private static final byte T_MAP = 20;
    private static final byte T_LIST = 21;
    private static final byte T_NSARRAY = 22;
    private static final byte T_NSDATA = 23;
    private static final byte T_TYPE = 24;

    public B4XSerializator() {
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
    }

    public byte[] ConvertObjectToBytes(Object Object2) throws IOException {
        return this.WriteObject(Object2);
    }

    public Object ConvertBytesToObject(byte[] Bytes) throws IOException {
        return this.ReadObject(Bytes);
    }

    @BA.Hide
    public byte[] WriteObject(Object Object2) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.out = new DeflaterOutputStream(bout);
        this.writeObject(Object2);
        this.out.close();
        return bout.toByteArray();
    }

    @BA.Hide
    public Object ReadObject(byte[] arr) throws IOException {
        this.in = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(arr)));
        Object ret = this.readObject();
        this.in.close();
        return ret;
    }

    private void writeInt(int i) throws IOException {
        this.bb.putInt(0, i);
        this.out.write(this.bb.array(), 0, 4);
    }

    private int readInt() throws IOException {
        this.in.readFully(this.bb.array(), 0, 4);
        return this.bb.getInt(0);
    }

    private byte readByte() throws IOException {
        return this.in.readByte();
    }

    private void writeByte(byte b) throws IOException {
        this.out.write(b);
    }

    private void writeObject(Object o) throws IOException {
        if (o instanceof ObjectWrapper) {
            o = ((ObjectWrapper)o).getObject();
        }
        if (o == null) {
            this.writeByte((byte)0);
        } else if (o instanceof Number) {
            if (o instanceof Integer) {
                this.writeByte((byte)3);
                this.writeInt((Integer)o);
            } else if (o instanceof Double) {
                this.writeByte((byte)6);
                this.bb.putDouble(0, (Double)o);
                this.out.write(this.bb.array(), 0, 8);
            } else if (o instanceof Float) {
                this.writeByte((byte)5);
                this.bb.putFloat(0, ((Float)o).floatValue());
                this.out.write(this.bb.array(), 0, 4);
            } else if (o instanceof Long) {
                this.writeByte((byte)4);
                this.bb.putLong(0, (Long)o);
                this.out.write(this.bb.array(), 0, 8);
            } else if (o instanceof Byte) {
                this.writeByte((byte)10);
                this.writeByte((Byte)o);
            } else if (o instanceof Short) {
                this.writeByte((byte)2);
                this.bb.putShort(0, (Short)o);
                this.out.write(this.bb.array(), 0, 2);
            }
        } else if (o instanceof Character) {
            this.writeByte((byte)14);
            this.bb.putChar(0, ((Character)o).charValue());
            this.out.write(this.bb.array(), 0, 2);
        } else if (o instanceof Boolean) {
            this.writeByte((byte)7);
            boolean b = (Boolean)o;
            this.writeByte((byte)(b ? 1 : 0));
        } else if (o instanceof String) {
            this.writeByte((byte)1);
            byte[] temp = ((String)o).getBytes("UTF8");
            this.writeInt(temp.length);
            this.out.write(temp);
        } else if (o instanceof List) {
            this.writeByte((byte)21);
            this.writeList((List)o);
        } else if (o instanceof Map) {
            this.writeByte((byte)20);
            this.writeMap((Map)o);
        } else if (o.getClass().isArray()) {
            if (o.getClass().getComponentType() == Byte.TYPE) {
                this.writeByte((byte)23);
                byte[] b = (byte[])o;
                this.writeInt(b.length);
                this.out.write(b);
            } else {
                if (o.getClass().getComponentType().isPrimitive()) {
                    throw new RuntimeException("This method does not support arrays of primitives.");
                }
                this.writeByte((byte)22);
                Object[] oo = (Object[])o;
                this.writeList(Arrays.asList(oo));
            }
        } else {
            this.writeByte((byte)24);
            this.writeType(o);
        }
    }

    private Map<?, ?> readMap() throws IOException {
        int len = this.readInt();
        Map.MyMap mm = new Map.MyMap();
        int i = 0;
        while (i < len) {
            mm.put(this.readObject(), this.readObject());
            ++i;
        }
        return mm;
    }

    private void writeMap(Map<?, ?> m) throws IOException {
        this.writeInt(m.size());
        for (Map.Entry<?, ?> e : m.entrySet()) {
            this.writeObject(e.getKey());
            this.writeObject(e.getValue());
        }
    }

    private ArrayList<?> readList() throws IOException {
        int len = this.readInt();
        ArrayList<Object> arr = new ArrayList<Object>(len);
        int i = 0;
        while (i < len) {
            arr.add(this.readObject());
            ++i;
        }
        return arr;
    }

    private void writeList(List<?> list) throws IOException {
        this.writeInt(list.size());
        for (Object o : list) {
            this.writeObject(o);
        }
    }

    private void writeType(Object target) throws IOException {
        Field[] fields = RandomAccessFile.isB4XType(target);
        if (fields == null) {
            throw new RuntimeException("Cannot serialize object: " + String.valueOf(target));
        }
        try {
            this.writeObject(target.getClass().getName());
            Map.MyMap map = new Map.MyMap();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                f.setAccessible(true);
                map.put(f.getName(), f.get(target));
                ++n2;
            }
            this.writeMap(map);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object readType() {
        try {
            String cls = (String)this.readObject();
            Class<?> c = RandomAccessFile.readTypeClass(cls);
            Map.MyMap map = (Map.MyMap)this.readMap();
            Object o = c.newInstance();
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Object val = map.get(f.getName());
                if (val == null) {
                    val = map.get("_" + f.getName());
                }
                if (val != null) {
                    f.setAccessible(true);
                    if (f.getType() == anywheresoftware.b4a.objects.collections.List.class) {
                        val = AbsObjectWrapper.ConvertToWrapper(new anywheresoftware.b4a.objects.collections.List(), val);
                    } else if (f.getType() == anywheresoftware.b4a.objects.collections.Map.class) {
                        val = AbsObjectWrapper.ConvertToWrapper(new anywheresoftware.b4a.objects.collections.Map(), val);
                    } else if (f.getType() == Boolean.TYPE && !(val instanceof Boolean)) {
                        val = ((Number)val).intValue() == 1;
                    }
                    f.set(o, val);
                }
                ++n2;
            }
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object readObject() throws IOException {
        byte t = this.readByte();
        switch (t) {
            case 0: {
                return null;
            }
            case 3: {
                return this.readInt();
            }
            case 2: {
                this.in.readFully(this.bb.array(), 0, 2);
                return this.bb.getShort(0);
            }
            case 4: {
                this.in.readFully(this.bb.array(), 0, 8);
                return this.bb.getLong(0);
            }
            case 5: {
                this.in.readFully(this.bb.array(), 0, 4);
                return Float.valueOf(this.bb.getFloat(0));
            }
            case 6: {
                this.in.readFully(this.bb.array(), 0, 8);
                return this.bb.getDouble(0);
            }
            case 7: {
                if (this.readByte() == 1) {
                    return true;
                }
                return false;
            }
            case 10: {
                return this.readByte();
            }
            case 1: {
                int len = this.readInt();
                byte[] b = new byte[len];
                this.in.readFully(b);
                return new String(b, "UTF8");
            }
            case 14: {
                this.in.readFully(this.bb.array(), 0, 2);
                return Character.valueOf(this.bb.getChar(0));
            }
            case 21: {
                return this.readList();
            }
            case 20: {
                return this.readMap();
            }
            case 23: {
                int len = this.readInt();
                byte[] b = new byte[len];
                this.in.readFully(b);
                return b;
            }
            case 22: {
                ArrayList<?> list = this.readList();
                return list.toArray();
            }
            case 24: {
                return this.readType();
            }
        }
        throw new RuntimeException("Unsupported type: " + t);
    }
}

