/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

@BA.ShortName(value="MqttClient")
@BA.Version(value=1.0f)
public class MqttAsyncClientWrapper {
    @BA.Hide
    public MqttAsyncClient client;
    private BA ba;
    private String eventName;

    public boolean IsInitialized() {
        return this.client != null;
    }

    public void Initialize(final BA ba, String EventName, String ServerURI, String ClientId) throws MqttException {
        this.ba = ba;
        this.eventName = EventName.toLowerCase(BA.cul);
        this.client = new MqttAsyncClient(ServerURI, ClientId, new MemoryPersistence());
        this.client.setCallback(new MqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
                ba.raiseEventFromDifferentThread((Object)MqttAsyncClientWrapper.this.client, (Object)null, 0, String.valueOf(MqttAsyncClientWrapper.this.eventName) + "_messagearrived", false, new Object[]{topic, message.getPayload()});
            }

            @Override
            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            @Override
            public void connectionLost(Throwable cause) {
                MqttAsyncClientWrapper.this.setThrowable(cause);
                ba.raiseEventFromDifferentThread((Object)MqttAsyncClientWrapper.this.client, (Object)null, 0, String.valueOf(MqttAsyncClientWrapper.this.eventName) + "_disconnected", false, (Object[])null);
            }
        });
    }

    public void Connect() throws MqttSecurityException, MqttException {
        this.Connect2(new MqttConnectOptions());
    }

    public void Connect2(MqttConnectOptions Options) throws MqttSecurityException, MqttException {
        this.client.connect(Options, null, new IMqttActionListener(){

            @Override
            public void onSuccess(IMqttToken asyncActionToken) {
                MqttAsyncClientWrapper.this.ba.raiseEventFromDifferentThread((Object)MqttAsyncClientWrapper.this.client, (Object)null, 0, String.valueOf(MqttAsyncClientWrapper.this.eventName) + "_connected", false, new Object[]{true});
            }

            @Override
            public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                MqttAsyncClientWrapper.this.setThrowable(exception);
                MqttAsyncClientWrapper.this.ba.raiseEventFromDifferentThread((Object)MqttAsyncClientWrapper.this.client, (Object)null, 0, String.valueOf(MqttAsyncClientWrapper.this.eventName) + "_connected", false, new Object[]{false});
            }
        });
    }

    public boolean getConnected() {
        return this.client != null && this.client.isConnected();
    }

    public String getClientId() {
        return this.client.getClientId();
    }

    public void Subscribe(String Topic, int QOS) throws MqttException {
        this.client.subscribe(Topic, QOS);
    }

    public void Unsubscribe(String Topic) throws MqttException {
        this.client.unsubscribe(Topic);
    }

    public void Publish(String Topic, byte[] Payload) throws MqttPersistenceException, MqttException {
        this.Publish2(Topic, Payload, 1, false);
    }

    public void Publish2(String Topic, byte[] Payload, int QOS, boolean Retained) throws MqttPersistenceException, MqttException {
        this.client.publish(Topic, Payload, QOS, Retained);
    }

    public void Close() throws MqttException {
        if (this.client == null) {
            return;
        }
        this.client.disconnectForcibly();
        this.client.close();
        this.client = null;
    }

    private void setThrowable(Throwable t) {
        if (t instanceof Exception) {
            this.ba.setLastException((Exception)t);
        }
    }

    @BA.ShortName(value="MqttConnectOptions")
    public static class MqttConnectOptionsWrapper
    extends AbsObjectWrapper<MqttConnectOptions> {
        public void Initialize() {
            this.setObject(new MqttConnectOptions());
        }

        public String getPassword() {
            return new String(((MqttConnectOptions)this.getObject()).getPassword());
        }

        public void setPassword(String s) {
            ((MqttConnectOptions)this.getObject()).setPassword(s.toCharArray());
        }

        public String getUserName() {
            return ((MqttConnectOptions)this.getObject()).getUserName();
        }

        public void setUserName(String s) {
            ((MqttConnectOptions)this.getObject()).setUserName(s);
        }

        public boolean getCleanSession() {
            return ((MqttConnectOptions)this.getObject()).isCleanSession();
        }

        public void setCleanSession(boolean b) {
            ((MqttConnectOptions)this.getObject()).setCleanSession(b);
        }
    }
}

