/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttConnect
extends MqttWireMessage {
    public static final String KEY = "Con";
    private String clientId;
    private boolean cleanSession;
    private MqttMessage willMessage;
    private String userName;
    private char[] password;
    private int keepAliveInterval;
    private String willDestination;
    private int MqttVersion;

    public MqttConnect(byte info, byte[] data) throws IOException, MqttException {
        super((byte)1);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        String protocol_name = this.decodeUTF8(dis);
        byte protocol_version = dis.readByte();
        byte connect_flags = dis.readByte();
        this.keepAliveInterval = dis.readUnsignedShort();
        this.clientId = this.decodeUTF8(dis);
        dis.close();
    }

    public MqttConnect(String clientId, int MqttVersion, boolean cleanSession, int keepAliveInterval, String userName, char[] password, MqttMessage willMessage, String willDestination) {
        super((byte)1);
        this.clientId = clientId;
        this.cleanSession = cleanSession;
        this.keepAliveInterval = keepAliveInterval;
        this.userName = userName;
        this.password = password;
        this.willMessage = willMessage;
        this.willDestination = willDestination;
        this.MqttVersion = MqttVersion;
    }

    @Override
    public String toString() {
        String rc = super.toString();
        rc = String.valueOf(rc) + " clientId " + this.clientId + " keepAliveInterval " + this.keepAliveInterval;
        return rc;
    }

    @Override
    protected byte getMessageInfo() {
        return 0;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            if (this.MqttVersion == 3) {
                this.encodeUTF8(dos, "MQIsdp");
            } else if (this.MqttVersion == 4) {
                this.encodeUTF8(dos, "MQTT");
            }
            dos.write(this.MqttVersion);
            int connectFlags = 0;
            if (this.cleanSession) {
                connectFlags = (byte)(connectFlags | 2);
            }
            if (this.willMessage != null) {
                connectFlags = (byte)(connectFlags | 4);
                connectFlags = (byte)(connectFlags | this.willMessage.getQos() << 3);
                if (this.willMessage.isRetained()) {
                    connectFlags = (byte)(connectFlags | 0x20);
                }
            }
            if (this.userName != null) {
                connectFlags = (byte)(connectFlags | 0x80);
                if (this.password != null) {
                    connectFlags = (byte)(connectFlags | 0x40);
                }
            }
            dos.write(connectFlags);
            dos.writeShort(this.keepAliveInterval);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    @Override
    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            this.encodeUTF8(dos, this.clientId);
            if (this.willMessage != null) {
                this.encodeUTF8(dos, this.willDestination);
                dos.writeShort(this.willMessage.getPayload().length);
                dos.write(this.willMessage.getPayload());
            }
            if (this.userName != null) {
                this.encodeUTF8(dos, this.userName);
                if (this.password != null) {
                    this.encodeUTF8(dos, new String(this.password));
                }
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return false;
    }

    @Override
    public String getKey() {
        return KEY;
    }
}

