/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class MqttInputStream
extends InputStream {
    private static final String CLASS_NAME = MqttInputStream.class.getName();
    private static final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private ClientState clientState = null;
    private DataInputStream in;

    public MqttInputStream(ClientState clientState, InputStream in) {
        this.clientState = clientState;
        this.in = new DataInputStream(in);
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public MqttWireMessage readMqttWireMessage() throws IOException, MqttException {
        String methodName = "readMqttWireMessage";
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        byte first = this.in.readByte();
        this.clientState.notifyReceivedBytes(1);
        byte type = (byte)(first >>> 4 & 0xF);
        if (type < 1 || type > 14) {
            throw ExceptionHelper.createMqttException(32108);
        }
        long remLen = MqttWireMessage.readMBI(this.in).getValue();
        bais.write(first);
        bais.write(MqttWireMessage.encodeMBI(remLen));
        byte[] packet = new byte[(int)((long)bais.size() + remLen)];
        this.readFully(packet, bais.size(), packet.length - bais.size());
        byte[] header = bais.toByteArray();
        System.arraycopy(header, 0, packet, 0, header.length);
        MqttWireMessage message = MqttWireMessage.createWireMessage(packet);
        log.fine(CLASS_NAME, "readMqttWireMessage", "501", new Object[]{message});
        return message;
    }

    private void readFully(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = 0;
        while (n < len) {
            int count = this.in.read(b, off + n, len - n);
            this.clientState.notifyReceivedBytes(count);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }
}

