/*
 * Decompiled with CFR 0.152.
 */
package anywhersoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

@BA.ShortName(value="WebSocketClient")
@BA.Version(value=1.0f)
public class WebSocketClientWrapper {
    private BA ba;
    private String eventName;
    @BA.Hide
    public WebSocketClient wsc;
    @BA.Hide
    public Future<Session> session;

    public void Initialize(BA ba, String EventName) {
        this.wsc = new WebSocketClient();
        this.eventName = EventName.toLowerCase(BA.cul);
        this.ba = ba;
    }

    public void Connect(final String Url) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    WebSocketClientWrapper.this.wsc.start();
                    URI echoUri = new URI(Url);
                    ClientUpgradeRequest request = new ClientUpgradeRequest();
                    WebSocketClientWrapper.this.session = WebSocketClientWrapper.this.wsc.connect((Object)new WSHandler(), echoUri, request);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
    }

    public boolean getConnected() throws InterruptedException {
        try {
            return this.session != null && this.session.isDone() && this.session.get().isOpen();
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    public void Close() throws Exception {
        if (this.session != null && this.session.isDone()) {
            this.session.get().close();
        }
        if (this.wsc.isRunning()) {
            BA.submitRunnable((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        WebSocketClientWrapper.this.wsc.stop();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, null, (int)0);
        }
    }

    public void SendText(String Text) throws IOException, InterruptedException, ExecutionException {
        this.session.get().getRemote().sendString(Text);
    }

    @BA.Hide
    public class WSHandler
    extends WebSocketAdapter {
        public void onWebSocketConnect(Session sess) {
            super.onWebSocketConnect(sess);
            WebSocketClientWrapper.this.ba.raiseEventFromDifferentThread((Object)WebSocketClientWrapper.this, null, 0, String.valueOf(WebSocketClientWrapper.this.eventName) + "_connected", false, null);
        }

        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            WebSocketClientWrapper.this.ba.raiseEventFromDifferentThread((Object)WebSocketClientWrapper.this, null, 0, String.valueOf(WebSocketClientWrapper.this.eventName) + "_closed", false, new Object[]{BA.ReturnString((String)reason)});
        }

        public void onWebSocketError(Throwable cause) {
            super.onWebSocketError(cause);
            cause.printStackTrace();
            try {
                WebSocketClientWrapper.this.Close();
                this.onWebSocketClose(0, cause.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onWebSocketText(String message) {
            WebSocketClientWrapper.this.ba.raiseEventFromDifferentThread((Object)WebSocketClientWrapper.this, null, 0, String.valueOf(WebSocketClientWrapper.this.eventName) + "_textmessage", false, new Object[]{message});
        }
    }
}

