/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.object;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@BA.ShortName(value="JavaObject")
@BA.Version(value=2.02f)
public class JavaObject
extends AbsObjectWrapper<Object> {
    private static final FieldCache fieldCache = new FieldCache();
    private static final MethodCache methodCache = new MethodCache();
    private static final HashMap<String, Class<?>> primitives = new HashMap();
    private static final HashMap<Class<?>, Class<?>> primitiveToBoxed = new HashMap();
    private static Field context;

    static {
        primitiveToBoxed.put(Byte.TYPE, Byte.class);
        primitiveToBoxed.put(Character.TYPE, Character.class);
        primitiveToBoxed.put(Short.TYPE, Short.class);
        primitiveToBoxed.put(Integer.TYPE, Integer.class);
        primitiveToBoxed.put(Long.TYPE, Long.class);
        primitiveToBoxed.put(Float.TYPE, Float.class);
        primitiveToBoxed.put(Double.TYPE, Double.class);
        primitiveToBoxed.put(Boolean.TYPE, Boolean.class);
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("boolean", Boolean.TYPE);
    }

    public JavaObject InitializeContext(BA ba) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        BA aba;
        Object shared = BA.class.getDeclaredField("sharedProcessBA").get(ba);
        WeakReference activityBA = (WeakReference)shared.getClass().getDeclaredField("activityBA").get(shared);
        if (activityBA != null && (aba = (BA)activityBA.get()) != null) {
            ba = aba;
        }
        if (context == null) {
            context = BA.class.getDeclaredField("context");
        }
        this.setObject(context.get(ba));
        return this;
    }

    public JavaObject InitializeStatic(String ClassName) throws ClassNotFoundException {
        this.setObject(JavaObject.getCorrectClassName(ClassName));
        return this;
    }

    public JavaObject InitializeNewInstance(String ClassName, Object[] Params) throws Exception {
        Class<?> cls = JavaObject.getCorrectClassName(ClassName);
        if (Params != null && Params.length != 0) {
            Constructor<?>[] constructorArray = cls.getConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> c = constructorArray[n2];
                Class<?>[] mTypes = c.getParameterTypes();
                if (this.arrangeAndCheckMatch(mTypes, Params)) {
                    this.setObject(c.newInstance(Params));
                    return this;
                }
                ++n2;
            }
            throw new RuntimeException("Constructor not found.");
        }
        this.setObject(cls.newInstance());
        return this;
    }

    public JavaObject InitializeArray(String ClassName, Object[] Values2) throws ClassNotFoundException {
        boolean primitive;
        Class<?> c = primitives.get(ClassName);
        boolean bl = primitive = c != null;
        if (!primitive) {
            c = JavaObject.getCorrectClassName(ClassName);
        }
        Object arr = Array.newInstance(c, Values2.length);
        int i = 0;
        while (i < Values2.length) {
            Array.set(arr, i, Values2[i]);
            ++i;
        }
        this.setObject(arr);
        return this;
    }

    public Object RunMethod(String MethodName, Object[] Params) throws Exception {
        Class<?> cls = this.getCurrentClass();
        List<Method> mm = methodCache.getMethod(cls.getName(), MethodName, Params);
        Method method = null;
        for (Method m : mm) {
            Class<?>[] mTypes = m.getParameterTypes();
            if (!this.arrangeAndCheckMatch(mTypes, Params)) continue;
            method = m;
            break;
        }
        if (method == null) {
            throw new RuntimeException("Method: " + MethodName + " not matched.");
        }
        method.setAccessible(true);
        return method.invoke(this.getObject(), Params);
    }

    public JavaObject RunMethodJO(String MethodName, Object[] Params) throws Exception {
        return (JavaObject)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new JavaObject(), (Object)this.RunMethod(MethodName, Params));
    }

    private boolean arrangeAndCheckMatch(Class<?>[] mTypes, Object[] Params) {
        if (Params == null) {
            return mTypes.length == 0;
        }
        if (Params.length != mTypes.length) {
            return false;
        }
        int i = 0;
        while (i < Params.length) {
            if (Params[i] != null) {
                Class<?> p = Params[i].getClass();
                if (mTypes[i].isPrimitive()) {
                    mTypes[i] = primitiveToBoxed.get(mTypes[i]);
                }
                if (mTypes[i].isEnum() && p == String.class) {
                    Params[i] = Enum.valueOf(mTypes[i], (String)Params[i]);
                } else if (!mTypes[i].isAssignableFrom(p)) break;
            }
            ++i;
        }
        return i == Params.length;
    }

    public void SetField(String FieldName, Object Value) throws Exception {
        Class<?> cls = this.getCurrentClass();
        Field field = fieldCache.getField(cls.getName(), FieldName);
        field.set(this.getObject(), Value);
    }

    public Object GetField(String Field2) throws Exception {
        Class<?> cls = this.getCurrentClass();
        Field field = fieldCache.getField(cls.getName(), Field2);
        return field.get(this.getObject());
    }

    public JavaObject GetFieldJO(String Field2) throws Exception {
        return (JavaObject)AbsObjectWrapper.ConvertToWrapper((ObjectWrapper)new JavaObject(), (Object)this.GetField(Field2));
    }

    public Object CreateEvent(BA ba, String Interface, String EventName, Object DefaultReturnValue) throws Exception {
        return this.createEvent(ba, Interface, EventName, false, DefaultReturnValue);
    }

    public Object CreateEventFromUI(BA ba, String Interface, String EventName, Object ReturnValue) throws Exception {
        return this.createEvent(ba, Interface, EventName, true, ReturnValue);
    }

    private Object createEvent(final BA ba, String Interface, String EventName, final boolean fromUi, final Object returnValue) throws Exception {
        final Object obj = this.getObject();
        InvocationHandler handler = new InvocationHandler(EventName){
            String eventName;
            Thread t;
            {
                this.eventName = String.valueOf(string.toLowerCase(BA.cul)) + "_event";
                this.t = Thread.currentThread();
            }

            @Override
            public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
                Object[] params = new Object[]{arg1.getName(), arg2};
                if (Thread.currentThread() == this.t) {
                    if (!fromUi) {
                        Object ret = ba.raiseEvent(obj, this.eventName, params);
                        return ret == null ? returnValue : ret;
                    }
                    ba.raiseEventFromUI(obj, this.eventName, params);
                    return returnValue;
                }
                ba.raiseEventFromDifferentThread(obj, null, 0, this.eventName, false, params);
                return returnValue;
            }
        };
        Class<?> inter = JavaObject.getCorrectClassName(Interface);
        return Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{inter}, handler);
    }

    private Class<?> getCurrentClass() {
        if (this.getObject() instanceof Class) {
            return (Class)this.getObject();
        }
        return this.getObject().getClass();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Class<?> getCorrectClassName(String className) throws ClassNotFoundException {
        if (className.equals("Object")) {
            return Object.class;
        }
        if (className.equals("String")) {
            return String.class;
        }
        Class<?> cls = null;
        int i = 0;
        while (i < 3) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException c) {
                int dot = className.lastIndexOf(".");
                if (dot == -1) {
                    if (i != 0) throw c;
                    className = "java.lang." + className;
                } else {
                    className = String.valueOf(className.substring(0, dot)) + "$" + className.substring(dot + 1);
                }
                ++i;
            }
        }
        throw new ClassNotFoundException(className);
    }

    static class FieldCache {
        private HashMap<String, HashMap<String, Field>> cache = new HashMap();

        FieldCache() {
        }

        public Field getField(String className, String fieldName) throws Exception {
            Field m;
            HashMap<String, Field> classFields = this.cache.get(className);
            if (classFields == null) {
                classFields = new HashMap();
                this.cache.put(className, classFields);
                Field[] fieldArray = Class.forName(className).getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    m = fieldArray[n2];
                    classFields.put(m.getName(), m);
                    ++n2;
                }
            }
            if ((m = classFields.get(fieldName)) == null) {
                throw new RuntimeException("Field: " + fieldName + " not found in: " + className);
            }
            return m;
        }
    }

    static class MethodCache {
        private HashMap<String, HashMap<String, ArrayList<Method>>> cache = new HashMap();
        private static final HashMap<String, ArrayList<Method>> cantGetAllMethods = new HashMap();

        MethodCache() {
        }

        public List<Method> getMethod(String className, String methodName, Object[] params) throws Exception {
            ArrayList<Method> m;
            HashMap<String, ArrayList<Method>> classMethods = this.cache.get(className);
            if (classMethods == null) {
                classMethods = new HashMap();
                this.cache.put(className, classMethods);
                Method[] methods = null;
                try {
                    methods = Class.forName(className).getMethods();
                }
                catch (Throwable e) {
                    BA.LogError((String)("Cannot get methods of class: " + className + ", disabling cache."));
                    this.cache.put(className, cantGetAllMethods);
                    classMethods = cantGetAllMethods;
                }
                if (methods != null) {
                    Method[] methodArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method m2 = methodArray[n2];
                        ArrayList<Method> overloaded = classMethods.get(m2.getName());
                        if (overloaded == null) {
                            overloaded = new ArrayList();
                            classMethods.put(m2.getName(), overloaded);
                        }
                        overloaded.add(m2);
                        ++n2;
                    }
                }
            }
            if (classMethods == cantGetAllMethods) {
                Class<?> cls = Class.forName(className);
                Class[] paramTypes = new Class[params.length];
                int i = 0;
                while (i < params.length) {
                    paramTypes[i] = params[i] == null ? Object.class : params[i].getClass();
                    ++i;
                }
                i = 0;
                while (i < params.length) {
                    try {
                        return Arrays.asList(cls.getMethod(methodName, paramTypes));
                    }
                    catch (NoSuchMethodException nsme) {
                        Class orig = paramTypes[i];
                        Class parent = paramTypes[i].getSuperclass();
                        if (parent != null) {
                            paramTypes[i] = parent;
                            try {
                                return Arrays.asList(cls.getMethod(methodName, paramTypes));
                            }
                            catch (NoSuchMethodException nsme2) {
                                paramTypes[i] = orig;
                            }
                        }
                        ++i;
                    }
                }
            }
            if ((m = classMethods.get(methodName)) == null) {
                throw new RuntimeException("Method: " + methodName + " not found in: " + className);
            }
            return m;
        }
    }
}

