/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.persist;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.internal.FileLock;
import org.eclipse.paho.client.mqttv3.internal.MqttPersistentData;

public class MqttDefaultFilePersistence
implements MqttClientPersistence {
    private static final String MESSAGE_FILE_EXTENSION = ".msg";
    private static final String MESSAGE_BACKUP_FILE_EXTENSION = ".bup";
    private static final String LOCK_FILENAME = ".lck";
    private File dataDir;
    private File clientDir = null;
    private FileLock fileLock = null;
    private static final FilenameFilter FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(MqttDefaultFilePersistence.MESSAGE_FILE_EXTENSION);
        }
    };

    public MqttDefaultFilePersistence() {
        this(System.getProperty("user.dir"));
    }

    public MqttDefaultFilePersistence(String directory) {
        this.dataDir = new File(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String clientId, String theConnection) throws MqttPersistenceException {
        char c;
        if (this.dataDir.exists() && !this.dataDir.isDirectory()) {
            throw new MqttPersistenceException();
        }
        if (!this.dataDir.exists() && !this.dataDir.mkdirs()) {
            throw new MqttPersistenceException();
        }
        if (!this.dataDir.canWrite()) {
            throw new MqttPersistenceException();
        }
        StringBuffer keyBuffer = new StringBuffer();
        int i = 0;
        while (i < clientId.length()) {
            c = clientId.charAt(i);
            if (this.isSafeChar(c)) {
                keyBuffer.append(c);
            }
            ++i;
        }
        keyBuffer.append("-");
        i = 0;
        while (i < theConnection.length()) {
            c = theConnection.charAt(i);
            if (this.isSafeChar(c)) {
                keyBuffer.append(c);
            }
            ++i;
        }
        MqttDefaultFilePersistence mqttDefaultFilePersistence = this;
        synchronized (mqttDefaultFilePersistence) {
            if (this.clientDir == null) {
                String key = keyBuffer.toString();
                this.clientDir = new File(this.dataDir, key);
                if (!this.clientDir.exists()) {
                    this.clientDir.mkdir();
                }
            }
            try {
                this.fileLock = new FileLock(this.clientDir, LOCK_FILENAME);
            }
            catch (Exception e) {
                throw new MqttPersistenceException(32200);
            }
            this.restoreBackups(this.clientDir);
        }
    }

    private void checkIsOpen() throws MqttPersistenceException {
        if (this.clientDir == null) {
            throw new MqttPersistenceException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MqttPersistenceException {
        MqttDefaultFilePersistence mqttDefaultFilePersistence = this;
        synchronized (mqttDefaultFilePersistence) {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            if (this.getFiles().length == 0) {
                this.clientDir.delete();
            }
            this.clientDir = null;
        }
    }

    @Override
    public void put(String key, MqttPersistable message) throws MqttPersistenceException {
        boolean result;
        this.checkIsOpen();
        File file = new File(this.clientDir, String.valueOf(key) + MESSAGE_FILE_EXTENSION);
        File backupFile = new File(this.clientDir, String.valueOf(key) + MESSAGE_FILE_EXTENSION + MESSAGE_BACKUP_FILE_EXTENSION);
        if (file.exists() && !(result = file.renameTo(backupFile))) {
            backupFile.delete();
            file.renameTo(backupFile);
        }
        try {
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(message.getHeaderBytes(), message.getHeaderOffset(), message.getHeaderLength());
                if (message.getPayloadBytes() != null) {
                    fos.write(message.getPayloadBytes(), message.getPayloadOffset(), message.getPayloadLength());
                }
                fos.getFD().sync();
                fos.close();
                if (backupFile.exists()) {
                    backupFile.delete();
                }
            }
            catch (IOException ex) {
                throw new MqttPersistenceException(ex);
            }
        }
        finally {
            boolean result2;
            if (backupFile.exists() && !(result2 = backupFile.renameTo(file))) {
                file.delete();
                backupFile.renameTo(file);
            }
        }
    }

    @Override
    public MqttPersistable get(String key) throws MqttPersistenceException {
        MqttPersistentData result;
        this.checkIsOpen();
        try {
            File file = new File(this.clientDir, String.valueOf(key) + MESSAGE_FILE_EXTENSION);
            FileInputStream fis = new FileInputStream(file);
            int size = fis.available();
            byte[] data = new byte[size];
            int read = 0;
            while (read < size) {
                read += fis.read(data, read, size - read);
            }
            fis.close();
            result = new MqttPersistentData(key, data, 0, data.length, null, 0, 0);
        }
        catch (IOException ex) {
            throw new MqttPersistenceException(ex);
        }
        return result;
    }

    @Override
    public void remove(String key) throws MqttPersistenceException {
        this.checkIsOpen();
        File file = new File(this.clientDir, String.valueOf(key) + MESSAGE_FILE_EXTENSION);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public Enumeration keys() throws MqttPersistenceException {
        this.checkIsOpen();
        File[] files = this.getFiles();
        Vector<String> result = new Vector<String>(files.length);
        int i = 0;
        while (i < files.length) {
            String filename = files[i].getName();
            String key = filename.substring(0, filename.length() - MESSAGE_FILE_EXTENSION.length());
            result.addElement(key);
            ++i;
        }
        return result.elements();
    }

    private File[] getFiles() throws MqttPersistenceException {
        this.checkIsOpen();
        File[] files = this.clientDir.listFiles(FILE_FILTER);
        if (files == null) {
            throw new MqttPersistenceException();
        }
        return files;
    }

    private boolean isSafeChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    private void restoreBackups(File dir) throws MqttPersistenceException {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(MqttDefaultFilePersistence.MESSAGE_BACKUP_FILE_EXTENSION);
            }
        });
        if (files == null) {
            throw new MqttPersistenceException();
        }
        int i = 0;
        while (i < files.length) {
            File originalFile = new File(dir, files[i].getName().substring(0, files[i].getName().length() - MESSAGE_BACKUP_FILE_EXTENSION.length()));
            boolean result = files[i].renameTo(originalFile);
            if (!result) {
                originalFile.delete();
                files[i].renameTo(originalFile);
            }
            ++i;
        }
    }

    @Override
    public boolean containsKey(String key) throws MqttPersistenceException {
        this.checkIsOpen();
        File file = new File(this.clientDir, String.valueOf(key) + MESSAGE_FILE_EXTENSION);
        return file.exists();
    }

    @Override
    public void clear() throws MqttPersistenceException {
        this.checkIsOpen();
        File[] files = this.getFiles();
        int i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
    }
}

