/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a;

import anywheresoftware.b4a.pc.RDebug;
import anywheresoftware.b4a.pc.RemoteObject;

public class BA {
    public static RemoteObject deviceBA = RemoteObject.declareNull("anywheresoftware.b4a.BA");
    public static RemoteObject rdebugUtils = RemoteObject.declareNull("anywheresoftware.b4a.debug.RDebugUtils");
    public static int debugLineNum;
    public static String debugLine;

    public static RemoteObject NumberToString(RemoteObject ro) throws Exception {
        if (ro.wrappedValue != null) {
            if (ro.wrappedValue instanceof Long) {
                return BA.NumberToString((Long)ro.wrappedValue);
            }
            if (ro.wrappedValue instanceof Integer) {
                return BA.NumberToString((Integer)ro.wrappedValue);
            }
            return BA.NumberToString(((Number)ro.wrappedValue).doubleValue());
        }
        return deviceBA.runMethod(true, "NumberToString", ro);
    }

    public static RemoteObject NumberToString(double value) {
        String s = Double.toString(value);
        if (s.length() > 2 && s.charAt(s.length() - 2) == '.' && s.charAt(s.length() - 1) == '0') {
            return RemoteObject.createImmutable(s.substring(0, s.length() - 2));
        }
        return RemoteObject.createImmutable(s);
    }

    public static RemoteObject NumberToString(long value) {
        return RemoteObject.createImmutable(String.valueOf(value));
    }

    private static RemoteObject NumberToString(int value) {
        return RemoteObject.createImmutable(String.valueOf(value));
    }

    public static RemoteObject numberCast(Class<?> outputType, Object obj) throws Exception {
        Object wrappedValue = null;
        wrappedValue = obj instanceof RemoteObject ? ((RemoteObject)obj).wrappedValue : obj;
        if (wrappedValue != null) {
            Number value = wrappedValue instanceof Number ? (Number)((Number)wrappedValue) : (Number)(wrappedValue instanceof String ? (Number)Double.parseDouble((String)wrappedValue) : (Number)(Long.TYPE.equals(outputType) ? (Number)Long.parseLong(String.valueOf(wrappedValue)) : (Number)Double.parseDouble(String.valueOf(wrappedValue))));
            if (outputType.isInstance(value) && obj instanceof RemoteObject) {
                return (RemoteObject)obj;
            }
            if (Byte.TYPE.equals(outputType)) {
                return RemoteObject.createImmutable(value.byteValue());
            }
            if (Short.TYPE.equals(outputType)) {
                return RemoteObject.createImmutable(value.shortValue());
            }
            if (Integer.TYPE.equals(outputType)) {
                return RemoteObject.createImmutable(value.intValue());
            }
            if (Long.TYPE.equals(outputType)) {
                return RemoteObject.createImmutable(value.longValue());
            }
            if (Float.TYPE.equals(outputType)) {
                return RemoteObject.createImmutable(Float.valueOf(value.floatValue()));
            }
            if (Double.TYPE.equals(outputType)) {
                return RemoteObject.createImmutable(value.doubleValue());
            }
            throw new RuntimeException("Unknown type: " + outputType);
        }
        return rdebugUtils.runMethod(true, "numberCast", outputType.getName(), obj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RemoteObject ObjectToChar(Object o) throws Exception {
        Object val;
        if (o instanceof RemoteObject) {
            if (((RemoteObject)o).wrappedValue == null) return deviceBA.runMethod(true, "ObjectToChar", o);
            val = ((RemoteObject)o).wrappedValue;
        } else {
            val = o;
        }
        if (!(val instanceof Character)) return RemoteObject.createImmutable(Character.valueOf(BA.CharFromString(val.toString())));
        return RemoteObject.createImmutable(Character.valueOf(((Character)val).charValue()));
    }

    public static double ObjectToNumber(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return Double.parseDouble(String.valueOf(o));
    }

    public static long ObjectToLongNumber(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(String.valueOf(o));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RemoteObject ObjectToBoolean(Object o) throws Exception {
        Object val;
        if (o instanceof RemoteObject) {
            if (((RemoteObject)o).wrappedValue == null) return deviceBA.runMethod(true, "ObjectToBoolean", o);
            val = ((RemoteObject)o).wrappedValue;
        } else {
            val = o;
        }
        if (!(val instanceof Boolean)) return RemoteObject.createImmutable(BA.parseBoolean(String.valueOf(val)));
        return RemoteObject.createImmutable((boolean)((Boolean)val));
    }

    public static RemoteObject ObjectToString(Object value) throws Exception {
        Object val = value;
        if (value instanceof RemoteObject) {
            RemoteObject ro = (RemoteObject)value;
            if (ro.wrappedValue == null) {
                return rdebugUtils.runMethod(true, "ObjectToString", value);
            }
            val = ro.wrappedValue;
        }
        return RemoteObject.createImmutable(String.valueOf(val));
    }

    public static boolean parseBoolean(String b) {
        if (b.equals("true")) {
            return true;
        }
        if (b.equals("false")) {
            return false;
        }
        throw new RuntimeException("Cannot parse: " + b + " as boolean");
    }

    public static char CharFromString(String s) {
        if (s == null || s.length() == 0) {
            return '\u0000';
        }
        return s.charAt(0);
    }

    public static RemoteObject getEnumFromString(RemoteObject enumType, Object name) throws Exception {
        RemoteObject ro = RemoteObject.declareNull("java.lang.Enum");
        return ro.runMethod(true, "valueOf", enumType, name);
    }

    public static RemoteObject getDeviceClass(String deviceClass) throws Exception {
        RemoteObject ro = RemoteObject.declareNull("java.lang.Class");
        if (RDebug.INSTANCE.B4J) {
            return ro.runMethodAndSync(true, "forName", deviceClass);
        }
        return ro.runMethod(true, "forName", deviceClass);
    }

    public static int switchObjectToInt(Object test, RemoteObject ... values) throws Exception {
        return (Integer)deviceBA.runMethod(true, "switchObjectToInt", test, values).get();
    }
}

