/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a;

import anywheresoftware.b4a.ConnectorConsumer;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;

public class ConnectorUtils {
    public static final byte INT = 1;
    public static final byte STRING = 2;
    public static final byte MAP = 3;
    public static final byte ENDOFMAP = 4;
    public static final byte BOOL = 5;
    public static final byte COLOR = 6;
    public static final byte FLOAT = 7;
    public static final byte SCALED_INT = 8;
    public static final byte CACHED_STRING = 9;
    private static ThreadLocal<ByteBuffer> myBb = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            ByteBuffer bbW = ByteBuffer.allocate(51200);
            bbW.order(ByteOrder.LITTLE_ENDIAN);
            return bbW;
        }
    };
    private static Charset charset = Charset.forName("UTF8");

    public static ByteBuffer startMessage(byte message) {
        ByteBuffer bbW = myBb.get();
        bbW.clear();
        bbW.put(message);
        return bbW;
    }

    public static void sendMessage(ConnectorConsumer consumer) {
        byte[] b;
        if (consumer == null) {
            return;
        }
        ByteBuffer bbW = myBb.get();
        bbW.flip();
        boolean addPrefix = consumer.shouldAddPrefix();
        if (addPrefix) {
            b = new byte[bbW.limit() + 4];
            int size = b.length - 4;
            bbW.get(b, 4, size);
            int i = 0;
            while (i <= 3) {
                b[i] = (byte)(size & 0xFF);
                size >>= 8;
                ++i;
            }
        } else {
            b = new byte[bbW.limit()];
            bbW.get(b);
        }
        consumer.putTask(b);
    }

    public static void writeInt(int i) {
        myBb.get().putInt(i);
    }

    public static void writeFloat(float f) {
        myBb.get().putFloat(f);
    }

    public static void writeByte(byte b) {
        myBb.get().put(b);
    }

    public static void mark() {
        myBb.get().mark();
    }

    public static void resetToMark() {
        myBb.get().reset();
    }

    public static boolean writeString(String str) {
        if (str == null) {
            str = "";
        }
        if (str.length() > 700) {
            str = String.valueOf(str.substring(0, 699)) + "......";
        }
        ByteBuffer bbW = myBb.get();
        int pos = bbW.position();
        ByteBuffer bb = charset.encode(str);
        if (bbW.remaining() - bb.remaining() < 1000) {
            return false;
        }
        bbW.putInt(0);
        bbW.put(bb);
        bbW.putInt(pos, bbW.position() - pos - 4);
        return true;
    }

    public static int readInt(DataInputStream in) throws IOException {
        return Integer.reverseBytes(in.readInt());
    }

    public static String readString(DataInputStream in) throws IOException {
        int size = ConnectorUtils.readInt(in);
        ByteBuffer bb = ByteBuffer.allocate(size);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        in.readFully(bb.array());
        bb.limit(size);
        String s = charset.decode(bb).toString();
        return s;
    }

    private static String readCacheString(DataInputStream din, String[] cache) throws IOException {
        if (cache == null) {
            return ConnectorUtils.readString(din);
        }
        return cache[ConnectorUtils.readInt(din)];
    }

    public static HashMap<String, Object> readMap(DataInputStream in, String[] cache) throws IOException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        while (true) {
            String key = ConnectorUtils.readCacheString(in, cache);
            byte b = in.readByte();
            Serializable value = null;
            if (b == 1) {
                value = ConnectorUtils.readInt(in);
            } else if (b == 9) {
                value = ConnectorUtils.readCacheString(in, cache);
            } else if (b == 2) {
                value = ConnectorUtils.readString(in);
            } else if (b == 7) {
                value = Float.valueOf(Float.intBitsToFloat(ConnectorUtils.readInt(in)));
            } else if (b == 3) {
                value = ConnectorUtils.readMap(in, cache);
            } else if (b == 5) {
                value = in.readByte() == 1;
            } else {
                if (b == 6) {
                    throw new RuntimeException("COLOR type not supported.");
                }
                if (b == 4) break;
                throw new RuntimeException("unknown type");
            }
            props.put(key, value);
        }
        return props;
    }
}

